/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Painter;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.ArrayNodeDiff;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.ColumnController;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomNodeController;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.Row;
import org.virbo.autoplot.dom.RowController;
import org.virbo.autoplot.layout.LayoutConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasController
extends DomNodeController {
    DasCanvas dasCanvas;
    private Application application;
    private Canvas canvas;
    private Timer repaintSoonTimer;
    private List<DomNode> currentSelectionItems;

    public CanvasController(Application dom, Canvas canvas) {
        super(canvas);
        this.application = dom;
        this.canvas = canvas;
        canvas.controller = this;
        this.repaintSoonTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CanvasController.this.dasCanvas.repaint();
            }
        });
        this.repaintSoonTimer.setRepeats(false);
    }

    public void setColumn(String column) {
        String[] ss = column.split(",");
        this.canvas.getMarginColumn().setLeft(ss[0]);
        this.canvas.getMarginColumn().setRight(ss[1]);
        this.canvas.getMarginColumn().setLeft(ss[0]);
    }

    public void setRow(String row) {
        String[] ss = row.split(",");
        this.canvas.getMarginRow().setTop(ss[0]);
        this.canvas.getMarginRow().setBottom(ss[1]);
        this.canvas.getMarginRow().setTop(ss[0]);
    }

    protected void setDasCanvas(DasCanvas canvas) {
        assert (this.dasCanvas != null);
        this.dasCanvas = canvas;
        ApplicationController ac = this.application.controller;
        this.dasCanvas.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                if (CanvasController.this.canvas.getWidth() != CanvasController.this.dasCanvas.getWidth()) {
                    CanvasController.this.canvas.setWidth(CanvasController.this.dasCanvas.getWidth());
                }
                if (CanvasController.this.canvas.getHeight() != CanvasController.this.dasCanvas.getHeight()) {
                    CanvasController.this.canvas.setHeight(CanvasController.this.dasCanvas.getHeight());
                }
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.canvas.addPropertyChangeListener("width", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CanvasController.this.dasCanvas.setPreferredWidth(Math.min(4000, CanvasController.this.canvas.getWidth()));
            }
        });
        this.canvas.addPropertyChangeListener("height", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CanvasController.this.dasCanvas.setPreferredHeight(Math.min(4000, CanvasController.this.canvas.getHeight()));
            }
        });
        ac.bind(this.canvas, "fitted", this.dasCanvas, "fitted");
        ac.bind(this.canvas, "font", this.dasCanvas, "baseFont", DomUtil.STRING_TO_FONT);
    }

    public DasCanvas getDasCanvas() {
        return this.dasCanvas;
    }

    Column getColumn(Column r, Object dir) {
        int idx = this.canvas.columns.indexOf(r);
        if (idx == -1) {
            throw new IllegalArgumentException("canvas doesn't contain this column");
        }
        if (dir == LayoutConstants.LEFT) {
            if (idx == 0) {
                return null;
            }
            return this.canvas.columns.get(idx - 1);
        }
        if (dir == LayoutConstants.RIGHT) {
            if (idx == this.canvas.columns.size() - 1) {
                return null;
            }
            return this.canvas.columns.get(idx + 1);
        }
        throw new IllegalArgumentException("dir must be LEFT or RIGHT");
    }

    Row getRow(Row r, Object dir) {
        int idx = this.canvas.rows.indexOf(r);
        if (idx == -1) {
            throw new IllegalArgumentException("canvas doesn't contain this row");
        }
        if (dir == LayoutConstants.ABOVE) {
            if (idx == 0) {
                return null;
            }
            return this.canvas.rows.get(idx - 1);
        }
        if (dir == LayoutConstants.BELOW) {
            if (idx == this.canvas.rows.size() - 1) {
                return null;
            }
            return this.canvas.rows.get(idx + 1);
        }
        throw new IllegalArgumentException("dir must be ABOVE or BELOW");
    }

    public Row getRowFor(Plot domPlot) {
        if (domPlot.getRowId().equals(this.canvas.marginRow.getId())) {
            return this.canvas.marginRow;
        }
        for (Row row : this.canvas.getRows()) {
            if (!row.getId().equals(domPlot.getRowId())) continue;
            return row;
        }
        throw new IllegalArgumentException("no row found for " + domPlot);
    }

    Row getRowFor(DasRow dasRow) {
        for (Row row : this.canvas.getRows()) {
            if (row.controller.getDasRow() != dasRow) continue;
            return row;
        }
        throw new IllegalArgumentException("no dom row found for " + dasRow);
    }

    Column getColumnFor(Plot domPlot) {
        if (domPlot.getColumnId().equals(this.canvas.marginColumn.getId())) {
            return this.canvas.marginColumn;
        }
        for (Column column : this.canvas.getColumns()) {
            if (!column.getId().equals(domPlot.getColumnId())) continue;
            return column;
        }
        throw new IllegalArgumentException("no column found for " + domPlot);
    }

    private static void resetToFollow(List<Row> rows, String overlap, Row row) {
        String[] overlaps = overlap.split(" ");
        double min = 1.0;
        double max = 0.0;
        for (int i = 0; i < overlaps.length; ++i) {
            for (int j = 0; j < rows.size(); ++j) {
                if (!rows.get(j).getId().equals(overlaps[i])) continue;
                if (rows.get(j).getController().getDasRow().getMinimum() < min) {
                    min = rows.get(j).getController().getDasRow().getMinimum();
                }
                if (!(rows.get(j).getController().getDasRow().getMaximum() > max)) continue;
                max = rows.get(j).getController().getDasRow().getMaximum();
            }
        }
        row.getController().dasRow.setMinimum(min);
        row.getController().dasRow.setMaximum(max);
    }

    static void removeGapsAndOverlaps(Application dom, List<Row> rows, Row newRow) {
        int i;
        int[] weights = new int[rows.size()];
        int totalWeight = 0;
        String[] overlaps = new String[rows.size()];
        double[] mins = new double[rows.size()];
        double[] maxs = new double[rows.size()];
        int[] count = new int[rows.size()];
        for (i = 0; i < rows.size(); ++i) {
            try {
                double nmin = DasDevicePosition.parseFormatStr((String)rows.get(i).getTop())[0];
                double nmax = DasDevicePosition.parseFormatStr((String)rows.get(i).getBottom())[0];
                mins[i] = nmin;
                maxs[i] = nmax;
                weights[i] = (int)Math.round((nmax - nmin) * 1000.0);
            }
            catch (ParseException ex) {
                weights[i] = 200;
            }
            totalWeight += weights[i];
        }
        for (i = 0; i < rows.size(); ++i) {
            for (int j = 0; j < rows.size(); ++j) {
                if (i == j || rows.get(i) == newRow || rows.get(j) == newRow || !(maxs[i] > mins[j]) || !(mins[i] < maxs[j])) continue;
                int n = i;
                count[n] = count[n] + 1;
                overlaps[i] = overlaps[i] == null ? rows.get((int)j).id : overlaps[i] + " " + rows.get((int)j).id;
            }
        }
        for (i = 0; i < rows.size(); ++i) {
            if (count[i] <= 1) continue;
            totalWeight -= weights[i];
            weights[i] = 0;
        }
        for (i = 0; i < rows.size(); ++i) {
            weights[i] = 1000 * weights[i] / totalWeight;
        }
        totalWeight = 1000;
        int t = 0;
        for (int idx = 0; idx < weights.length; ++idx) {
            DasRow dasRow = rows.get((int)idx).controller.getDasRow();
            dasRow.setMinimum(1.0 * (double)t / (double)totalWeight);
            dasRow.setMaximum(1.0 * (double)(t + weights[idx]) / (double)totalWeight);
            t += weights[idx];
        }
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            if (count[i2] <= 1) continue;
            CanvasController.resetToFollow(rows, overlaps[i2], rows.get(i2));
        }
    }

    static void removeGapsAndOverlapsInColumns(List<Column> columns) {
        int i;
        int[] weights = new int[columns.size()];
        int totalWeight = 0;
        for (i = 0; i < columns.size(); ++i) {
            try {
                double nmin = DasDevicePosition.parseFormatStr((String)columns.get(i).getRight())[0];
                double nmax = DasDevicePosition.parseFormatStr((String)columns.get(i).getLeft())[0];
                weights[i] = (int)Math.round((nmax - nmin) * 1000.0);
            }
            catch (ParseException ex) {
                weights[i] = 200;
            }
            totalWeight += weights[i];
        }
        for (i = 0; i < columns.size(); ++i) {
            weights[i] = 1000 * weights[i] / totalWeight;
        }
        totalWeight = 1000;
        int t = 0;
        double emIn = columns.size() < 2 ? 0.0 : 2.0;
        for (int idx = 0; idx < weights.length; ++idx) {
            DasColumn dasColumn = columns.get((int)idx).controller.getDasColumn();
            dasColumn.setMinimum(1.0 * (double)t / (double)totalWeight);
            dasColumn.setMaximum(1.0 * (double)(t + weights[idx]) / (double)totalWeight);
            t += weights[idx];
            dasColumn.setEmMinimum(emIn);
            dasColumn.setEmMaximum(-emIn);
        }
    }

    void removeGaps() {
        CanvasController.removeGapsAndOverlaps(this.application, Arrays.asList(this.canvas.getRows()), null);
        this.repaintSoon();
    }

    void repaintSoon() {
        this.repaintSoonTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertGapFor(Row row, Row trow, Object position) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Insert Gap For");
        try {
            ArrayList<Row> rows = new ArrayList<Row>(Arrays.asList(this.canvas.getRows()));
            int ipos = 0;
            ipos = position == LayoutConstants.BELOW ? rows.indexOf(trow) + 1 : rows.indexOf(trow);
            rows.add(ipos, row);
            row.syncTo(trow, Arrays.asList("id"));
            List<Diff> d = DomUtil.getDiffs(row, trow, Arrays.asList("id"));
            if (d.size() > 0) {
                row.syncTo(trow, Arrays.asList("id"));
            }
            CanvasController.removeGapsAndOverlaps(this.application, rows, row);
        }
        finally {
            lock.unlock();
        }
        this.repaintSoon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertGapFor(Column column, Column tcolumn, Object position) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Insert Gap For");
        try {
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            int ipos = 0;
            ipos = position == LayoutConstants.BELOW ? columns.indexOf(tcolumn) + 1 : columns.indexOf(tcolumn);
            columns.add(ipos, column);
            column.syncTo(tcolumn, Arrays.asList("id"));
            List<Diff> d = DomUtil.getDiffs(column, tcolumn, Arrays.asList("id"));
            if (d.size() > 0) {
                column.syncTo(tcolumn, Arrays.asList("id"));
            }
            CanvasController.removeGapsAndOverlapsInColumns(columns);
        }
        finally {
            lock.unlock();
        }
        this.repaintSoon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row addInsertRow(Row trow, Object position) {
        Row row = new Row();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Insert Row");
        try {
            row.setParent(this.canvas.getMarginRow().getId());
            new RowController(row).createDasPeer(this.canvas, this.canvas.getMarginRow().getController().getDasRow());
            this.application.getController().assignId(row);
            if (trow != null) {
                this.insertGapFor(row, trow, position);
            }
            ArrayList<Row> rows = new ArrayList<Row>(Arrays.asList(this.canvas.getRows()));
            int ipos = rows.size();
            if (trow != null) {
                ipos = position == LayoutConstants.BELOW ? rows.indexOf(trow) + 1 : rows.indexOf(trow);
            }
            rows.add(ipos, row);
            this.canvas.setRows(rows.toArray(new Row[rows.size()]));
            this.application.getController().assignId(row);
        }
        finally {
            lock.unlock();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Column addInsertColumn(Column tcolumn, Object position) {
        Column column = new Column();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Insert Column");
        try {
            column.setParent(this.canvas.getMarginColumn().getId());
            new ColumnController(column).createDasPeer(this.canvas, this.canvas.getMarginColumn().getController().getDasColumn());
            if (tcolumn != null) {
                this.insertGapFor(column, tcolumn, position);
            }
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            int ipos = columns.size();
            if (tcolumn != null) {
                ipos = position == LayoutConstants.BELOW ? columns.indexOf(tcolumn) + 1 : columns.indexOf(tcolumn);
            }
            columns.add(ipos, column);
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
            this.application.getController().assignId(column);
        }
        finally {
            lock.unlock();
        }
        return column;
    }

    public List<Row> addRows(int count) {
        return this.addRows(count, LayoutConstants.BELOW);
    }

    public List<Row> addRows(int count, Object dir) {
        Row trow = this.application.getController().getPlot() != null ? this.getRowFor(this.application.getController().getPlot()) : this.canvas.getRows(this.canvas.getRows().length - 1);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < count; ++i) {
            Row newRow = this.addInsertRow(trow, dir);
            rows.add(newRow);
            trow = newRow;
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Column> addColumns(int count) {
        ArrayList<Column> result = new ArrayList<Column>();
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Columns");
        try {
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            for (int i = 0; i < count; ++i) {
                Column column = new Column();
                column.setParent(this.canvas.getMarginRow().getId());
                new ColumnController(column).createDasPeer(this.canvas, this.canvas.getMarginColumn().getController().getDasColumn());
                this.application.getController().assignId(column);
                result.add(column);
                int lpm = 1000 * i / count;
                int rpm = 1000 * (i + 1) / count;
                int lem = i * 50 / (count - 1);
                int rem = 50 * (count - 1 - i) / (count - 1);
                column.setLeft("" + (double)lpm / 10.0 + "%+" + (double)lem / 10.0 + "em");
                column.setRight("" + (double)rpm / 10.0 + "%-" + (double)rem / 10.0 + "em");
            }
            columns.addAll(result);
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public Column addColumn() {
        return this.addInsertColumn(null, null);
    }

    public Row addRow() {
        return this.addInsertRow(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRow(Row row) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Row");
        try {
            ArrayList<Row> rows = new ArrayList<Row>(Arrays.asList(this.canvas.getRows()));
            rows.remove(row);
            this.canvas.setRows(rows.toArray(new Row[rows.size()]));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteColumn(Column column) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Column");
        try {
            ArrayList<Column> columns = new ArrayList<Column>(Arrays.asList(this.canvas.getColumns()));
            columns.remove(column);
            this.canvas.setColumns(columns.toArray(new Column[columns.size()]));
        }
        finally {
            lock.unlock();
        }
    }

    protected void syncTo(Canvas canvas, List<String> exclude, Map<String, String> layoutIds) {
        List<Diff> diffs = canvas.diffs(this.canvas);
        for (Diff d : diffs) {
            if (exclude.contains(d.propertyName())) continue;
            try {
                if (d instanceof ArrayNodeDiff) {
                    ArrayNodeDiff and = (ArrayNodeDiff)d;
                }
                d.doDiff(this.canvas);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                d.doDiff(this.canvas);
            }
        }
        for (Row row : this.canvas.getRows()) {
            if (row.controller != null) continue;
            new RowController(row).createDasPeer(this.canvas, this.canvas.getMarginRow().getController().getDasRow());
        }
        for (DomNode domNode : this.canvas.getColumns()) {
            if (((Column)domNode).controller != null) continue;
            new ColumnController((Column)domNode).createDasPeer(this.canvas, this.canvas.getMarginColumn().getController().getDasColumn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indicateSelection(List<DomNode> selectedItems) {
        if (!this.dasCanvas.isShowing()) {
            return;
        }
        final ArrayList<Shape> sel = new ArrayList<Shape>();
        final ArrayList<Rectangle> clip = new ArrayList<Rectangle>();
        CanvasController canvasController = this;
        synchronized (canvasController) {
            if (this.currentSelectionItems != null) {
                return;
            }
            this.currentSelectionItems = selectedItems;
        }
        for (DomNode o : selectedItems) {
            if (o instanceof Plot) {
                DasPlot p = ((Plot)o).getController().getDasPlot();
                sel.add(SelectionUtil.getSelectionArea((DasCanvasComponent)p));
                clip.add(p.getBounds());
                continue;
            }
            if (!(o instanceof PlotElement)) continue;
            Renderer rend = ((PlotElement)o).getController().getRenderer();
            if (rend == null) {
                return;
            }
            DasPlot p = rend.getParent();
            if (p == null) {
                return;
            }
            Rectangle r = p.getBounds();
            sel.add(SelectionUtil.getSelectionArea((Renderer)rend));
            clip.add(r);
        }
        final Painter p = new Painter(){

            public void paint(Graphics2D g) {
                if (CanvasController.this.dasCanvas.lisPaintingForPrint()) {
                    System.err.println("not painting select");
                    return;
                }
                g.setColor(new Color(255, 255, 0, 100));
                Shape clip0 = g.getClip();
                for (int i = 0; i < sel.size(); ++i) {
                    Shape s = (Shape)sel.get(i);
                    Rectangle c = (Rectangle)clip.get(i);
                    if (s != null) {
                        g.clip(c);
                        g.fill(s);
                        g.setClip(clip0);
                        continue;
                    }
                    g.clip(c);
                    Stroke stroke0 = g.getStroke();
                    g.setStroke(new BasicStroke(10.0f));
                    g.draw(c);
                    g.setClip(clip0);
                    g.setStroke(stroke0);
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CanvasController.this.dasCanvas.addTopDecorator(p);
                Timer clearSelectionTimer = new Timer(300, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CanvasController.this.dasCanvas.removeTopDecorator(p);
                        CanvasController.this.currentSelectionItems = null;
                    }
                });
                clearSelectionTimer.setRepeats(false);
                clearSelectionTimer.restart();
            }
        });
    }

    ApplicationController getApplicationController() {
        return this.application.getController();
    }

    public String toString() {
        return "" + this.canvas + " controller";
    }
}

