/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.autoplot.util.TransparentLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangesSupport {
    Map<Object, Object> changesPending;
    Object parent;
    private static final Logger logger = TransparentLogger.getLogger("dom");
    public static final String PROP_PENDINGCHANGES = "pendingChanges";
    public static final String PROP_VALUEADJUSTING = "valueAdjusting";
    private String valueIsAdjusting = null;
    private DomLock mutatorLock = new DomLock();
    private PropertyChangeSupport propertyChangeSupport;

    ChangesSupport(PropertyChangeSupport pcs, Object parent) {
        this.parent = parent;
        this.changesPending = new HashMap<Object, Object>();
        if (pcs == null) {
            pcs = new PropertyChangeSupport(parent);
        }
        this.propertyChangeSupport = pcs;
    }

    synchronized List<Object> whoIsChanging(Object lockObject) {
        String msg = "whoIsChanging " + lockObject;
        logger.fine(msg);
        Object client = this.changesPending.get(lockObject);
        if (client == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(client);
    }

    synchronized void registerPendingChange(Object client, Object lockObject) {
        String msg = "registerPendingChange " + lockObject + " by " + client + "  in " + this.parent;
        logger.fine(msg);
        Object existingClient = this.changesPending.get(lockObject);
        if (existingClient != null) {
            if (existingClient != client) {
                throw new IllegalStateException("lock object in use: " + lockObject + ", by " + this.changesPending.get(lockObject));
            }
            return;
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.put(lockObject, client);
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGES, oldVal, this.isPendingChanges());
    }

    synchronized void performingChange(Object client, Object lockObject) {
        Object c = this.changesPending.get(lockObject);
        if (c == null || c != client) {
            this.registerPendingChange(client, lockObject);
        }
        logger.log(Level.FINE, "performingChange {0} by {1}  in {2}", new Object[]{lockObject, client, this.parent});
    }

    synchronized void changePerformed(Object client, Object lockObject) {
        logger.log(Level.FINE, "clearPendingChange {0} by {1}  in {2}", new Object[]{lockObject, client, this.parent});
        if (this.changesPending.get(lockObject) == null) {
            // empty if block
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.remove(lockObject);
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGES, oldVal, this.isPendingChanges());
    }

    public boolean isPendingChanges() {
        return this.changesPending.size() > 0;
    }

    public String isValueAdjusting() {
        return this.valueIsAdjusting;
    }

    protected synchronized DomLock mutatorLock() {
        return this.mutatorLock;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        return "changeSupport: " + this.changesPending;
    }

    public class DomLock
    extends ReentrantLock {
        public void lock(String description) {
            super.lock();
            if (ChangesSupport.this.valueIsAdjusting == null) {
                ChangesSupport.this.valueIsAdjusting = description;
                ChangesSupport.this.propertyChangeSupport.firePropertyChange(ChangesSupport.PROP_VALUEADJUSTING, null, description);
            }
        }

        public void lock() {
            this.lock("");
        }

        public void unlock() {
            super.unlock();
            if (!super.isLocked()) {
                String old = ChangesSupport.this.valueIsAdjusting;
                ChangesSupport.this.valueIsAdjusting = null;
                ChangesSupport.this.propertyChangeSupport.firePropertyChange(ChangesSupport.PROP_VALUEADJUSTING, old, ChangesSupport.this.valueIsAdjusting);
            }
        }
    }
}

