/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.DomNodeController;

public class ColumnController
extends DomNodeController {
    Column column;
    DasColumn dasColumn;
    Canvas canvas;

    ColumnController(Column column) {
        super(column);
        this.column = column;
        column.controller = this;
    }

    protected void createDasPeer(Canvas canvas, DasColumn parent) {
        DasCanvas c = canvas.controller.getDasCanvas();
        this.dasColumn = DasColumn.create((DasCanvas)c, (DasColumn)parent, (String)this.column.getLeft(), (String)this.column.getRight());
        final List<String> minList = Arrays.asList("minimum", "emMinimum", "ptMinimum");
        final List<String> maxList = Arrays.asList("maximum", "emMaximum", "ptMaximum");
        PropertyChangeListener list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (maxList.contains(evt.getPropertyName())) {
                    ColumnController.this.column.setRight(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)false));
                } else if (minList.contains(evt.getPropertyName())) {
                    ColumnController.this.column.setLeft(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)true));
                }
            }
        };
        this.dasColumn.addPropertyChangeListener(list);
        list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    double[] dd = DasDevicePosition.parseFormatStr((String)((String)evt.getNewValue()));
                    if (evt.getPropertyName().equals("left")) {
                        ColumnController.this.dasColumn.setMin(dd[0], dd[1], (int)dd[2]);
                    } else if (evt.getPropertyName().equals("right")) {
                        ColumnController.this.dasColumn.setMax(dd[0], dd[1], (int)dd[2]);
                    }
                }
                catch (ParseException ex) {
                    Logger.getLogger(ColumnController.class.getName()).log(Level.WARNING, "parse exception: {0}", ex);
                    ColumnController.this.column.setLeft(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)true));
                    ColumnController.this.column.setRight(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)false));
                }
            }
        };
        this.column.addPropertyChangeListener("left", list);
        this.column.addPropertyChangeListener("right", list);
        this.canvas = canvas;
    }

    public DasColumn getDasColumn() {
        return this.dasColumn;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

