/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.util.List;
import org.virbo.autoplot.dom.DataSourceController;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.PropertyChangeDiff;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFilter
extends DomNode {
    protected String uri = null;
    public static final String PROP_URI = "uri";
    public static final String PROP_VALID_RANGE = "validRange";
    private String validRange = "";
    public static final String PROP_FILL = "fill";
    private String fill = "";
    public static final String PROP_FILTERS = "filters";
    private String filters = "";
    DataSourceController controller;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        if (uri != null && !uri.equals("")) {
            URISplit split = URISplit.parse((String)uri);
            uri = URISplit.format((URISplit)split);
        }
        String oldUri = this.uri;
        this.uri = uri;
        this.propertyChangeSupport.firePropertyChange(PROP_URI, oldUri, uri);
    }

    public String getValidRange() {
        return this.validRange;
    }

    public void setValidRange(String validRange) {
        String oldVal = this.validRange;
        this.validRange = validRange;
        this.propertyChangeSupport.firePropertyChange(PROP_VALID_RANGE, oldVal, validRange);
    }

    public String getFill() {
        return this.fill;
    }

    public void setFill(String fill) {
        String oldFill = this.fill;
        this.fill = fill;
        this.propertyChangeSupport.firePropertyChange(PROP_FILL, oldFill, fill);
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        String old = this.filters;
        this.filters = filters;
        this.propertyChangeSupport.firePropertyChange(PROP_FILTERS, old, filters);
    }

    public DataSourceController getController() {
        return this.controller;
    }

    @Override
    public DomNode copy() {
        DataSourceFilter result = (DataSourceFilter)super.copy();
        result.controller = null;
        return result;
    }

    @Override
    public void syncTo(DomNode n) {
        super.syncTo(n);
        DataSourceFilter that = (DataSourceFilter)n;
        this.setFill(that.getFill());
        this.setValidRange(that.getValidRange());
        this.setUri(that.getUri());
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        DataSourceFilter that = (DataSourceFilter)n;
        this.setFill(that.getFill());
        this.setValidRange(that.getValidRange());
        if (!exclude.contains(PROP_URI)) {
            this.setUri(that.getUri());
        }
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        boolean b;
        DataSourceFilter that = (DataSourceFilter)node;
        List<Diff> result = super.diffs(node);
        boolean bl = that.uri == null ? this.uri == null : (b = that.uri.equals(this.uri));
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_URI, that.uri, this.uri));
        }
        if (!(b = that.validRange.equals(this.validRange))) {
            result.add(new PropertyChangeDiff(PROP_VALID_RANGE, that.validRange, this.validRange));
        }
        if (!(b = that.fill.equals(this.fill))) {
            result.add(new PropertyChangeDiff(PROP_FILL, that.fill, this.fill));
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.getUri() + ")";
    }
}

