/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.autoplot.dom.ChangesSupport;
import org.virbo.autoplot.dom.DebugPropertyChangeSupport;
import org.virbo.autoplot.dom.DomNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomNodeController {
    DomNode node;
    protected PropertyChangeSupport propertyChangeSupport = new DebugPropertyChangeSupport(this);
    protected ChangesSupport changesSupport = new ChangesSupport(this.propertyChangeSupport, this);

    public DomNodeController(DomNode node) {
        this.node = node;
    }

    protected static String insertString(String title, String label, String value) {
        String search = "%{" + label + "}";
        if (title.contains(search)) {
            title = title.replace(search, value);
        }
        if (title.contains(search = "$(" + label + ")")) {
            title = title.replace(search, value);
        }
        return title;
    }

    protected static boolean containsString(String ptitle, String label, String value) {
        String[] ss = null;
        String search = "%{" + label + "}";
        if (ptitle.contains(search)) {
            ss = ptitle.split("%\\{" + label + "\\}", -2);
        } else {
            search = "$(" + label + ")";
            if (ptitle.contains(search)) {
                ss = ptitle.split("\\$\\(" + label + "\\)", -2);
            }
        }
        return ss != null && value.startsWith(ss[0]) && value.endsWith(ss[1]);
    }

    public static DomNodeController getController(DomNode n) {
        try {
            Method m = n.getClass().getMethod("getController", new Class[0]);
            return (DomNodeController)m.invoke((Object)n, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DomNodeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(DomNodeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(DomNodeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private List<DomNodeController> getChildControllers() {
        ArrayList<DomNodeController> result = new ArrayList<DomNodeController>();
        List<DomNode> kids = this.node.childNodes();
        for (DomNode k : kids) {
            DomNodeController kc = DomNodeController.getController(k);
            if (kc == null) continue;
            result.add(kc);
        }
        return result;
    }

    public boolean isPendingChanges() {
        if (this.changesSupport.isPendingChanges()) {
            return true;
        }
        List<DomNodeController> kids = this.getChildControllers();
        for (DomNodeController k : kids) {
            if (!k.isPendingChanges()) continue;
            return true;
        }
        return false;
    }

    public void pendingChanges(Map<Object, Object> changes) {
        if (this.changesSupport.isPendingChanges()) {
            changes.putAll(this.changesSupport.changesPending);
        }
        List<DomNodeController> kids = this.getChildControllers();
        for (DomNodeController k : kids) {
            k.pendingChanges(changes);
        }
    }

    public boolean isValueAdjusting() {
        return this.changesSupport.isValueAdjusting() != null;
    }

    protected ChangesSupport.DomLock mutatorLock() {
        return this.changesSupport.mutatorLock();
    }

    public void registerPendingChange(Object client, Object lockObject) {
        this.changesSupport.registerPendingChange(client, lockObject);
    }

    public void performingChange(Object client, Object lockObject) {
        this.changesSupport.performingChange(client, lockObject);
    }

    public void changePerformed(Object client, Object lockObject) {
        this.changesSupport.changePerformed(client, lockObject);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }
}

