/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.BindingModel;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.Column;
import org.virbo.autoplot.dom.DataSourceFilter;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElement;
import org.virbo.autoplot.dom.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomOps {
    public static void swapPosition(Plot a, Plot b) {
        String trowid = a.getRowId();
        String tcolumnid = a.getColumnId();
        boolean txtv = a.getXaxis().isDrawTickLabels();
        boolean tytv = a.getYaxis().isDrawTickLabels();
        a.setRowId(b.getRowId());
        a.setColumnId(b.getColumnId());
        a.getXaxis().setDrawTickLabels(b.getXaxis().isDrawTickLabels());
        a.getYaxis().setDrawTickLabels(b.getYaxis().isDrawTickLabels());
        b.setRowId(trowid);
        b.setColumnId(tcolumnid);
        b.getXaxis().setDrawTickLabels(txtv);
        b.getYaxis().setDrawTickLabels(tytv);
    }

    public static Plot copyPlot(Plot srcPlot, boolean bindx, boolean bindy, Object direction) {
        Application application = srcPlot.getController().getApplication();
        ApplicationController ac = application.getController();
        Plot that = ac.addPlot(direction);
        that.getController().setAutoBinding(false);
        that.syncTo(srcPlot, Arrays.asList("id", "rowId", "columnId"));
        if (bindx) {
            BindingModel bb = ac.findBinding(application, "timeRange", srcPlot.getXaxis(), "range");
            if (bb == null) {
                ac.bind(srcPlot.getXaxis(), "range", that.getXaxis(), "range");
            } else {
                ac.bind(application, "timeRange", that.getXaxis(), "range");
            }
        }
        if (bindy) {
            ac.bind(srcPlot.getYaxis(), "range", that.getYaxis(), "range");
        }
        return that;
    }

    public static List<PlotElement> copyPlotElements(Plot srcPlot, Plot dstPlot) {
        DataSourceFilter dsf = null;
        ApplicationController ac = srcPlot.getController().getApplication().getController();
        List<PlotElement> srcElements = ac.getPlotElementsFor(srcPlot);
        ArrayList<PlotElement> newElements = new ArrayList<PlotElement>();
        for (PlotElement srcElement : srcElements) {
            PlotElement newp;
            if (!srcElement.getComponent().equals("")) {
                if (srcElement.getController().getParentPlotElement() != null) continue;
                newp = ac.copyPlotElement(srcElement, dstPlot, dsf);
                newElements.add(newp);
                continue;
            }
            newp = ac.copyPlotElement(srcElement, dstPlot, dsf);
            newElements.add(newp);
            List<PlotElement> srcKids = srcElement.controller.getChildPlotElements();
            ArrayList<PlotElement> newKids = new ArrayList<PlotElement>();
            DataSourceFilter dsf1 = ac.getDataSourceFilterFor(newp);
            for (PlotElement k : srcKids) {
                if (!srcElements.contains(k)) continue;
                PlotElement kidp = ac.copyPlotElement(k, dstPlot, dsf1);
                kidp.getController().setParentPlotElement(newp);
                newElements.add(kidp);
                newKids.add(kidp);
            }
        }
        return newElements;
    }

    public static Plot copyPlotAndPlotElements(Plot srcPlot, boolean copyPlotElements, boolean bindx, boolean bindy, Object direction) {
        Plot dstPlot = DomOps.copyPlot(srcPlot, bindx, bindy, direction);
        if (copyPlotElements) {
            DomOps.copyPlotElements(srcPlot, dstPlot);
        }
        return dstPlot;
    }

    public static Column getOrCreateSelectedColumn(Application dom, List<Plot> selectedPlots, boolean create) {
        ArrayList<String> n = new ArrayList<String>();
        for (Plot p : selectedPlots) {
            n.add(p.getColumnId());
        }
        if (n.size() == 1) {
            return (Column)DomUtil.getElementById(dom, (String)n.get(0));
        }
        if (create) {
            Canvas c = dom.getCanvases(0);
            Column col = c.getController().addColumn();
            col.setLeft("0%");
            col.setRight("100%");
            return col;
        }
        return null;
    }

    public static Row getOrCreateSelectedRow(Application dom, List<Plot> selectedPlots, boolean create) {
        ArrayList<String> n = new ArrayList<String>();
        for (Plot p : selectedPlots) {
            if (n.contains(p.getRowId())) continue;
            n.add(p.getRowId());
        }
        if (n.size() == 1) {
            return (Row)DomUtil.getElementById(dom, (String)n.get(0));
        }
        if (create) {
            Row r;
            Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)n.get(0));
            Row rmin = r;
            for (int i = 1; i < n.size(); ++i) {
                r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)n.get(i));
                if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                    rmax = r;
                }
                if (r.getController().getDasRow().getDMinimum() >= rmin.getController().getDasRow().getDMinimum()) continue;
                rmin = r;
            }
            Canvas c = dom.getCanvases(0);
            Row row = c.getController().addRow();
            row.setTop(rmin.getTop());
            row.setBottom(rmax.getBottom());
            return row;
        }
        return null;
    }

    public static Plot[] bottomAndTopMostPlot(Application dom, List<Plot> plots) {
        Row r;
        Plot pmax = plots.get(0);
        Plot pmin = plots.get(0);
        Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), pmax.getRowId());
        Row rmin = r;
        for (Plot p : plots) {
            r = (Row)DomUtil.getElementById(dom.getCanvases(0), p.getRowId());
            if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                rmax = r;
                pmax = p;
            }
            if (r.getController().getDasRow().getDMinimum() >= rmin.getController().getDasRow().getDMinimum()) continue;
            rmin = r;
            pmin = p;
        }
        return new Plot[]{pmax, pmin};
    }

    public static List<Plot> getPlotsFor(Application dom, Row row, boolean visible) {
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Plot p : dom.getPlots()) {
            if (!p.getRowId().equals(row.getId())) continue;
            if (visible) {
                if (!p.isVisible()) continue;
                result.add(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }
}

