/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Options;
import org.virbo.autoplot.util.TickleTimer;

public class OptionsPrefsController {
    Preferences prefs;
    Options options;
    TickleTimer flushTimer = new TickleTimer(100L, new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            try {
                OptionsPrefsController.this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace();
            }
        }
    });
    PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof String) {
                OptionsPrefsController.this.prefs.put(evt.getPropertyName(), (String)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Boolean) {
                OptionsPrefsController.this.prefs.putBoolean(evt.getPropertyName(), (Boolean)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Color) {
                OptionsPrefsController.this.prefs.put(evt.getPropertyName(), DomUtil.encodeColor((Color)evt.getNewValue()));
            } else {
                throw new RuntimeException("unsupported property type needs to be implemented: " + evt.getPropertyName() + "  " + evt.getNewValue().getClass());
            }
            OptionsPrefsController.this.flushTimer.tickle();
        }
    };

    public OptionsPrefsController(Options options) {
        this.prefs = Preferences.userNodeForPackage(options.getClass());
        this.options = options;
        options.addPropertyChangeListener(this.listener);
    }

    public void loadPreferencesWithEvents() {
        this.options.setAutolabelling(this.prefs.getBoolean("autolabelling", this.options.autolabelling));
        this.options.setAutolayout(this.prefs.getBoolean("autolayout", this.options.autolayout));
        this.options.setAutoranging(this.prefs.getBoolean("autoranging", this.options.autoranging));
        if (!this.options.autoranging) {
            System.err.println("Autorange default was false, enabling it now.");
            this.options.setAutoranging(true);
        }
        if (!this.options.autolayout) {
            System.err.println("Autolayout default was false, enabling it now.");
            this.options.setAutolayout(true);
        }
        if (!this.options.autolabelling) {
            System.err.println("Autolabelling default was false, enabling it now.");
            this.options.setAutolabelling(true);
        }
        this.options.setBackground(Color.decode(this.prefs.get("background", DomUtil.encodeColor(this.options.background))));
        this.options.setCanvasFont(this.prefs.get("canvasFont", this.options.canvasFont));
        this.options.setColor(Color.decode(this.prefs.get("color", DomUtil.encodeColor(this.options.color))));
        this.options.setDrawAntiAlias(this.prefs.getBoolean("drawAntiAlias", this.options.drawAntiAlias));
        this.options.setDrawGrid(this.prefs.getBoolean("drawGrid", this.options.drawGrid));
        this.options.setDrawMinorGrid(this.prefs.getBoolean("drawMinorGrid", this.options.drawMinorGrid));
        this.options.setFillColor(Color.decode(this.prefs.get("fillColor", DomUtil.encodeColor(this.options.fillColor))));
        this.options.setForeground(Color.decode(this.prefs.get("foreground", DomUtil.encodeColor(this.options.foreground))));
        this.options.setLogConsoleVisible(this.prefs.getBoolean("logConsoleVisible", this.options.logConsoleVisible));
        this.options.setOverRendering(this.prefs.getBoolean("overRendering", this.options.overRendering));
        this.options.setScriptVisible(this.prefs.getBoolean("scriptVisible", this.options.scriptVisible));
        this.options.setDataVisible(this.prefs.getBoolean("dataVisible", this.options.dataVisible));
        this.options.setLayoutVisible(this.prefs.getBoolean("layoutVisible", this.options.layoutVisible));
        this.options.setServerEnabled(this.prefs.getBoolean("serverEnabled", this.options.serverEnabled));
        this.options.setSpecialEffects(this.prefs.getBoolean("specialEffects", this.options.specialEffects));
        this.options.setTextAntiAlias(this.prefs.getBoolean("textAntiAlias", this.options.textAntiAlias));
        this.options.setDayOfYear(this.prefs.getBoolean("dayOfYear", this.options.dayOfYear));
        this.options.setNearestNeighbor(this.prefs.getBoolean("nearestNeighbor", this.options.nearestNeighbor));
    }

    public void loadPreferences() {
        this.options.autolabelling = this.prefs.getBoolean("autolabelling", this.options.autolabelling);
        this.options.autolayout = this.prefs.getBoolean("autolayout", this.options.autolayout);
        this.options.autoranging = this.prefs.getBoolean("autoranging", this.options.autoranging);
        if (!this.options.autoranging) {
            System.err.println("Autorange default was false, enabling it now.");
            this.options.autoranging = true;
        }
        if (!this.options.autolayout) {
            System.err.println("Autolayout default was false, enabling it now.");
            this.options.autolayout = true;
        }
        if (!this.options.autolabelling) {
            System.err.println("Autolabelling default was false, enabling it now.");
            this.options.autolabelling = true;
        }
        this.options.background = Color.decode(this.prefs.get("background", DomUtil.encodeColor(this.options.background)));
        this.options.canvasFont = this.prefs.get("canvasFont", this.options.canvasFont);
        this.options.color = Color.decode(this.prefs.get("color", DomUtil.encodeColor(this.options.color)));
        this.options.drawAntiAlias = this.prefs.getBoolean("drawAntiAlias", this.options.drawAntiAlias);
        this.options.drawGrid = this.prefs.getBoolean("drawGrid", this.options.drawGrid);
        this.options.drawMinorGrid = this.prefs.getBoolean("drawMinorGrid", this.options.drawMinorGrid);
        this.options.fillColor = Color.decode(this.prefs.get("fillColor", DomUtil.encodeColor(this.options.fillColor)));
        this.options.foreground = Color.decode(this.prefs.get("foreground", DomUtil.encodeColor(this.options.foreground)));
        this.options.logConsoleVisible = this.prefs.getBoolean("logConsoleVisible", this.options.logConsoleVisible);
        this.options.overRendering = this.prefs.getBoolean("overRendering", this.options.overRendering);
        this.options.scriptVisible = this.prefs.getBoolean("scriptVisible", this.options.scriptVisible);
        this.options.dataVisible = this.prefs.getBoolean("dataVisible", this.options.dataVisible);
        this.options.layoutVisible = this.prefs.getBoolean("layoutVisible", this.options.layoutVisible);
        this.options.serverEnabled = this.prefs.getBoolean("serverEnabled", this.options.serverEnabled);
        this.options.specialEffects = this.prefs.getBoolean("specialEffects", this.options.specialEffects);
        this.options.textAntiAlias = this.prefs.getBoolean("textAntiAlias", this.options.textAntiAlias);
        this.options.dayOfYear = this.prefs.getBoolean("dayOfYear", this.options.dayOfYear);
        this.options.nearestNeighbor = this.prefs.getBoolean("nearestNeighbor", this.options.nearestNeighbor);
    }
}

