/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.util.ArrayList;
import java.util.List;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElementController;
import org.virbo.autoplot.dom.PlotElementStyle;
import org.virbo.autoplot.dom.PropertyChangeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotElement
extends DomNode {
    protected String dataSourceFilterId;
    public static final String PROP_DATASOURCEFILTERID = "dataSourceFilterId";
    protected PlotElementStyle style = new PlotElementStyle();
    public static final String PROP_STYLE = "style";
    protected Plot plotDefaults = new Plot();
    public static final String PROP_PLOT_DEFAULTS = "plotDefaults";
    protected RenderType renderType = RenderType.series;
    public static final String PROP_RENDERTYPE = "renderType";
    protected String plotId = null;
    public static final String PROP_PLOTID = "plotId";
    protected String parent = "";
    public static final String PROP_PARENT = "parent";
    protected String component = "";
    public static final String PROP_COMPONENT = "component";
    protected String legendLabel = "";
    public static final String PROP_LEGENDLABEL = "legendLabel";
    protected boolean displayLegend = false;
    public static final String PROP_DISPLAYLEGEND = "displayLegend";
    public static final String PROP_AUTOLABEL = "autoLabel";
    protected boolean autoLabel = false;
    public static final String PROP_AUTORENDERTYPE = "autoRenderType";
    protected boolean autoRenderType = false;
    protected boolean autoComponent = false;
    public static final String PROP_AUTOCOMPONENT = "autoComponent";
    protected boolean active = true;
    public static final String PROP_ACTIVE = "active";
    PlotElementController controller;

    public String getDataSourceFilterId() {
        return this.dataSourceFilterId;
    }

    public void setDataSourceFilterId(String dataSourceFilterId) {
        String oldDataSourceFilterId = this.dataSourceFilterId;
        this.dataSourceFilterId = dataSourceFilterId;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASOURCEFILTERID, oldDataSourceFilterId, dataSourceFilterId);
    }

    public PlotElementStyle getStyle() {
        return this.style;
    }

    public void setStyle(PlotElementStyle style) {
        PlotElementStyle oldStyle = this.style;
        this.style = style;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLE, oldStyle, style);
    }

    public Plot getPlotDefaults() {
        return this.plotDefaults;
    }

    public void setPlotDefaults(Plot plot) {
        Plot oldPlot = this.plotDefaults;
        this.plotDefaults = plot;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT_DEFAULTS, oldPlot, plot);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        RenderType oldRenderType = this.renderType;
        this.renderType = renderType;
        this.propertyChangeSupport.firePropertyChange(PROP_RENDERTYPE, (Object)oldRenderType, (Object)renderType);
        this.setAutoRenderType(false);
    }

    public void setRenderTypeAutomatically(RenderType renderType) {
        RenderType oldRenderType = this.renderType;
        this.renderType = renderType;
        this.propertyChangeSupport.firePropertyChange(PROP_RENDERTYPE, (Object)oldRenderType, (Object)renderType);
        this.setAutoRenderType(true);
    }

    public String getPlotId() {
        return this.plotId;
    }

    public void setPlotId(String plotId) {
        String oldPlotId = this.plotId;
        this.plotId = plotId;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTID, oldPlotId, plotId);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        String old = this.parent;
        this.parent = parent;
        this.propertyChangeSupport.firePropertyChange(PROP_PARENT, old, parent);
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        String oldComponent = this.component;
        this.component = component;
        this.propertyChangeSupport.firePropertyChange(PROP_COMPONENT, oldComponent, component);
        this.setAutoComponent(false);
    }

    public void setComponentAutomatically(String component) {
        String oldComponent = this.component;
        this.component = component;
        this.propertyChangeSupport.firePropertyChange(PROP_COMPONENT, oldComponent, component);
        this.setAutoComponent(true);
    }

    public String getLegendLabel() {
        return this.legendLabel;
    }

    public void setLegendLabel(String legendLabel) {
        String oldLegendLabel = this.legendLabel;
        this.legendLabel = legendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_LEGENDLABEL, oldLegendLabel, legendLabel);
        this.setAutoLabel(false);
    }

    public void setLegendLabelAutomatically(String legendLabel) {
        String oldLegendLabel = this.legendLabel;
        this.legendLabel = legendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_LEGENDLABEL, oldLegendLabel, legendLabel);
        this.setAutoLabel(true);
    }

    public boolean isDisplayLegend() {
        return this.displayLegend;
    }

    public void setDisplayLegend(boolean displayLegend) {
        boolean oldDisplayLegend = this.displayLegend;
        this.displayLegend = displayLegend;
        this.propertyChangeSupport.firePropertyChange(PROP_DISPLAYLEGEND, oldDisplayLegend, displayLegend);
    }

    public boolean isAutoLabel() {
        return this.autoLabel;
    }

    public void setAutoLabel(boolean autolabel) {
        boolean oldAutolabel = this.autoLabel;
        this.autoLabel = autolabel;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOLABEL, oldAutolabel, autolabel);
    }

    public boolean isAutoRenderType() {
        return this.autoRenderType;
    }

    public void setAutoRenderType(boolean autoRenderType) {
        boolean oldAutoRenderType = this.autoRenderType;
        this.autoRenderType = autoRenderType;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTORENDERTYPE, oldAutoRenderType, autoRenderType);
    }

    public boolean isAutoComponent() {
        return this.autoComponent;
    }

    public void setAutoComponent(boolean autoComponent) {
        boolean oldAutoComponent = this.autoComponent;
        this.autoComponent = autoComponent;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOCOMPONENT, oldAutoComponent, autoComponent);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldActive = this.active;
        this.active = active;
        this.propertyChangeSupport.firePropertyChange(PROP_ACTIVE, oldActive, active);
    }

    public PlotElementController getController() {
        return this.controller;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public DomNode copy() {
        PlotElement result = (PlotElement)super.copy();
        result.controller = null;
        result.style = (PlotElementStyle)this.style.copy();
        result.plotDefaults = (Plot)this.plotDefaults.copy();
        return result;
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        List<Diff> result = super.diffs(node);
        PlotElement that = (PlotElement)node;
        if (!that.plotId.equals(this.plotId)) {
            result.add(new PropertyChangeDiff(PROP_PLOTID, that.plotId, this.plotId));
        }
        if (!that.legendLabel.equals(this.legendLabel)) {
            result.add(new PropertyChangeDiff(PROP_LEGENDLABEL, that.legendLabel, this.legendLabel));
        }
        if (that.autoLabel != this.autoLabel) {
            result.add(new PropertyChangeDiff(PROP_AUTOLABEL, that.autoLabel, this.autoLabel));
        }
        if (that.autoRenderType != this.autoRenderType) {
            result.add(new PropertyChangeDiff(PROP_AUTORENDERTYPE, that.autoLabel, this.autoLabel));
        }
        if (that.autoComponent != this.autoComponent) {
            result.add(new PropertyChangeDiff(PROP_AUTOCOMPONENT, that.autoComponent, this.autoComponent));
        }
        if (!that.displayLegend == this.displayLegend) {
            result.add(new PropertyChangeDiff(PROP_DISPLAYLEGEND, that.displayLegend, this.displayLegend));
        }
        if (!that.active == this.active) {
            result.add(new PropertyChangeDiff(PROP_ACTIVE, that.active, this.active));
        }
        if (!that.renderType.equals((Object)this.renderType)) {
            result.add(new PropertyChangeDiff(PROP_RENDERTYPE, (Object)that.renderType, (Object)this.renderType));
        }
        if (!that.dataSourceFilterId.equals(this.dataSourceFilterId)) {
            result.add(new PropertyChangeDiff(PROP_DATASOURCEFILTERID, that.dataSourceFilterId, this.dataSourceFilterId));
        }
        if (!that.component.equals(this.component)) {
            result.add(new PropertyChangeDiff(PROP_COMPONENT, that.component, this.component));
        }
        result.addAll(DomUtil.childDiffs(PROP_STYLE, this.getStyle().diffs(that.getStyle())));
        result.addAll(DomUtil.childDiffs(PROP_PLOT_DEFAULTS, this.getPlotDefaults().diffs(that.getPlotDefaults())));
        return result;
    }

    @Override
    public void syncTo(DomNode n) {
        super.syncTo(n);
        this.syncTo(n, new ArrayList<String>());
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        PlotElement that = (PlotElement)n;
        if (!exclude.contains(PROP_PLOTID)) {
            this.setPlotId(that.getPlotId());
        }
        if (!exclude.contains(PROP_DATASOURCEFILTERID)) {
            this.setDataSourceFilterId(that.getDataSourceFilterId());
        }
        if (!exclude.contains(PROP_PARENT)) {
            this.setParent(that.getParent());
        }
        if (!exclude.contains(PROP_LEGENDLABEL)) {
            this.setLegendLabel(that.getLegendLabel());
        }
        if (!exclude.contains(PROP_DISPLAYLEGEND)) {
            this.setDisplayLegend(that.isDisplayLegend());
        }
        if (!exclude.contains(PROP_ACTIVE)) {
            this.setActive(that.isActive());
        }
        if (!exclude.contains(PROP_RENDERTYPE)) {
            this.setRenderType(that.getRenderType());
        }
        if (!exclude.contains(PROP_AUTOLABEL)) {
            this.setAutoLabel(that.isAutoLabel());
        }
        if (!exclude.contains(PROP_AUTORENDERTYPE)) {
            this.setAutoRenderType(that.isAutoRenderType());
        }
        if (!exclude.contains(PROP_STYLE)) {
            this.style.syncTo(that.style, exclude);
        }
        if (!exclude.contains(PROP_PLOT_DEFAULTS)) {
            this.plotDefaults.syncTo(that.plotDefaults, exclude);
        }
        if (!exclude.contains(PROP_COMPONENT)) {
            this.setComponent(that.getComponent());
        }
        if (!exclude.contains(PROP_AUTOCOMPONENT)) {
            this.setAutoComponent(that.isAutoComponent());
        }
    }

    @Override
    public String toString() {
        StringBuilder parenthetical = new StringBuilder(this.getLegendLabel() == null ? "" : this.getLegendLabel());
        if (!this.active) {
            parenthetical.append(parenthetical.length() == 0 ? "inactive" : ", inactive");
        }
        String l = parenthetical.length() == 0 ? "" : " (" + parenthetical.toString() + ")";
        return super.toString() + l;
    }
}

