/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.dom;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;

public class PropertyChangeDiff
implements Diff {
    String propertyName;
    Object oldVal;
    Object newVal;

    PropertyChangeDiff(String propertyName, Object oldVal, Object newVal) {
        this.propertyName = propertyName;
        this.oldVal = oldVal;
        this.newVal = newVal;
    }

    private static void doSet(DomNode node, String propertyName, Object oldVal1, Object newVal) {
        try {
            Object oldVal = DomUtil.getPropertyValue(node, propertyName);
            if (oldVal == oldVal1 || !oldVal.equals(oldVal1)) {
                // empty if block
            }
            DomUtil.setPropertyValue(node, propertyName, newVal);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PropertyChangeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(PropertyChangeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(PropertyChangeDiff.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doDiff(DomNode node) {
        PropertyChangeDiff.doSet(node, this.propertyName, this.oldVal, this.newVal);
    }

    public void undoDiff(DomNode node) {
        PropertyChangeDiff.doSet(node, this.propertyName, this.newVal, this.oldVal);
    }

    public String propertyName() {
        return this.propertyName;
    }

    public String toString() {
        String s = this.propertyName + " " + this.oldVal + " to " + this.newVal;
        if (s.length() > 30) {
            s = this.newVal instanceof Boolean ? this.propertyName + "=" + this.newVal : this.propertyName;
        }
        return s;
    }

    public String getLabel() {
        return this.toString();
    }

    public String getDescription() {
        return this.propertyName + " " + this.oldVal + " --> " + this.newVal;
    }
}

