/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.scriptconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.system.RequestProcessor;
import org.jdesktop.layout.GroupLayout;
import org.python.core.PyException;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.virbo.autoplot.GuiSupport;
import org.virbo.autoplot.JythonUtil;
import org.virbo.autoplot.scriptconsole.CommandLineTextPane;
import org.virbo.autoplot.scriptconsole.LogConsoleSettingsDialog;
import org.virbo.autoplot.scriptconsole.LogConsoleUtil;
import org.virbo.autoplot.scriptconsole.LoggingOutputStream;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConsole
extends JPanel {
    public static final int RECORD_SIZE_LIMIT = 1000;
    List<LogRecord> records = new LinkedList<LogRecord>();
    int eventThreadId = -1;
    int level = Level.INFO.intValue();
    boolean showLoggerId = false;
    boolean showTimeStamps = false;
    boolean showLevel = false;
    LogConsoleSettingsDialog settingsDialog = null;
    NumberFormat nf = new DecimalFormat("00.000");
    private Timer timer2;
    PrintStream oldStdOut;
    PrintStream oldStdErr;
    PythonInterpreter interp = null;
    protected String searchText = "";
    public static final String PROP_SEARCHTEXT = "searchText";
    protected Map<String, Object> scriptContext = null;
    public static final String PROP_SCRIPTCONTEXT = "scriptContext";
    private static boolean alreadyLoggingStdout = false;
    private JPanel actionsPanel;
    private JButton clearButton;
    private CommandLineTextPane commandLineTextPane1;
    private JButton copyButton;
    private JButton jButton1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextPane logTextArea;
    private JButton saveButton;

    public LogConsole() {
        this.initComponents();
        this.commandLineTextPane1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final String s = LogConsole.this.commandLineTextPane1.getText();
                RequestProcessor.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        try {
                            System.out.println("AP> " + s);
                            LogConsole.this.maybeInitializeInterpreter();
                            try {
                                PyObject po = LogConsole.this.interp.eval(s);
                                if (!(po instanceof PyNone)) {
                                    LogConsole.this.interp.exec("print repr(" + s + ")");
                                }
                            }
                            catch (PyException ex) {
                                LogConsole.this.interp.exec(s);
                            }
                            LogConsole.this.commandLineTextPane1.setText("");
                        }
                        catch (IOException ex) {
                            Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                            LogConsole.this.commandLineTextPane1.setText("");
                        }
                        catch (PyException ex) {
                            System.err.println(ex.toString());
                            LogConsole.this.commandLineTextPane1.setText("");
                        }
                    }
                });
            }
        });
        this.commandLineTextPane1.putClientProperty("JYTHON_INTERPRETER_PROVIDER", new JythonInterpreterProvider(){

            public PythonInterpreter createInterpreter() throws IOException {
                LogConsole.this.maybeInitializeInterpreter();
                return LogConsole.this.interp;
            }
        });
        this.timer2 = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogConsole.this.update();
            }
        });
        this.timer2.setRepeats(false);
        final JTextPane ftxt = this.logTextArea;
        this.logTextArea.getActionMap().put("biggerFont", new AbstractAction("Text Size Bigger"){

            public void actionPerformed(ActionEvent e) {
                Font f = ftxt.getFont();
                float size = f.getSize2D();
                float step = size < 14.0f ? 1.0f : 2.0f;
                ftxt.setFont(f.deriveFont(Math.min(40.0f, size + step)));
            }
        });
        this.logTextArea.getActionMap().put("smallerFont", new AbstractAction("Text Size Smaller"){

            public void actionPerformed(ActionEvent e) {
                Font f = ftxt.getFont();
                float size = f.getSize2D();
                float step = size < 14.0f ? 1.0f : 2.0f;
                ftxt.setFont(f.deriveFont(Math.max(4.0f, size - step)));
            }
        });
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.logTextArea.getInputMap().put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "biggerFont");
        this.logTextArea.getInputMap().put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "smallerFont");
    }

    private void maybeInitializeInterpreter() throws IOException {
        if (this.interp == null) {
            String s = this.commandLineTextPane1.getText();
            int ipos = this.commandLineTextPane1.getCaretPosition();
            this.commandLineTextPane1.setText("initializing interpretter...");
            this.interp = JythonUtil.createInterpreter(true, false);
            if (this.scriptContext != null) {
                for (Map.Entry<String, Object> e : this.scriptContext.entrySet()) {
                    this.interp.set(e.getKey(), e.getValue());
                }
            }
            this.commandLineTextPane1.setText(s);
            this.commandLineTextPane1.setCaretPosition(ipos);
        }
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        String oldSearchText = this.searchText;
        this.searchText = searchText;
        this.update();
        this.firePropertyChange(PROP_SEARCHTEXT, oldSearchText, searchText);
    }

    public synchronized void setShowLoggerId(boolean selected) {
        this.showLoggerId = selected;
    }

    public synchronized void setShowTimeStamps(boolean selected) {
        this.showTimeStamps = selected;
    }

    public synchronized void setShowLevel(boolean selected) {
        this.showLevel = selected;
    }

    public synchronized void setLevel(int level) {
        this.level = level;
    }

    public Map<String, Object> getScriptContext() {
        return this.scriptContext;
    }

    public void setScriptContext(Map<String, Object> scriptContext) {
        Map<String, Object> oldScriptContext = this.scriptContext;
        this.scriptContext = scriptContext;
        this.firePropertyChange(PROP_SCRIPTCONTEXT, oldScriptContext, scriptContext);
    }

    private synchronized LogConsoleSettingsDialog getSettingsDialog() {
        if (this.settingsDialog == null) {
            this.settingsDialog = new LogConsoleSettingsDialog(GuiSupport.getFrameForComponent(this), false, this);
        }
        return this.settingsDialog;
    }

    public Handler getHandler() {
        Handler h = new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void publish(LogRecord rec) {
                LogConsole logConsole = LogConsole.this;
                synchronized (logConsole) {
                    LogConsole.this.records.add(rec);
                    LogConsole.this.timer2.restart();
                    if (LogConsole.this.eventThreadId == -1 && EventQueue.isDispatchThread()) {
                        LogConsole.this.eventThreadId = rec.getThreadID();
                    }
                }
                if (rec.getLevel().intValue() >= Level.WARNING.intValue() && LogConsole.this.oldStdErr != null) {
                    String msg = rec.getMessage();
                    Object[] parms = rec.getParameters();
                    String recMsg = parms == null || parms.length == 0 ? msg : MessageFormat.format(msg, parms);
                    LogConsole.this.oldStdErr.println(recMsg);
                }
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        };
        h.setLevel(Level.ALL);
        return h;
    }

    public synchronized void logConsoleMessages() {
        if (alreadyLoggingStdout) {
            System.err.println("already logging stdout and stderr");
            return;
        }
        alreadyLoggingStdout = true;
        Logger logger = Logger.getLogger("console.stdout");
        LoggingOutputStream los = new LoggingOutputStream(logger, Level.INFO);
        this.oldStdOut = System.out;
        System.setOut(new PrintStream(los, true));
        logger = Logger.getLogger("console.stderr");
        los = new LoggingOutputStream(logger, Level.WARNING);
        this.oldStdErr = System.err;
        System.setErr(new PrintStream(los, true));
    }

    public synchronized void undoLogConsoleMessages() {
        System.setOut(this.oldStdOut);
        System.setErr(this.oldStdErr);
    }

    public void turnOffConsoleHandlers() {
        System.err.println("turning off default log, look for messages in console tab.");
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            h.setLevel(Level.OFF);
        }
    }

    public synchronized void update() {
        try {
            int n = this.records.size();
            long t = n == 0 ? 0L : this.records.get(n - 1).getMillis();
            boolean timeStamps = this.showTimeStamps;
            boolean logLevels = this.showLevel;
            String st = this.searchText;
            if (st != null && st.length() == 0) {
                st = null;
            }
            Pattern p = null;
            if (st != null) {
                p = Pattern.compile(st);
            }
            StyledDocument doc = this.logTextArea.getStyledDocument();
            doc.remove(0, doc.getLength());
            long lastT = 0L;
            SimpleAttributeSet highlistAttr = new SimpleAttributeSet();
            StyleConstants.setBackground(highlistAttr, Color.ORANGE);
            for (LogRecord rec : this.records) {
                if (rec.getLevel().intValue() < this.level) continue;
                if (lastT != 0L && rec.getMillis() - lastT > 5000L) {
                    doc.insertString(doc.getLength(), "\n", null);
                }
                lastT = rec.getMillis();
                String msg = rec.getMessage();
                Object[] parms = rec.getParameters();
                String recMsg = parms == null || parms.length == 0 ? msg : MessageFormat.format(msg, parms);
                String prefix = "";
                if (this.showLoggerId) {
                    prefix = prefix + rec.getLoggerName() + " ";
                }
                if (timeStamps) {
                    prefix = prefix + this.nf.format((double)(rec.getMillis() - t) / 1000.0) + " ";
                }
                if (logLevels) {
                    prefix = prefix + rec.getLevel() + " ";
                }
                if (rec.getThreadID() == this.eventThreadId) {
                    prefix = prefix + "(GUI) ";
                }
                if (!prefix.equals("")) {
                    recMsg = prefix.trim() + ": " + recMsg;
                }
                SimpleAttributeSet attr = null;
                if (st != null && p.matcher(recMsg).find()) {
                    attr = highlistAttr;
                }
                try {
                    recMsg = recMsg + "\n";
                    doc.insertString(doc.getLength(), recMsg, attr);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            while (this.records.size() > 1000) {
                this.records.remove(0);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.clearButton = new JButton();
        this.saveButton = new JButton();
        this.copyButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.commandLineTextPane1 = new CommandLineTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.logTextArea = new JTextPane();
        this.jButton1 = new JButton();
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("clear all messages.  ");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.clearButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save As...");
        this.saveButton.setToolTipText("saves the records to file for use by software support team.");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.saveButtonActionPerformed(evt);
            }
        });
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("copy xml of log records into system clipboard, for pasting into email.\n");
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.copyButtonActionPerformed(evt);
            }
        });
        GroupLayout actionsPanelLayout = new GroupLayout((Container)this.actionsPanel);
        this.actionsPanel.setLayout((LayoutManager)actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup((GroupLayout.Group)actionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionsPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.clearButton).addPreferredGap(0).add((Component)this.saveButton).addPreferredGap(0).add((Component)this.copyButton).addContainerGap(18, Short.MAX_VALUE)));
        actionsPanelLayout.setVerticalGroup((GroupLayout.Group)actionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionsPanelLayout.createParallelGroup(3).add((Component)this.clearButton).add((Component)this.saveButton).add((Component)this.copyButton)));
        this.jLabel2.setText("AP>");
        this.commandLineTextPane1.setToolTipText("enter jython commands here to control the application, for example \"plot([1,2,3])\"");
        this.commandLineTextPane1.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LogConsole.this.commandLineTextPane1FocusGained(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.commandLineTextPane1);
        this.logTextArea.setEditable(false);
        this.jScrollPane1.setViewportView(this.logTextArea);
        this.jButton1.setText("Console Settings...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogConsole.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.actionsPanel, -2, -1, -2).addPreferredGap(0, 319, Short.MAX_VALUE).add((Component)this.jButton1).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 590, Short.MAX_VALUE).addContainerGap()).add((Component)this.jScrollPane1, -1, 654, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 320, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jScrollPane2, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.actionsPanel, -2, -1, -2).add((Component)this.jButton1))));
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.records.clear();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent evt) {
        if ((evt.getModifiers() & 2) == 2) {
            JFileChooser chooser = new JFileChooser();
            if (0 == chooser.showOpenDialog(this)) {
                FileInputStream fo = null;
                try {
                    fo = new FileInputStream(chooser.getSelectedFile());
                    this.records = LogConsoleUtil.deserializeLogRecords(fo);
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SAXException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        fo.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        } else {
            JFileChooser chooser = new JFileChooser();
            if (0 == chooser.showSaveDialog(this)) {
                FileOutputStream fo = null;
                try {
                    fo = new FileOutputStream(chooser.getSelectedFile());
                    LogConsoleUtil.serializeLogRecords(this.records, fo);
                    fo.close();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        fo.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(LogConsole.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            LogConsoleUtil.serializeLogRecords(this.records, out);
            out.close();
            StringSelection stringSelection = new StringSelection(out.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void commandLineTextPane1FocusGained(FocusEvent evt) {
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.commandLineTextPane1);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.getSettingsDialog().setVisible(true);
    }
}

