/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.state;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.PlotSymbol;
import org.virbo.autoplot.dom.Plot;
import org.virbo.autoplot.dom.PlotElementStyle;
import org.virbo.autoplot.state.StatePersistence;

public class PersistenceTests {
    protected DasColorBar.Type enumm = DasColorBar.Type.GRAYSCALE;
    public static final String PROP_ENUM = "enum";
    protected Plot plot = new Plot();
    public static final String PROP_PLOT = "plot";
    protected PlotElementStyle style = new PlotElementStyle();
    public static final String PROP_STYLE = "style";
    protected Datum datum = null;
    public static final String PROP_DATUM = "datum";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static void main(String[] args) throws IOException {
        PersistenceTests my = new PersistenceTests();
        my.getStyle().setReference(Units.hertz.createDatum(60));
        my.getStyle().setPlotSymbol((PlotSymbol)DefaultPlotSymbol.STAR);
        my.setDatum(EnumerationUnits.create((Object)"animals").createDatum((Object)"squirrel"));
        File f = new File("enum.xml");
        StatePersistence.saveState(f, (Object)my, "");
    }

    public DasColorBar.Type getEnum() {
        return this.enumm;
    }

    public void setEnum(DasColorBar.Type enumm) {
        DasColorBar.Type oldEnum = this.enumm;
        this.enumm = enumm;
        this.propertyChangeSupport.firePropertyChange(PROP_ENUM, oldEnum, enumm);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        Plot oldPlot = this.plot;
        this.plot = plot;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT, oldPlot, plot);
    }

    public PlotElementStyle getStyle() {
        return this.style;
    }

    public void setStyle(PlotElementStyle style) {
        PlotElementStyle oldStyle = this.style;
        this.style = style;
        this.propertyChangeSupport.firePropertyChange(PROP_STYLE, oldStyle, style);
    }

    public Datum getDatum() {
        return this.datum;
    }

    public void setDatum(Datum datum) {
        Datum oldDatum = this.datum;
        this.datum = datum;
        this.propertyChangeSupport.firePropertyChange(PROP_DATUM, oldDatum, datum);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

