/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot.util;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;

public class DateTimeDatumFormatter
extends DatumFormatter {
    boolean dayOfYear = false;
    public static final int OPT_DOY = 1;

    public boolean isDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(boolean dayOfYear) {
        this.dayOfYear = dayOfYear;
    }

    public DateTimeDatumFormatter(int opts) {
        this.setDayOfYear((opts & 1) == 1);
    }

    public DateTimeDatumFormatter() {
        this(0);
    }

    public String format(Datum datum) {
        if (!datum.getUnits().isConvertableTo((Units)Units.us2000)) {
            return "!Ktime!C!kexpected";
        }
        double ssm = TimeUtil.getSecondsSinceMidnight((Datum)datum);
        String date = null;
        String time = TimeDatumFormatter.MINUTES.format(datum);
        if (ssm == 0.0) {
            date = this.dayOfYear ? TimeDatumFormatter.DAY_OF_YEAR.format(datum) : TimeDatumFormatter.DAYS.format(datum);
        }
        return date == null ? time : date + " " + time;
    }

    public String grannyFormat(Datum datum) {
        double ssm = TimeUtil.getSecondsSinceMidnight((Datum)datum);
        String date = null;
        String time = TimeDatumFormatter.MINUTES.format(datum);
        if (ssm == 0.0) {
            date = this.dayOfYear ? TimeDatumFormatter.DAY_OF_YEAR.format(datum) : TimeDatumFormatter.DAYS.format(datum);
        }
        return date == null ? time : time + "!c" + date;
    }

    public String[] axisFormat(DatumVector datums, DatumRange context) {
        String date;
        Datum datum;
        int i;
        double width;
        boolean haveMidnight = false;
        boolean haveNonMidnight = false;
        int firstIndex = -1;
        String[] result = new String[datums.getLength()];
        if (!datums.getUnits().isConvertableTo((Units)Units.us2000) || !context.getUnits().isConvertableTo((Units)Units.us2000)) {
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = "!Ktime!C!kexpected";
            }
            return result;
        }
        int scale = datums.getLength() < 2 ? 8 : ((width = datums.get(1).subtract(datums.get(0)).doubleValue(Units.microseconds)) >= 6.0E7 ? 5 : (width >= 1000000.0 ? 6 : (width >= 1000.0 ? 7 : 8)));
        TimeDatumFormatter delegate = TimeDatumFormatter.formatterForScale((int)scale, (DatumRange)context);
        for (i = 0; i < datums.getLength(); ++i) {
            double ssm;
            String time;
            datum = datums.get(i);
            date = null;
            result[i] = time = delegate.format(datum);
            if (!DatumRangeUtil.sloppyContains((DatumRange)context, (Datum)datum)) continue;
            if (firstIndex == -1) {
                firstIndex = i;
            }
            if ((ssm = TimeUtil.getSecondsSinceMidnight((Datum)datum)) == 0.0) {
                date = this.dayOfYear ? TimeDatumFormatter.DAY_OF_YEAR.format(datum) : TimeDatumFormatter.DAYS.format(datum);
                haveMidnight = true;
                result[i] = result[i] + "!c" + date;
                continue;
            }
            haveNonMidnight = true;
        }
        if (haveNonMidnight) {
            if (!haveMidnight && firstIndex > -1) {
                Datum datum2 = datums.get(firstIndex);
                String date2 = this.dayOfYear ? TimeDatumFormatter.DAY_OF_YEAR.format(datum2) : TimeDatumFormatter.DAYS.format(datum2);
                result[firstIndex] = result[firstIndex] + "!c" + date2;
            }
        } else {
            for (i = 0; i < datums.getLength(); ++i) {
                datum = datums.get(i);
                date = this.dayOfYear ? TimeDatumFormatter.DAY_OF_YEAR.format(datum) : TimeDatumFormatter.DAYS.format(datum);
                result[i] = date;
            }
        }
        return result;
    }
}

