/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.util.List;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;

public class TestURLSplit {
    public static void main(String[] args) throws Exception {
        TestURLSplit.testContext();
        TestURLSplit.test(10, "http://goes.ngdc.noaa.gov/data/avg/2004/A1050412.TXT?skip=23&timeFormat=%y%m%d %H%M&column=E1&time=YYMMDD", 76);
        TestURLSplit.test(899, "vap:file:///c:/Documents+and+Settings/jbf/Desktop/Product+Summary.xls?sheet=nist+lo&firstRow=&column=B", 93);
        TestURLSplit.test(2, "vap:/home/jbf/mydata.qds", 3);
        TestURLSplit.test(89, "vap:file:///c:/Documents+and+Settings/jbf/Desktop/Product+Summary.xls?sheet=nist+lo&firstRow=56&column=B", 90);
        TestURLSplit.testComplete(89, "vap:file:///c:/Documents+and+Settings/jbf/Desktop/Product+Summary.xls?sheet=nist+lo&firstRow=56&column=B", 90);
        TestURLSplit.testComplete(8, "c:/Documents and Settings/jbf/Desktop/Product Summary.xls?sheet=nist lo&firstRow=56&column=B", 13);
        TestURLSplit.test(8, "c:/Documents and Settings/jbf/Desktop/Product Summary.xls?sheet=nist lo&firstRow=56&column=B", 5);
        TestURLSplit.test(1, "dat.file:/home/jbf/project/galileo/src/pws$y$j_ext.data?column=field5&timeFormat=$Y+$j+$H+$M+$S&time=field0&timerange=2000-may+to+2000-sep", 0);
        TestURLSplit.test(3, "vap+tsds:http://timeseries.org/get.cgi?StartDate=19630101&EndDate=20090103&ppd=-1&ext=tsml&out=bin&param1=OMNI_OMNI2-33-v0", 0);
        TestURLSplit.test(4, "vap:/home/jbf/mydata.qds", 14);
        TestURLSplit.test(5, "/home/jbf/mydata.qds", 10);
        TestURLSplit.test(6, "vap+qds:file:///home/jbf/mydata.qds", 25);
        TestURLSplit.test(7, "vap+jdbc:jbdc:mysql://192.168.0.203:3306/temperaturedb?table=temperaturetable&depend0=time&temperature", 0);
        TestURLSplit.test(9, "tsds.http://timeseries.org/get.cgi?StartDate=20030101&EndDate=20080902&ppd=1&ext=bin&out=tsml&param1=OMNI_OMNIHR-26-v0", 12);
    }

    private static void test(int id, String string, int carotpos) throws Exception {
        System.out.println("\n");
        System.out.println(string);
        char c = string.length() > carotpos ? string.charAt(carotpos) : (char)'\u0000';
        URISplit split = URISplit.parse((String)string, (int)carotpos, (boolean)true);
        System.out.println(split);
        if (split.resourceUriCarotPos >= 0) {
            char c1 = split.surl.length() > split.resourceUriCarotPos ? split.surl.charAt(split.resourceUriCarotPos) : (char)'\u0000';
            System.out.println("" + c + "(@" + carotpos + ") == " + c1 + "(@" + split.resourceUriCarotPos + "):  " + (c == c1));
        }
        System.out.println("carotPosAssert=" + (split.formatCarotPos - split.resourceUriCarotPos == (split.vapScheme == null ? 0 : split.vapScheme.length() + 1)));
    }

    private static void testComplete(int id, String string, int carotpos) throws Exception {
        System.err.println("testComplete!!!!");
        System.err.println(string.substring(0, carotpos));
        List result = DataSetURI.getCompletions((String)string, (int)carotpos, (ProgressMonitor)new NullProgressMonitor());
        for (DataSetURI.CompletionResult cr : result) {
            System.err.print("  " + cr.label);
        }
        for (int i = 0; i < string.length(); ++i) {
            result = DataSetURI.getCompletions((String)string, (int)i, (ProgressMonitor)new NullProgressMonitor());
            System.err.println("" + id + "@" + i + ":  " + result.size() + "   " + string.substring(0, i));
        }
    }

    private static void testContext1(String t, String scontext, String expect) throws Exception {
        if (scontext.equals("")) {
            System.err.println(URISplit.format((URISplit)URISplit.parse((String)t)));
        }
    }

    private static void testContext() throws Exception {
        String pwd = new File("").toURI().toURL().toString();
        TestURLSplit.testContext1("/file.dat", "", "file:///file.dat");
        TestURLSplit.testContext1("file.dat", "", pwd + "file.dat");
        TestURLSplit.testContext1("file.dat", "http://www.myweb.org/path", "http://www.myweb.org/path/file.dat");
        TestURLSplit.testContext1("/file.dat", "http://www.myweb.org/path", "http://www.myweb.org/file.dat");
    }
}

