/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.Util;

public class Test017 {
    static long t0 = System.currentTimeMillis();
    static String[] uris = new String[]{"033 http://cdaweb.gsfc.nasa.gov/istp_public/data/omni/hro_5min/%Y/omni_hro_5min_%Y%m%d_v...cdf?HR[::100]&timerange=1995+to+2000", "001 vap+tsds:http://timeseries.org/get.cgi?StartDate=19890101&EndDate=19890101&ext=bin&out=tsml&ppd=1440&param1=SourceAcronym_Subset3-1-v0", "002 vap+tsds:http://timeseries.org/get.cgi?StartDate=19950101&EndDate=19950104&ext=bin&out=tsml&ppd=1440&param1=OMNI_OMNIHR-22-v0", "003 vap+tsds:http://timeseries.org/get.cgi?StartDate=19950101&EndDate=19950109&ppd=144&out=tsml&param1=OMNI_OMNIHR-22-v0", "004 vap+tsds:http://timeseries.org/get.cgi?StartDate=19950101&EndDate=19950104&ext=bin&out=tsml&ppd=144&param1=OMNI_OMNIHR-22-v0", "005 vap+tsds:http://timeseries.org/OMNI_OMNIHR-22-v0-to_19950101-tf_19950104-ppd_144-filter_0-ext_bin.bin", "006 vap+das2server:http://www-wbd.physics.uiowa.edu/das/das2Server?dataset=das2_1/cluster/wbd/r_wbd&start_time=2007-04-17T08:40Z&end_time=2007-04-17T08:50Z&spacecraft=c1&mode=DSN&antenna=Any&frequencyOffset=Any&fftSize=1024", "007 vap+das2server:http://www-wbd.physics.uiowa.edu/das/das2Server?dataset=das2_1/cluster/wbd/r_wbd&start_time=2007-04-17T08:40Z&end_time=2007-04-17T08:50Z&spacecraft=c1&mode=DSN&antenna=Ey&frequencyOffset=Any&fftSize=1024", "008 http://cdaweb.gsfc.nasa.gov/istp_public/data/canopus/mari_mag/1994/cn_k0_mari_19940122_v01.cdf?Epoch", "009 http://cdaweb.gsfc.nasa.gov/istp_public/data/canopus/bars/%Y/cn_k0_bars_%Y%m%d_v...cdf?E_vel&timerange=1993-01-02+through+1993-01-14", "010 CC ftp://cdaweb.gsfc.nasa.gov/pub/istp/imp8/mag_15sec/1973/i8_15sec_mag_19731030_v02.cdf", "011 vap:ftp://cdaweb.gsfc.nasa.gov/pub/istp/themis/tha/l2/fgm/2007/tha_l2_fgm_20070224_v01.cdf?tha_fgh_gse", "012 http://cdaweb.gsfc.nasa.gov/istp_public/data/cluster/c2/pp/cis/2003/c2_pp_cis_20030104_v02.cdf?N_p__C2_PP_CIS", "013 http://cdaweb.gsfc.nasa.gov/istp_public/data/cluster/c2/pp/fgm/2003/c2_pp_fgm_20030114_v01.cdf?Epoch__C2_PP_FGM", "014 ftp://cdaweb.gsfc.nasa.gov/pub/istp/imp8/mag_15sec/2000/i8_15sec_mag_20000101_v02.cdf?F1_Average_B_15s", "015 ftp://cdaweb.gsfc.nasa.gov/pub/istp/lanl/97_spa/2005/l7_k0_spa_20050405_v01.cdf?spa_p_dens", "016 vap:ftp://cdaweb.gsfc.nasa.gov/pub/istp/themis/tha/l2/fgm/2007/tha_l2_fgm_20070224_v01.cdf?tha_fgh_gse", "017 ftp://cdaweb.gsfc.nasa.gov/pub/istp/geotail/def_or/1995/ge_or_def_19950101_v02.cdf?GSE_POS", "018 ftp://cdaweb.gsfc.nasa.gov/pub/istp/geotail/mgf/1998/ge_k0_mgf_19980102_v01.cdf?IB", "019 http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/polar/hyd_h0/2002/po_h0_hyd_20020110_v01.cdf.html?ELECTRON_DIFFERENTIAL_ENERGY_FLUX", "020 vap:http://www.astro.princeton.edu/~frei/Gcat_htm/Catalog/Fits/n4013_lR.fits", "021 vap+bin:ftp://ftp.nmh.ac.uk/wdc/obsdata/hourval/single_year/1909/clh1909.wdc", "022 vap+dat:http://www.igpp.ucla.edu/cache2/GOMA_3001/DATA/SUMMARY/E1_SUMM_GSE_GSM.TAB?timeFormat=ISO8601&column=field1", "023 vap+dat:http://wind.nasa.gov/swe_apbimax/wi_swe_fc_apbimax.1995005.txt?comment=;&column=21&timeFormat=$Y+$j&time=field0", "024 vap+dat:http://goes.ngdc.noaa.gov/data/avg/$Y/A105$y$m.TXT?skip=23&timeFormat=$y$m$d+$H$M&column=E1&time=YYMMDD&fill=32700&timerange=Dec+2004", "027 http://vho.nasa.gov/mission/soho/celias_pm_30sec/2003.txt", "028 vap+dat:ftp://nssdcftp.gsfc.nasa.gov/spacecraft_data/omni/high_res_omni/monthly_1min/omni_min200101.asc?time=field0&column=field14&timeFormat=$Y+$j+$H+$M&validMax=9999", "029 http://wind.nasa.gov/swe_apbimax/wi_swe_fc_apbimax.2001017.txt?column=field2&comment=;&time=field0&timeFormat=$Y+$j", "030 vap:http://vho.nasa.gov/mission/soho/celias_pm_30sec/1998.txt?time=YY&column=GSE_X&timeFormat=$y+$b+$d+$(ignore):$H:$M:$S", "031 ftp://nis-ftp.lanl.gov/pub/projects/genesis/3dmom/gim-3dl2-2002-01_v02.txt?skip=68&time=field0&timeFormat=$Y+$j+$H+$M+$S&column=field8&fill=-9999.0", "033 http://cdaweb.gsfc.nasa.gov/istp_public/data/omni/hro_5min/%Y/omni_hro_5min_%Y%m%d_v...cdf?HR[::100]&timerange=1995+to+2000", "034 http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/polar/vis/%Y/po_k0_vis_%Y%m%d_v...cdf.html?Epoch&timerange=2001", "035 vap+txt:file:///opt/project/galileo/data/lrsudr/g7/eden/pws$y$j.data?timeRange=1997-049", "036 vap+dat:http://goes.ngdc.noaa.gov/data/avg/$Y/A105$y$m.TXT?skip=23&timeFormat=$y$m$d+$H$M&column=E1&time=YYMMDD&fill=32700&timerange=Dec+2004", "037 CC ftp://ftp.nmh.ac.uk/wdc/obsdata/hourval/single_year/", "038 http://www-pw.physics.uiowa.edu/helios/data1/data/average/a7510-12.zip/av751229.dat?depend0=field0&rank2=1:", "040 http://www-pw.physics.uiowa.edu/helios/data1/data/average/a$y$m-...zip/av$y$m$d.dat?rank2=1:&time=field0&timerange=1975-oct", "041 vap:file:///media/mini/data.backup/examples/xls/2008-lion%20and%20tiger%20summary.xls?sheet=Samantha+tiger+lp+lofreq&column=Elastic_Modulus&firstRow=53&depend0=Time", "042 file:///Documents%20and%20Settings/sklemuk/Desktop/UCSF%20Voice%20Conference%202008/Product%20Summary.xls?sheet=nist%20lo&column=H", "043 file:///c:/Documents+and+Settings/jbf/Desktop/Product+Summary.xls?sheet=nist+lo&column=H", "044 file:///Documents%20and%20Settings/sklemuk/Desktop/UCSF%20Voice%20Conference%202008/Product%20Summary.xls?sheet=nist%20lo&column=H", "045 http://goes.ngdc.noaa.gov/data/avg/2004/A1050402.TXT", "050 vap:file:/home/jbf/ct/autoplot/vap/cdaweb_ace.vap?timerange=2010-10-20+12:00+to+18:00", "051 vap:file:/home/jbf/ct/autoplot/vap/cdaweb_ace.vap?timerange=2010-10-20T12:00/2010-10-20T18:00", "052 vap:file:/home/jbf/ct/autoplot/vap/cdaweb_ace.vap?timerange=2010-10-20T12:00/PT6H"};

    public static void xxx(String id) {
        System.err.println("-- timer -- " + id + " --: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test017.xxx("start");
            ThreadPoolExecutor exec = new ThreadPoolExecutor(12, 12, 3600L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            for (String s : uris) {
                int count = Integer.parseInt(s.substring(0, 4).trim());
                s = s.substring(4);
                String label = String.format("test017_%03d", count);
                try {
                    if (s.startsWith("CC ")) {
                        String[] list = Util.listDirectory((String)s.substring(3));
                        PrintWriter out = new PrintWriter(label + ".txt");
                        for (String l : list) {
                            out.println(l);
                        }
                        out.close();
                    } else if (s.contains("file:///") && !s.contains("file:///home/jbf/ct/hudson")) {
                        System.err.println("skipping local " + s);
                    } else {
                        Test017.doTest(s, label, exec);
                    }
                }
                catch (Exception ex) {
                    PrintWriter pw = new PrintWriter(label + ".error");
                    pw.println(s);
                    pw.println("");
                    ex.printStackTrace(pw);
                    pw.close();
                    ex.printStackTrace();
                }
                Test017.xxx(label + ": " + s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void doTest(final String s, final String label, ThreadPoolExecutor exec) throws IOException, InterruptedException, Exception {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    QDataSet ds = Util.getDataSet((String)s);
                    MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
                    hist.putProperty("TITLE", (Object)s);
                    hist.putProperty("LABEL", (Object)label);
                    ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
                    QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                    if (dep0 != null) {
                        MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
                        ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
                    } else {
                        PrintWriter pw = new PrintWriter(label + ".dep0.qds");
                        pw.println("no dep0");
                        pw.close();
                    }
                    ScriptContext.plot(ds);
                    ScriptContext.setCanvasSize(750, 300);
                    int i = s.lastIndexOf("/");
                    ScriptContext.setTitle(s.substring(i + 1));
                    ScriptContext.writeToPng(label + ".png");
                }
                catch (Exception ex) {
                    Logger.getLogger(Test017.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        int timeoutSeconds = 30;
        Future<String> f = null;
        while (true) {
            try {
                f = exec.submit(run, "Success!");
            }
            catch (RejectedExecutionException ex) {
                if (exec.isShutdown()) break;
                System.err.println("Thread pool is full. Retrying...");
                Thread.sleep(100L);
                continue;
            }
            break;
        }
        if (f != null && "Success!".equals(f.get(timeoutSeconds, TimeUnit.SECONDS))) {
            System.err.println("okay!");
        } else {
            PrintWriter pw = new PrintWriter(label + ".error");
            pw.println(s);
            pw.println("\ntimeout in " + timeoutSeconds + " seconds.");
            pw.close();
        }
    }
}

