/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.DataSetUtil;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.idlsupport.APDataSet;

public class Test024 {
    public static void example1() throws Exception {
        APDataSet apds = new APDataSet();
        apds.setDataSetURI("http://www.autoplot.org/data/swe-np.xls?column=data&depend0=dep0");
        apds.doGetDataSet();
        System.err.println(apds.toString());
        apds.setPreferredUnits("hours since 2007-01-17T00:00");
        ScriptContext.plot(DataSetUtil.asDataSet((Object)apds.values(apds.depend(0))), DataSetUtil.asDataSet((Object)apds.values()));
        ScriptContext.writeToPng("test024_001");
    }

    public static void example2() throws Exception {
        APDataSet apds = new APDataSet();
        apds.setDataSetURI("vap+inline:ripples(20)");
        apds.doGetDataSet();
        System.err.println(apds.toString());
        apds.setFillValue(-999.0);
        ScriptContext.plot(DataSetUtil.asDataSet((Object)apds.values()));
        double[] vv = (double[])apds.values();
        for (int i = 0; i < vv.length; ++i) {
            System.err.printf("%9.3f ", vv[i]);
        }
        System.err.println();
        ScriptContext.writeToPng("test024_002");
    }

    public static void example3() throws Exception {
        int[] lens;
        APDataSet apds = new APDataSet();
        apds.setDataSetURI("vap:file:///home/jbf/ct/hudson/data.backup/xls/hourlyForecast.xls?column=Temperature_F&depend0=Rel_Humidity_");
        apds.doGetDataSet();
        System.err.println(apds.toString());
        apds = new APDataSet();
        apds.setDataSetURI("vap+das2server:http://www-pw.physics.uiowa.edu/das/das2Server?dataset=das2_1/cassini/cassiniLrfc&key=33696757&start_time=2010-01-11T11:15:00.000Z&end_time=2010-01-11T21:45:00.000Z&-lfdr+ExEw+-mfdr+ExEw+-mfr+13ExEw+-hfr+ABC12EuEvEx+-n+hfr_snd+-n+lp_rswp+-n+bad_data+-n+dpf_zero+-n+mfdr_mfr2+-n+mfr3_hfra+-n+hf1_hfrc+-a+-b+30+-bgday=");
        apds.doGetDataSet();
        System.err.println(apds.toString());
        Object o = apds.slice("ds_1", 0);
        double[] d = (double[])o;
        System.err.println(String.format("apds.slice(%s,0)=double[%d]", "ds_1", d.length));
        o = apds.slice("ds_2", 0);
        d = (double[])o;
        System.err.println(String.format("apds.slice(%s,0)=double[%d]", "ds_2", d.length));
        System.err.println(String.format("apds.rank()=%d", apds.rank()));
        System.err.println(String.format("apds.length()=%d", apds.length()));
        System.err.print("apds.lengths(0)=");
        for (int i : lens = apds.lengths(0)) {
            System.err.print(i + ",");
        }
        System.err.println("");
    }

    public static void example4() throws Exception {
        APDataSet apds = new APDataSet();
        apds.setDataSetURI("vap+inline:ripplesx(20)");
        apds.doGetDataSet();
        if (apds.getStatus() != 0) {
            System.err.println(apds.getStatusMessage());
            return;
        }
        System.err.println(apds.toString());
        apds.setFillValue(-999.0);
        ScriptContext.plot(DataSetUtil.asDataSet((Object)apds.values()));
        double[] vv = (double[])apds.values();
        for (int i = 0; i < vv.length; ++i) {
            System.err.printf("%9.3f ", vv[i]);
        }
        System.err.println();
        ScriptContext.writeToPng("test024_004");
    }

    public static void example5() throws InterruptedException, IOException {
        APDataSet apds = new APDataSet();
        apds.setDataSetURI("http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/genesis/3dl2_gim/2003/genesis_3dl2_gim_20030501_v01.cdf.dds?Proton_Density");
        apds.doGetDataSet();
        if (apds.getStatus() != 0) {
            System.err.println(apds.getStatusMessage());
            return;
        }
        System.err.println(apds.toString());
        apds.setFillValue(-999.0);
        ScriptContext.plot(DataSetUtil.asDataSet((Object)apds.values()));
        double[] vv = (double[])apds.values();
        for (int i = 0; i < vv.length; ++i) {
            System.err.printf("%9.3f ", vv[i]);
        }
        System.err.println();
        ScriptContext.writeToPng("test024_005");
    }

    public static void test6() throws Exception {
        DataSource dss = DataSetURI.getDataSource((String)"http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/genesis/3dl2_gim/2003/genesis_3dl2_gim_20030501_v01.cdf.dds?Proton_Density");
        TimeSeriesBrowse tsb = DataSourceUtil.getTimeSeriesBrowse((DataSource)dss);
        System.err.println(tsb);
        dss = DataSetURI.getDataSource((String)"http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hyd_h0/$Y/po_h0_hyd_$Y$m$d_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX&timerange=20000109");
        tsb = DataSourceUtil.getTimeSeriesBrowse((DataSource)dss);
        System.err.println(tsb);
    }

    private static String checkAPDS(String uri, String tr) throws Exception {
        if (tr != null) {
            DataSource dss = DataSetURI.getDataSource((String)uri);
            TimeSeriesBrowse tsb = DataSourceUtil.getTimeSeriesBrowse((DataSource)dss);
            DatumRange dr = DatumRangeUtil.parseTimeRange((String)tr);
            tsb.setTimeRange(dr);
            uri = tsb.getURI();
        }
        APDataSet apds = new APDataSet();
        apds.setDataSetURI(uri);
        apds.doGetDataSet();
        if (apds.getStatus() != 0) {
            return apds.getStatusMessage();
        }
        return apds.toString();
    }

    public static void test7() throws Exception {
        String uri = "vap+das2server:http://www-pw.physics.uiowa.edu/das/das2Server?dataset=cassini/mag/mag_vectorQ&start_time=2010-01-01T00:00:00.000Z&end_time=2010-01-02T00:00:00.000Z";
        System.err.println(Test024.checkAPDS(uri, null));
    }

    public static void main(String[] args) {
        try {
            Test024.example1();
            Test024.example2();
            Test024.example3();
            Test024.example4();
            Test024.example5();
            Test024.test6();
            Test024.test7();
            Test024.checkAPDS("vap+cdaweb:ds=PO_K0_MFE&id=MBTIGRF&filter=polar&timerange=2003-05-01", "2003-05-02");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

