/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.virbo.autoplot.ScriptContext;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.jythonsupport.Util;

public class Test025 {
    public static void doTest(int id, String uri) throws Exception {
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet((String)uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
        hist.putProperty("TITLE", (Object)uri);
        String label = String.format("test025_%03d", id);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
            ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1));
        ScriptContext.writeToPng(String.format("test025_%03d.png", id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test025.doTest(0, "file:///home/jbf/ct/hudson/jyds/test025_000.jyds?ds1");
            Test025.doTest(1, "file:///home/jbf/ct/hudson/jyds/test025_000.jyds?ds2");
            ScriptContext.setCanvasSize(500, 500);
            Test025.doTest(2, "file:///home/jbf/ct/hudson/jyds/lambda.jyds?yy");
            Test025.doTest(3, "file:///home/jbf/ct/hudson/jyds/lambda.jyds?zz");
            Test025.doTest(4, "file:///home/jbf/ct/hudson/jyds/lambda.jyds?zz2");
            Test025.doTest(5, "http://autoplot.org/data/imageDiff.jyds");
            Test025.doTest(6, "file:///home/jbf/ct/hudson/jyds/test025_001.jyds?ds2");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

