/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.util.Base64;
import org.virbo.dataset.DataSetUtil;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;
import org.virbo.qstream.Util;
import org.virbo.qstream.XMLSerializeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapSerializeDelegate
implements SerializeDelegate,
XMLSerializeDelegate {
    public String format(Object o) {
        return this.format2(o);
    }

    public Element xmlFormat(Document doc, Object o) {
        Map m = (Map)o;
        Element result = doc.createElement(this.typeId(o.getClass()));
        for (Map.Entry o2 : m.entrySet()) {
            Map.Entry e = o2;
            Object oval = e.getValue();
            SerializeDelegate sd = SerializeRegistry.getDelegate(oval.getClass());
            if (sd == null) {
                System.err.println("sorry, can't serialize " + e);
                continue;
            }
            Element child = doc.createElement("entry");
            child.setAttribute("key", String.valueOf(e.getKey()));
            if (sd instanceof XMLSerializeDelegate) {
                child.appendChild(((XMLSerializeDelegate)((Object)sd)).xmlFormat(doc, oval));
            } else {
                String sval = sd.format(oval);
                child.setAttribute("type", sd.typeId(oval.getClass()));
                child.setAttribute("value", sval);
            }
            result.appendChild(child);
        }
        return result;
    }

    public Object xmlParse(Element e) throws ParseException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String stype;
            if (nl.item(i).getNodeType() != 1) continue;
            Element child = (Element)nl.item(i);
            String key = child.getAttribute("key");
            Element eval = null;
            if (child.hasAttribute("type")) {
                stype = child.getAttribute("type");
            } else {
                eval = Util.singletonChildElement(child);
                stype = eval.getTagName();
            }
            SerializeDelegate sd = SerializeRegistry.getByName(stype);
            if (sd instanceof XMLSerializeDelegate) {
                Object oval = ((XMLSerializeDelegate)((Object)sd)).xmlParse(eval);
                result.put(key, oval);
                continue;
            }
            String sval = child.getAttribute("value");
            Object oval = sd.parse(stype, sval);
            result.put(key, oval);
        }
        return result;
    }

    private String format2(Object o) {
        Map m = (Map)o;
        StringBuffer buf = new StringBuffer();
        buf.append("map[");
        for (Map.Entry o2 : m.entrySet()) {
            Map.Entry e = o2;
            Object oval = e.getValue();
            SerializeDelegate sd = SerializeRegistry.getDelegate(oval.getClass());
            if (sd == null) {
                System.err.println("sorry, can't serialize " + e);
                continue;
            }
            buf.append((String)e.getKey());
            buf.append("=");
            String sval = sd.format(oval);
            buf.append(sd.typeId(oval.getClass()) + ":" + URLEncoder.encode(sval));
            buf.append(" ");
        }
        buf.append("]");
        return buf.toString();
    }

    public Object parse(String typeId, String s) throws ParseException {
        if (s.equals("")) {
            return Collections.EMPTY_MAP;
        }
        if (s.startsWith("map[")) {
            String[] ss = s.substring(4, s.length() - 1).split(" ");
            if (ss.length == 1 && ss[0].equals("")) {
                return Collections.EMPTY_MAP;
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (String s1 : ss) {
                String[] nv = s1.split("=");
                int i = nv[1].indexOf(":");
                String stype = nv[1].substring(0, i);
                SerializeDelegate sd = SerializeRegistry.getByName(stype);
                String sval = URLDecoder.decode(nv[1].substring(i + 1));
                Object oval = sd.parse(stype, sval);
                result.put(nv[0], oval);
            }
            return result;
        }
        byte[] buff = Base64.decode((String)s);
        XMLDecoder dec = new XMLDecoder(new ByteArrayInputStream(buff));
        Object result = dec.readObject();
        return result;
    }

    public String typeId(Class clas) {
        return "map";
    }

    public static void main(String[] args) throws ParseException {
        HashMap<String, Object> m1 = new HashMap<String, Object>();
        HashMap<String, Object> m2 = new HashMap<String, Object>();
        m2.put("dog", 56);
        m2.put("cat", "tiger summary");
        m2.put("ds", DataSetUtil.asDataSet((double)23.0, (Units)Units.us2000));
        m1.put("units", Units.centigrade);
        m1.put("user_properties", m2);
        m1.put("cat", "tiger summary");
        MapSerializeDelegate sd = new MapSerializeDelegate();
        String sval = sd.format(m1);
        System.err.println(sval);
        Map m3 = (Map)sd.parse("map", sval);
        sval = "map[total=Long:8928 invalidCount=Long:0 outliers=map:map%5B%5D outlierCount=Integer:0 binWidth=Double:500.0 binStart=Double:0.0 ]";
        Map m4 = (Map)sd.parse("map", sval);
        System.err.println(m3);
    }
}

