/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.virbo.qstream.Descriptor;
import org.virbo.qstream.PlaneDescriptor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketDescriptor
implements Descriptor {
    List<PlaneDescriptor> planes = new ArrayList<PlaneDescriptor>();
    boolean stream;
    int streamRank;
    private Element domElement;
    boolean valuesInDescriptor = false;

    PacketDescriptor() {
    }

    PacketDescriptor(Element element) {
        this();
        this.domElement = element;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public int streamRank() {
        return this.streamRank;
    }

    public void setStreamRank(int streamRank) {
        this.streamRank = streamRank;
    }

    void addPlane(PlaneDescriptor planeDescriptor) {
        this.planes.add(planeDescriptor);
    }

    public List<PlaneDescriptor> getPlanes() {
        return Collections.unmodifiableList(this.planes);
    }

    void setValuesInDescriptor(boolean b) {
        this.valuesInDescriptor = b;
    }

    boolean isValuesInDescriptor() {
        return this.valuesInDescriptor;
    }

    void setDomElement(Element packetElement) {
        this.domElement = packetElement;
    }

    @Override
    public Element getDomElement() {
        return this.domElement;
    }

    int sizeBytes() {
        int sizeBytes = 0;
        for (int iplane = 0; iplane < this.planes.size(); ++iplane) {
            PlaneDescriptor pd = this.planes.get(iplane);
            sizeBytes += pd.sizeBytes();
        }
        return sizeBytes;
    }

    public String toString() {
        return this.planes.toString();
    }
}

