/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.stream.StreamHandler;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.qstream.QDataSetStreamHandler;
import org.virbo.qstream.StreamException;
import org.virbo.qstream.StreamTool;

public class ParseBenchmarks {
    public static void main(String[] args) throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        ParseBenchmarks.readAsciiQds();
        ParseBenchmarks.readAsciiD2s();
        ParseBenchmarks.readBinaryQds();
        ParseBenchmarks.readBinaryD2s();
    }

    private static void readStream(File f) throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        String ext = f.toString().substring(f.toString().lastIndexOf("."));
        if (ext.equals(".qds")) {
            long t0 = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(f);
            QDataSetStreamHandler handler = new QDataSetStreamHandler();
            StreamTool.readStream(Channels.newChannel(in), handler);
            QDataSet qds = handler.getDataSet();
            System.err.println("Time to read " + qds.length() + " records: " + (System.currentTimeMillis() - t0));
        } else {
            long t0 = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(f);
            DataSetStreamHandler handler = new DataSetStreamHandler(new HashMap(), (ProgressMonitor)new NullProgressMonitor());
            org.das2.stream.StreamTool.readStream((ReadableByteChannel)Channels.newChannel(in), (StreamHandler)handler);
            DataSet ds = handler.getDataSet();
            System.err.println("Time to read " + ds.getXLength() + " records: " + (System.currentTimeMillis() - t0));
        }
    }

    private static void readAsciiQds() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        File f = new File(System.getProperty("user.home") + "/temp/benchmark1.qds");
        for (int i = 0; i < 5; ++i) {
            ParseBenchmarks.readStream(f);
        }
    }

    private static void readAsciiD2s() throws FileNotFoundException, org.das2.stream.StreamException, StreamException {
        File f = new File(System.getProperty("user.home") + "/temp/benchmark1.d2s");
        for (int i = 0; i < 5; ++i) {
            ParseBenchmarks.readStream(f);
        }
    }

    private static void readBinaryQds() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        File f = new File(System.getProperty("user.home") + "/temp/benchmark1.binary.qds");
        for (int i = 0; i < 5; ++i) {
            ParseBenchmarks.readStream(f);
        }
    }

    private static void readBinaryD2s() throws FileNotFoundException, org.das2.stream.StreamException, StreamException {
        File f = new File(System.getProperty("user.home") + "/temp/benchmark1.binary.d2s");
        for (int i = 0; i < 5; ++i) {
            ParseBenchmarks.readStream(f);
        }
    }
}

