/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletHttpProtocol
implements WebProtocol {
    @Override
    public InputStream getInputStream(WebFileObject fo, ProgressMonitor mon) throws IOException {
        HttpURLConnection connect = (HttpURLConnection)fo.wfs.getURL(fo.pathname).openConnection();
        connect.connect();
        int len = connect.getContentLength();
        DasProgressMonitorInputStream in = new DasProgressMonitorInputStream(connect.getInputStream(), mon);
        if (len != -1) {
            in.setStreamLength(len);
        }
        return in;
    }

    @Override
    public Map<String, String> getMetadata(WebFileObject fo) throws IOException {
        String realName = fo.pathname;
        URL ur = new URL(fo.wfs.getRootURL(), realName);
        HttpURLConnection connect = (HttpURLConnection)ur.openConnection();
        connect.setRequestMethod("HEAD");
        HttpURLConnection.setFollowRedirects(false);
        connect.connect();
        HttpURLConnection.setFollowRedirects(true);
        if (connect.getResponseCode() == 303) {
            String surl = connect.getHeaderField("Location");
            if (surl.startsWith(fo.wfs.root.toString())) {
                realName = surl.substring(fo.wfs.root.toString().length());
            }
            connect.disconnect();
            ur = new URL(fo.wfs.getRootURL(), realName);
            connect = (HttpURLConnection)ur.openConnection();
            connect.setRequestMethod("HEAD");
            connect.connect();
        }
        boolean exists = connect.getResponseCode() != 404;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, List<String>> fields = connect.getHeaderFields();
        for (Map.Entry<String, List<String>> e : fields.entrySet()) {
            String key = e.getKey();
            List<String> value = e.getValue();
            result.put(key, value.get(0));
        }
        result.put("exist", String.valueOf(exists));
        connect.disconnect();
        return result;
    }
}

