/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.filesystem.WriteCapability;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileObject
extends FileObject {
    File localFile;
    File localRoot;
    LocalFileSystem lfs;

    protected LocalFileObject(LocalFileSystem lfs, File localRoot, String filename) {
        this.lfs = lfs;
        this.localFile = new File(localRoot, filename);
        this.localRoot = localRoot;
    }

    @Override
    public boolean canRead() {
        return this.localFile.canRead();
    }

    @Override
    public FileObject[] getChildren() {
        File[] files = this.localFile.listFiles();
        FileObject[] result = new LocalFileObject[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(files[i]));
        }
        return result;
    }

    @Override
    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException {
        return new FileInputStream(this.localFile);
    }

    @Override
    public FileObject getParent() {
        if (!this.localFile.equals(this.localRoot)) {
            return new LocalFileObject(this.lfs, this.localRoot, this.lfs.getLocalName(this.localFile.getParentFile()));
        }
        return null;
    }

    @Override
    public long getSize() {
        return this.localFile.length();
    }

    @Override
    public boolean isData() {
        return this.localFile.isFile();
    }

    @Override
    public boolean isFolder() {
        return this.localFile.isDirectory();
    }

    @Override
    public boolean isReadOnly() {
        return !this.localFile.canWrite();
    }

    @Override
    public boolean isRoot() {
        return this.localFile.getParentFile() == null;
    }

    @Override
    public Date lastModified() {
        return new Date(this.localFile.lastModified());
    }

    @Override
    public boolean exists() {
        return this.localFile.exists();
    }

    @Override
    public String getNameExt() {
        return FileSystem.toCanonicalFilename(this.localFile.toString().substring(this.localRoot.toString().length()));
    }

    public String toString() {
        return "[" + this.lfs + "]" + this.getNameExt();
    }

    @Override
    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException {
        return ((FileInputStream)this.getInputStream(monitor)).getChannel();
    }

    @Override
    public File getFile() throws FileNotFoundException {
        return this.getFile(new NullProgressMonitor());
    }

    @Override
    public File getFile(ProgressMonitor monitor) throws FileNotFoundException {
        if (!this.localFile.exists()) {
            throw new FileNotFoundException("file not found: " + this.localFile);
        }
        return this.localFile;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == WriteCapability.class) {
            return (T)new WriteCapability(){

                public OutputStream getOutputStream() throws FileNotFoundException {
                    return new FileOutputStream(LocalFileObject.this.localFile);
                }

                public boolean canWrite() {
                    return LocalFileObject.this.localFile.canWrite();
                }

                public boolean delete() {
                    return LocalFileObject.this.localFile.delete();
                }
            };
        }
        return super.getCapability(clazz);
    }
}

