/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;

public class SubFileSystem
extends FileSystem {
    FileSystem parent;
    String dir;

    protected SubFileSystem(FileSystem parent, String dir) throws MalformedURLException {
        super(parent.getRootURI().resolve(dir));
        this.parent = parent;
        this.dir = dir;
    }

    public FileObject getFileObject(String filename) {
        return this.parent.getFileObject(this.dir + filename);
    }

    public boolean isDirectory(String filename) throws IOException {
        return this.parent.isDirectory(this.dir + filename);
    }

    public String[] listDirectory(String directory) throws IOException {
        return this.parent.listDirectory(this.dir + directory);
    }

    public String[] listDirectory(String directory, String regex) throws IOException {
        return this.parent.listDirectory(this.dir + directory, regex);
    }

    public File getLocalRoot() {
        return new File(this.parent.getLocalRoot(), this.dir);
    }
}

