/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.DasUpdateEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.SeriesRenderer;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsutil.DataSetBuilder;

public class AngleSpectrogramSlicer
extends DasPlot
implements BoxSelectionListener {
    private JDialog popupWindow;
    private SeriesRenderer renderer;
    private DasPlot parentPlot;
    private TableDataSetConsumer consumer;
    private Datum xstart;
    private Datum ystart;
    private DatumRange xrange;
    private DatumRange yrange;
    private int sliceDir;
    private final int SLICEDIR_HORIZ = 0;
    private final int SLICEDIR_VERTICAL = 1;

    private AngleSpectrogramSlicer(DasPlot plot, DasAxis xAxis, DasAxis yAxis, TableDataSetConsumer consumer) {
        super(xAxis, yAxis);
        this.parentPlot = plot;
        this.renderer = new SeriesRenderer();
        this.consumer = consumer;
        this.addRenderer(this.renderer);
    }

    public static AngleSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceXAxis = plot.getXAxis();
        DasAxis xAxis = sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = dataSetConsumer.getZAxis().createAttachedAxis(3);
        return new AngleSpectrogramSlicer(plot, xAxis, yAxis, dataSetConsumer);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    AngleSpectrogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton printButton = new JButton(new AbstractAction("Print..."){

            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        buttonPanel.add(printButton);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AngleSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Angle Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.parentPlot.getCanvas().getWidth(), parentLocation.y + height);
    }

    private QDataSet angleSliceHoriz(QDataSet tds, DatumRange xlimit, Datum xbase, Datum ybase, Datum slope) {
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        DataSetBuilder xbuilder = new DataSetBuilder(1, 100);
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds);
        int i0 = DataSetUtil.closestIndex((QDataSet)xds, (Datum)xlimit.min());
        int i1 = DataSetUtil.closestIndex((QDataSet)xds, (Datum)xlimit.max());
        int irow0 = 0;
        int irow1 = 0;
        Units zunits = SemanticOps.getUnits((QDataSet)tds);
        Units yunits = SemanticOps.getUnits((QDataSet)yds);
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        for (int i = i0; i < i1; ++i) {
            double x = xds.value(i);
            double y = ybase.add(slope.multiply(x - xbase.doubleValue(xunits))).doubleValue(yunits);
            while (irow0 > 0 && yds.value(irow0) > y) {
                --irow0;
            }
            irow1 = irow0 + 1;
            while (irow1 + 1 < yds.length() && yds.value(irow1) < y) {
                ++irow1;
            }
            irow0 = irow1 - 1;
            if (irow0 <= 0) continue;
            double z0 = tds.value(i, irow0);
            double z1 = tds.value(i, irow1);
            double y0 = yds.value(irow0);
            double y1 = yds.value(irow1);
            double yy = y;
            double alpha = (yy - y0) / (y1 - y0);
            double zinterp = z0 + (z1 - z0) * alpha;
            builder.putValue(-1, zinterp);
            xbuilder.putValue(-1, x);
            builder.nextRecord();
            xbuilder.nextRecord();
        }
        xbuilder.putProperty("UNITS", (Object)xunits);
        builder.putProperty("UNITS", (Object)zunits);
        builder.putProperty("DEPEND_0", (Object)xbuilder.getDataSet());
        return builder.getDataSet();
    }

    public void drawContent(Graphics2D g) {
        double ix;
        double[] ixs;
        if (this.sliceDir == 0) {
            ixs = GraphUtil.transformRange(this.getXAxis(), this.xrange);
            ix = this.getXAxis().transform(this.xstart);
        } else {
            ixs = GraphUtil.transformRange(this.getYAxis(), this.yrange);
            ix = this.getYAxis().transform(this.ystart);
        }
        DasRow row = this.getRow();
        g.setColor(new Color(230, 230, 230));
        g.fillRect((int)ixs[0], row.getDMinimum(), (int)(ixs[1] - ixs[0]), row.getHeight());
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine((int)ix, row.getDMinimum(), (int)ix, row.getDMaximum());
        super.drawContent(g);
    }

    protected void processDasUpdateEvent(DasUpdateEvent e) {
        if (this.isDisplayable()) {
            this.updateImmediately();
            this.resize();
        }
    }

    public void BoxSelected(BoxSelectionEvent e) {
        Datum xbase = e.getStartX();
        Datum ybase = e.getStartY();
        this.xstart = e.getStartX();
        this.ystart = e.getStartY();
        this.xrange = e.getXRange();
        this.yrange = e.getYRange();
        Datum slope = e.getFinishY().subtract(ybase).divide(e.getFinishX().subtract(xbase));
        QDataSet ds = this.consumer.getConsumedDataSet();
        if (ds == null || !SemanticOps.isSimpleTableDataSet((QDataSet)ds)) {
            return;
        }
        QDataSet tds = ds;
        QDataSet sliceDataSet = this.angleSliceHoriz(tds, this.getXAxis().getDatumRange(), xbase, ybase, slope);
        this.sliceDir = 0;
        this.renderer.setDataSet(sliceDataSet);
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        }
    }
}

