/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.das2.DasException;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.event.CommentDataPointSelectionEvent;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataPointRecorder
extends JPanel
implements DataPointSelectionListener {
    protected JTable table;
    protected JScrollPane scrollPane;
    protected List dataPoints;
    private int selectRow;
    protected Units[] unitsArray;
    protected String[] planesArray;
    protected AbstractTableModel myTableModel;
    private File saveFile;
    private boolean modified;
    private JLabel messageLabel;
    private boolean active = true;
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private static final Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private MyDataSetDescriptor dataSetDescriptor;
    private EventListenerList listenerList1 = null;
    private EventListenerList selectedListenerList = null;
    private boolean sorted = true;
    private Datum xTagWidth = null;
    private boolean snapToGrid = false;

    public void deleteRow(int row) {
        this.dataPoints.remove(row);
        this.modified = true;
        this.updateClients();
        this.updateStatus();
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.dataSetDescriptor == null) {
            this.dataSetDescriptor = new MyDataSetDescriptor();
        }
        return this.dataSetDescriptor;
    }

    public VectorDataSet getDataSet() {
        if (this.dataPoints.size() == 0) {
            return null;
        }
        VectorDataSetBuilder builder = new VectorDataSetBuilder(this.unitsArray[0], this.unitsArray[1]);
        for (int i = 2; i < this.planesArray.length; ++i) {
            if (this.unitsArray[i] == null) continue;
            builder.addPlane(this.planesArray[i], this.unitsArray[i]);
        }
        for (int irow = 0; irow < this.dataPoints.size(); ++irow) {
            DataPoint dp = (DataPoint)this.dataPoints.get(irow);
            builder.insertY(dp.get(0), dp.get(1));
            for (int i = 2; i < this.planesArray.length; ++i) {
                if (this.unitsArray[i] == null) continue;
                builder.insertY(dp.get(0), (Datum)dp.getPlane(this.planesArray[i]), this.planesArray[i]);
            }
        }
        if (this.xTagWidth != null) {
            builder.setProperty("xTagWidth", this.xTagWidth);
        }
        return builder.toVectorDataSet();
    }

    public VectorDataSet getSelectedDataSet() {
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows.length == 0) {
            return null;
        }
        VectorDataSetBuilder builder = new VectorDataSetBuilder(this.unitsArray[0], this.unitsArray[1]);
        for (int j = 2; j < this.planesArray.length; ++j) {
            builder.addPlane(this.planesArray[j], this.unitsArray[j]);
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            int irow = selectedRows[i];
            DataPoint dp = (DataPoint)this.dataPoints.get(irow);
            builder.insertY(dp.get(0), dp.get(1));
            for (int j = 2; j < this.planesArray.length; ++j) {
                builder.insertY(dp.get(0).doubleValue(this.unitsArray[0]), ((Datum)dp.getPlane(this.planesArray[j])).doubleValue(this.unitsArray[j]), this.planesArray[j]);
            }
        }
        if (this.xTagWidth != null) {
            builder.setProperty("xTagWidth", this.xTagWidth);
        }
        return builder.toVectorDataSet();
    }

    public void select(DatumRange xrange, DatumRange yrange) {
        int i;
        ArrayList<Integer> selectMe = new ArrayList<Integer>();
        for (i = 0; i < this.dataPoints.size(); ++i) {
            DataPoint p = (DataPoint)this.dataPoints.get(i);
            if (!xrange.contains(p.data[0]) || !yrange.contains(p.data[1])) continue;
            selectMe.add(i);
        }
        this.table.getSelectionModel().clearSelection();
        for (i = 0; i < selectMe.size(); ++i) {
            int iselect = (Integer)selectMe.get(i);
            this.table.getSelectionModel().addSelectionInterval(iselect, iselect);
        }
    }

    public void saveToFile(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        BufferedWriter r = new BufferedWriter(new OutputStreamWriter(out));
        StringBuilder header = new StringBuilder();
        header.append("## ");
        for (int j = 0; j < this.planesArray.length; ++j) {
            header.append(this.myTableModel.getColumnName(j)).append("\t");
        }
        r.write(header.toString());
        r.newLine();
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            int j;
            DataPoint x = (DataPoint)this.dataPoints.get(i);
            StringBuilder s = new StringBuilder();
            for (j = 0; j < 2; ++j) {
                DatumFormatter formatter = x.get(j).getFormatter();
                s.append(formatter.format(x.get(j), this.unitsArray[j])).append("\t");
            }
            for (j = 2; j < this.planesArray.length; ++j) {
                Object o = x.getPlane(this.planesArray[j]);
                if (this.unitsArray[j] == null) {
                    if (o == null) {
                        o = "";
                    }
                    s.append("\"").append(o).append("\"\t");
                    continue;
                }
                Datum d = (Datum)o;
                DatumFormatter f = d.getFormatter();
                s.append(f.format(d, this.unitsArray[j])).append("\t");
            }
            r.write(s.toString());
            r.newLine();
            this.prefs.put("components.DataPointRecorder.lastFileSave", file.toString());
            this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
        }
        r.close();
        this.modified = false;
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file) throws IOException {
        DasProgressPanel mon = null;
        try {
            this.active = false;
            FileInputStream in = new FileInputStream(file);
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            int lineCount = 0;
            String line = r.readLine();
            while (line != null) {
                ++lineCount;
                line = r.readLine();
            }
            r.close();
            in = new FileInputStream(file);
            r = new BufferedReader(new InputStreamReader(in));
            this.dataPoints.clear();
            String[] planesArray1 = null;
            Units[] unitsArray1 = null;
            mon = lineCount > 500 ? DasProgressPanel.createFramed("reading file") : new NullProgressMonitor();
            boolean hasTabs = false;
            String delim = "\t";
            mon.setTaskSize(lineCount);
            mon.started();
            int linenum = 0;
            String line2 = r.readLine();
            while (line2 != null) {
                Matcher m;
                String[] s;
                ++linenum;
                if (mon.isCancelled()) {
                    break;
                }
                mon.setTaskProgress(linenum);
                if (line2.startsWith("## ")) {
                    if (unitsArray1 == null) {
                        if ((line2 = line2.substring(3)).indexOf("\t") == -1) {
                            delim = "\\s+";
                        }
                        s = line2.trim().split(delim);
                        Pattern p = Pattern.compile("(.+)\\((.*)\\)");
                        planesArray1 = new String[s.length];
                        unitsArray1 = new Units[s.length];
                        for (int i = 0; i < s.length; ++i) {
                            m = p.matcher(s[i]);
                            if (m.matches()) {
                                planesArray1[i] = m.group(1);
                                unitsArray1[i] = Units.getByName((String)m.group(2));
                                continue;
                            }
                            planesArray1[i] = s[i];
                            unitsArray1[i] = null;
                        }
                    }
                } else {
                    s = line2.trim().split(delim);
                    if (unitsArray1 == null) {
                        unitsArray1 = new Units[s.length];
                        for (int i = 0; i < s.length; ++i) {
                            unitsArray1[i] = s[i].charAt(0) == '\"' ? null : (TimeUtil.isValidTime((String)s[i]) ? Units.us2000 : DatumUtil.parseValid((String)s[i]).getUnits());
                        }
                        planesArray1 = new String[]{"X", "Y", "comment"};
                    }
                    try {
                        Datum x = unitsArray1[0].parse(s[0]);
                        Datum y = unitsArray1[1].parse(s[1]);
                        LinkedHashMap<String, String> planes = new LinkedHashMap<String, String>();
                        for (int i = 2; i < s.length; ++i) {
                            if (unitsArray1[i] == null) {
                                Pattern p = Pattern.compile("\"(.*)\".*");
                                m = p.matcher(s[i]);
                                if (m.matches()) {
                                    planes.put(planesArray1[i], m.group(1));
                                    continue;
                                }
                                throw new ParseException("parse error, expected \"\"", 0);
                            }
                            try {
                                planes.put(planesArray1[i], (String)unitsArray1[i].parse(s[i]));
                                continue;
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        DataPointSelectionEvent e = new DataPointSelectionEvent(this, x, y, planes);
                        this.dataPointSelected(e);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                line2 = r.readLine();
            }
        }
        finally {
            mon.finished();
            this.active = true;
            this.modified = false;
            this.updateStatus();
            this.updateClients();
            this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
            this.table.getColumnModel();
            this.table.repaint();
        }
    }

    private Action getSaveAsAction() {
        return new AbstractAction("Save As..."){

            public void actionPerformed(ActionEvent e) {
                int status;
                JFileChooser jj = new JFileChooser();
                String lastFileString = DataPointRecorder.this.prefs.get("components.DataPointRecorder.lastFileSave", "");
                File lastFile = null;
                if (lastFileString.length() > 0) {
                    lastFile = new File(lastFileString);
                    jj.setSelectedFile(lastFile);
                }
                if ((status = jj.showSaveDialog(DataPointRecorder.this)) == 0) {
                    try {
                        DataPointRecorder.this.saveFile = jj.getSelectedFile();
                        DataPointRecorder.this.saveToFile(DataPointRecorder.this.saveFile);
                    }
                    catch (IOException e1) {
                        DasExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        };
    }

    private Action getSaveAction() {
        return new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.saveFile == null) {
                    DataPointRecorder.this.getSaveAsAction().actionPerformed(e);
                } else {
                    try {
                        DataPointRecorder.this.saveToFile(DataPointRecorder.this.saveFile);
                    }
                    catch (IOException ex) {
                        DasExceptionHandler.handle((Throwable)ex);
                    }
                }
            }
        };
    }

    private Action getLoadAction() {
        return new AbstractAction("Open..."){

            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.checkModified(e)) {
                    int status;
                    JFileChooser jj = new JFileChooser();
                    String lastFileString = DataPointRecorder.this.prefs.get("components.DataPointRecorder.lastFileLoad", "");
                    File lastFile = null;
                    if (lastFileString.length() > 0) {
                        lastFile = new File(lastFileString);
                        jj.setSelectedFile(lastFile);
                    }
                    if ((status = jj.showOpenDialog(DataPointRecorder.this)) == 0) {
                        final File loadFile = jj.getSelectedFile();
                        DataPointRecorder.this.prefs.put("components.DataPointRecorder.lastFileLoad", loadFile.toString());
                        Runnable run = new Runnable(){

                            public void run() {
                                try {
                                    DataPointRecorder.this.loadFromFile(loadFile);
                                    DataPointRecorder.this.saveFile = loadFile;
                                    DataPointRecorder.this.updateStatus();
                                }
                                catch (IOException e) {
                                    DasExceptionHandler.handle((Throwable)e);
                                }
                            }
                        };
                        new Thread(run).start();
                    }
                }
            }
        };
    }

    private boolean checkModified(ActionEvent e) {
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog(this, "Current work has not been saved.\n  Save first?", "Save work first", 1);
            if (n == 0) {
                this.getSaveAction().actionPerformed(e);
            }
            return n != 2;
        }
        return true;
    }

    private Action getNewAction() {
        return new AbstractAction("New"){

            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.checkModified(e)) {
                    DataPointRecorder.this.dataPoints.removeAll(DataPointRecorder.this.dataPoints);
                    DataPointRecorder.this.saveFile = null;
                    DataPointRecorder.this.updateStatus();
                    DataPointRecorder.this.updateClients();
                }
            }
        };
    }

    private Action getPropertiesAction() {
        return new AbstractAction("Properties"){

            public void actionPerformed(ActionEvent e) {
                new PropertyEditor(DataPointRecorder.this).showDialog(DataPointRecorder.this);
            }
        };
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.dataSetDescriptor != null) {
                    DataPointRecorder.this.dataSetDescriptor.fireUpdate();
                }
                DataPointRecorder.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
                DataPointRecorder.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
            }
        };
    }

    public DataPointRecorder() {
        this.dataPoints = new ArrayList();
        this.myTableModel = new MyTableModel();
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new JMenuItem(this.getNewAction()));
        fileMenu.add(new JMenuItem(this.getLoadAction()));
        fileMenu.add(new JMenuItem(this.getSaveAction()));
        fileMenu.add(new JMenuItem(this.getSaveAsAction()));
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(new JMenuItem(this.getPropertiesAction()));
        menuBar.add(editMenu);
        this.add((Component)menuBar, "North");
        this.planesArray = new String[]{"X", "Y"};
        this.unitsArray = new Units[]{null, null};
        this.table = new JTable(this.myTableModel);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MyMouseAdapter(this.table));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DataPointRecorder.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(DataPointRecorder.this));
                int selected = DataPointRecorder.this.table.getSelectedRow();
                if (selected > -1) {
                    DataPoint dp = (DataPoint)DataPointRecorder.this.dataPoints.get(selected);
                    DataPointSelectionEvent e2 = new DataPointSelectionEvent(DataPointRecorder.this, dp.get(0), dp.get(1));
                    DataPointRecorder.this.fireDataPointSelectionListenerDataPointSelected(e2);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        JPanel controlStatusPanel = new JPanel();
        controlStatusPanel.setLayout(new BoxLayout(controlStatusPanel, 1));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton updateButton = new JButton(this.getUpdateAction());
        controlPanel.add(updateButton);
        this.messageLabel = new JLabel("ready");
        this.messageLabel.setAlignmentX(0.0f);
        controlStatusPanel.add(this.messageLabel);
        controlPanel.setAlignmentX(0.0f);
        controlStatusPanel.add(controlPanel);
        this.add((Component)controlStatusPanel, "South");
    }

    public static DataPointRecorder createFramed() {
        JFrame frame = new JFrame("Data Point Recorder");
        DataPointRecorder result = new DataPointRecorder();
        frame.getContentPane().add(result);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(1);
        return result;
    }

    private void updateClients() {
        if (this.active) {
            this.myTableModel.fireTableDataChanged();
            if (this.selectRow != -1 && this.table.getRowCount() > this.selectRow) {
                this.table.setRowSelectionInterval(this.selectRow, this.selectRow);
                this.table.scrollRectToVisible(this.table.getCellRect(this.selectRow, 0, true));
                this.selectRow = -1;
            }
        }
    }

    private void updateStatus() {
        String statusString = (this.saveFile == null ? "" : String.valueOf(this.saveFile) + " ") + (this.modified ? "(modified)" : "");
        this.messageLabel.setText(statusString);
    }

    private void insertInternal(DataPoint newPoint) {
        int newSelect;
        if (this.sorted) {
            int index = Collections.binarySearch(this.dataPoints, newPoint);
            if (index < 0) {
                this.dataPoints.add(~index, newPoint);
                newSelect = ~index;
            } else {
                this.dataPoints.set(index, newPoint);
                newSelect = index;
            }
        } else {
            this.dataPoints.add(newPoint);
            newSelect = this.dataPoints.size() - 1;
        }
        this.selectRow = newSelect;
        this.modified = true;
        this.updateStatus();
        this.updateClients();
    }

    public void addDataPoint(Datum x, Datum y, Map planes) {
        if (planes == null) {
            planes = new HashMap();
        }
        if (this.dataPoints.size() == 0) {
            this.unitsArray = new Units[2 + planes.size()];
            this.unitsArray[0] = x.getUnits();
            this.unitsArray[1] = y.getUnits();
            this.planesArray = new String[2 + planes.size()];
            this.planesArray[0] = "x";
            this.planesArray[1] = "y";
            int index = 2;
            for (Object key : planes.keySet()) {
                this.planesArray[index] = String.valueOf(key);
                Object value = planes.get(key);
                this.unitsArray[index] = value instanceof String ? null : ((Datum)value).getUnits();
                ++index;
            }
            this.myTableModel.fireTableStructureChanged();
        }
        if (!x.getUnits().isConvertableTo(this.unitsArray[0])) {
            throw new RuntimeException("inconvertible units: " + x + " expected " + this.unitsArray[0]);
        }
        if (!y.getUnits().isConvertableTo(this.unitsArray[1])) {
            throw new RuntimeException("inconvertible units: " + y + " expected " + this.unitsArray[1]);
        }
        this.insertInternal(new DataPoint(x, y, new LinkedHashMap(planes)));
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        }
    }

    public void appendDataSet(VectorDataSet ds) {
        LinkedHashMap<String, Object> planesMap = new LinkedHashMap<String, Object>();
        if (ds.getProperty("comment") != null) {
            planesMap.put("comment", ds.getProperty("comment"));
        }
        if (ds.getProperty("xTagWidth") != null) {
            this.xTagWidth = (Datum)ds.getProperty("xTagWidth");
        }
        String[] planes = ds.getPlaneIds();
        for (int i = 0; i < ds.getXLength(); ++i) {
            for (int j = 0; j < planes.length; ++j) {
                if (planes[j].equals("")) continue;
                planesMap.put(planes[j], ((VectorDataSet)ds.getPlanarView(planes[j])).getDatum(i));
            }
            this.addDataPoint(ds.getXTagDatum(i), ds.getDatum(i), planesMap);
        }
        this.updateClients();
    }

    public DataSetUpdateListener getAppendDataSetUpListener() {
        return new DataSetUpdateListener(){

            public void dataSetUpdated(DataSetUpdateEvent e) {
                VectorDataSet ds = (VectorDataSet)e.getDataSet();
                if (ds == null) {
                    throw new RuntimeException("not supported, I need the DataSet in the update event");
                }
                DataPointRecorder.this.appendDataSet((VectorDataSet)e.getDataSet());
            }
        };
    }

    public void dataPointSelected(DataPointSelectionEvent e) {
        Datum x;
        LinkedHashMap<String, Object> planesMap;
        String comment = "";
        if (e instanceof CommentDataPointSelectionEvent) {
            comment = ((CommentDataPointSelectionEvent)e).getComment();
            planesMap = new LinkedHashMap();
            planesMap.put("comment", comment);
        } else {
            x = e.getPlaneIds();
            planesMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < ((String[])x).length; ++i) {
                planesMap.put((String)x[i], e.getPlane((String)x[i]));
            }
        }
        x = e.getX();
        if (this.snapToGrid && this.xTagWidth != null && this.dataPoints.size() > 0) {
            VectorDataSet ds = this.getDataSet();
            int i = DataSetUtil.closestColumn(ds, e.getX());
            Datum diff = e.getX().subtract(ds.getXTagDatum(i));
            if (Math.abs(diff.divide(this.xTagWidth).doubleValue(Units.dimensionless)) < 0.5) {
                x = ds.getXTagDatum(i);
            }
        }
        this.addDataPoint(x, e.getY(), planesMap);
        this.updateClients();
    }

    public synchronized void addDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.listenerList1 == null) {
            this.listenerList1 = new EventListenerList();
        }
        this.listenerList1.add(DataSetUpdateListener.class, listener);
    }

    public synchronized void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        this.listenerList1.remove(DataSetUpdateListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        Object[] listeners;
        DataPointRecorder dataPointRecorder = this;
        synchronized (dataPointRecorder) {
            if (this.listenerList1 == null) {
                return;
            }
            listeners = this.listenerList1.getListenerList();
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public synchronized void addSelectedDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.selectedListenerList == null) {
            this.selectedListenerList = new EventListenerList();
        }
        this.selectedListenerList.add(DataSetUpdateListener.class, listener);
    }

    public synchronized void removeSelectedDataSetUpdateListener(DataSetUpdateListener listener) {
        this.selectedListenerList.remove(DataSetUpdateListener.class, listener);
    }

    private void fireSelectedDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        if (this.selectedListenerList == null) {
            return;
        }
        Object[] listeners = this.selectedListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener listener) {
        if (this.listenerList1 == null) {
            this.listenerList1 = new EventListenerList();
        }
        this.listenerList1.add(DataPointSelectionListener.class, listener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList1.remove(DataPointSelectionListener.class, listener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        if (this.listenerList1 == null) {
            return;
        }
        logger.fine("firing data point selection event");
        Object[] listeners = this.listenerList1.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    public Datum getXTagWidth() {
        return this.xTagWidth;
    }

    public void setXTagWidth(Datum xTagWidth) {
        this.xTagWidth = xTagWidth;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        JPopupMenu popup;
        JMenuItem menuItem;
        final JTable parent;
        MouseAdapter mm;

        MyMouseAdapter(final JTable parent) {
            this.parent = parent;
            this.popup = new JPopupMenu("Options");
            this.menuItem = new JMenuItem("Delete Row(s)");
            this.menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selectedRows = parent.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        DataPointRecorder.this.deleteRow(selectedRows[i]);
                        int j = i + 1;
                        while (j < selectedRows.length) {
                            int n = j++;
                            selectedRows[n] = selectedRows[n] - 1;
                        }
                    }
                }
            });
            this.popup.add(this.menuItem);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                int rowCount = this.parent.getSelectedRows().length;
                this.menuItem.setText("Delete " + rowCount + " Row" + (rowCount != 1 ? "s" : ""));
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class MyDataSetDescriptor
    extends DataSetDescriptor {
        MyDataSetDescriptor() {
            super(null);
        }

        public void fireUpdate() {
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent((Object)this));
        }

        protected DataSet getDataSetImpl(Datum s1, Datum s2, Datum s3, ProgressMonitor monitor) throws DasException {
            if (DataPointRecorder.this.dataPoints.size() == 0) {
                return null;
            }
            VectorDataSetBuilder builder = new VectorDataSetBuilder(DataPointRecorder.this.unitsArray[0], DataPointRecorder.this.unitsArray[1]);
            for (int irow = 0; irow < DataPointRecorder.this.dataPoints.size(); ++irow) {
                DataPoint dp = (DataPoint)DataPointRecorder.this.dataPoints.get(irow);
                builder.insertY(dp.get(0), dp.get(1));
            }
            return builder.toVectorDataSet();
        }

        public Units getXUnits() {
            return DataPointRecorder.this.unitsArray[0];
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public int getColumnCount() {
            if (DataPointRecorder.this.unitsArray == null) {
                return 2;
            }
            return DataPointRecorder.this.planesArray.length;
        }

        public String getColumnName(int j) {
            String result = DataPointRecorder.this.planesArray[j];
            if (DataPointRecorder.this.unitsArray[j] != null) {
                result = result + "(" + DataPointRecorder.this.unitsArray[j] + ")";
            }
            return result;
        }

        public int getRowCount() {
            int nrow = DataPointRecorder.this.dataPoints.size();
            nrow = nrow > 0 ? nrow : 1;
            return DataPointRecorder.this.dataPoints.size();
        }

        public Object getValueAt(int i, int j) {
            DataPoint x = (DataPoint)DataPointRecorder.this.dataPoints.get(i);
            if (j < x.data.length) {
                Datum d = x.get(j);
                DatumFormatter format = d.getFormatter();
                return format.format(d, DataPointRecorder.this.unitsArray[j]);
            }
            Object o = x.getPlane(DataPointRecorder.this.planesArray[j]);
            if (o instanceof Datum) {
                Datum d = (Datum)o;
                return d.getFormatter().format(d, DataPointRecorder.this.unitsArray[j]);
            }
            return (String)o;
        }
    }

    protected class DataPoint
    implements Comparable {
        Datum[] data;
        Map planes;

        public DataPoint(Datum x1, Datum x2, Map planes) {
            this(new Datum[]{x1, x2}, planes);
        }

        public DataPoint(Datum[] data, Map planes) {
            this.data = data;
            this.planes = planes;
        }

        Datum get(int i) {
            return this.data[i];
        }

        Object getPlane(String name) {
            return this.planes.get(name);
        }

        public int compareTo(Object o) {
            DataPoint that = (DataPoint)o;
            return this.data[0].lt(that.data[0]) ? -1 : (this.data[0].gt(that.data[0]) ? 1 : 0);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("" + this.data[0] + " " + this.data[1]);
            if (this.planes != null) {
                for (Object key : this.planes.keySet()) {
                    result.append(" ").append(this.planes.get(key));
                }
            }
            return result.toString();
        }
    }
}

