/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.event.DasUpdateEvent;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.SymbolLineRenderer;
import org.das2.system.DasLogger;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;

public class VerticalSpectrogramSlicer
extends DasPlot
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private DasPlot parentPlot;
    protected Datum yValue;
    private long eventBirthMilli;
    private SymbolLineRenderer renderer;
    private Color yMarkColor = new Color(230, 230, 230);

    protected VerticalSpectrogramSlicer(DasPlot parent, DasAxis xAxis, DasAxis yAxis) {
        super(xAxis, yAxis);
        this.parentPlot = parent;
        this.renderer = new SymbolLineRenderer();
        this.addRenderer(this.renderer);
    }

    protected void setDataSet(QDataSet ds) {
        this.renderer.setDataSet(ds);
    }

    public static VerticalSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(2);
        DasAxis yAxis = sourceZAxis.createAttachedAxis(3);
        return new VerticalSpectrogramSlicer(plot, xAxis, yAxis);
    }

    public static VerticalSpectrogramSlicer createSlicer(DasPlot plot, DasAxis xAxis, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        DasAxis yAxis = sourceZAxis.createAttachedAxis(3);
        return new VerticalSpectrogramSlicer(plot, xAxis, yAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    VerticalSpectrogramSlicer.this.showPopupImpl();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, 0.1, 0.9);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        canvas.add(this, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton printButton = new JButton(new AbstractAction("Print..."){

            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        buttonPanel.add(printButton);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerticalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow) : new JDialog());
        this.popupWindow.setTitle("Vertical Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point();
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(parentLocation.x + this.parentPlot.getCanvas().getWidth(), parentLocation.y);
    }

    protected void drawContent(Graphics2D g) {
        int ix = (int)this.getXAxis().transform(this.yValue);
        DasRow row = this.getRow();
        int iy0 = row.getDMinimum();
        int iy1 = row.getDMaximum();
        g.drawLine(ix + 3, iy0, ix, iy0 + 3);
        g.drawLine(ix - 3, iy0, ix, iy0 + 3);
        g.drawLine(ix + 3, iy1, ix, iy1 - 3);
        g.drawLine(ix - 3, iy1, ix, iy1 - 3);
        g.setColor(this.yMarkColor);
        g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
        super.drawContent(g);
    }

    protected boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible() && this.getCanvas() != null;
    }

    public void dataPointSelected(DataPointSelectionEvent e) {
        long[] xxx = new long[]{0L, 0L, 0L, 0L};
        xxx[0] = System.currentTimeMillis() - e.birthMilli;
        QDataSet ds = e.getDataSet();
        if (ds == null || !SemanticOps.isTableDataSet((QDataSet)ds)) {
            return;
        }
        QDataSet tds = ds;
        QDataSet tds1 = null;
        if (tds.rank() == 3) {
            for (int i = 0; i < tds.length(); ++i) {
                QDataSet bounds = DataSetOps.dependBounds((QDataSet)tds.slice(i));
                if (!DataSetOps.boundsContains((QDataSet)bounds, (Datum)e.getX(), (Datum)e.getY())) continue;
                tds1 = tds.slice(i);
                break;
            }
        } else {
            QDataSet bounds = DataSetOps.dependBounds((QDataSet)tds);
            if (DataSetOps.boundsContains((QDataSet)bounds, (Datum)e.getX(), (Datum)e.getY())) {
                tds1 = tds;
            }
        }
        if (tds1 == null) {
            return;
        }
        QDataSet xds = SemanticOps.xtagsDataSet(tds1);
        QDataSet sliceDataSet = tds1.slice(DataSetUtil.closestIndex((QDataSet)xds, (Datum)e.getX()));
        this.renderer.setDataSet(sliceDataSet);
        DasLogger.getLogger(DasLogger.GUI_LOG).finest("setDataSet sliceDataSet");
        if (!this.isPopupVisible()) {
            this.showPopup();
        }
        this.yValue = e.getY();
        Datum xValue = e.getX();
        Object formatter = xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : xValue.getFormatter();
        this.setTitle("x: " + formatter.format(xValue) + " y: " + this.yValue);
        this.eventBirthMilli = e.birthMilli;
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
        this.getCanvas().getGlassPane().setVisible(false);
    }

    protected void processDasUpdateEvent(DasUpdateEvent e) {
        if (this.isDisplayable()) {
            this.updateImmediately();
            this.resize();
        }
    }

    public Color getYMarkColor() {
        return this.yMarkColor;
    }

    public void setYMarkColor(Color yMarkColor) {
        this.yMarkColor = yMarkColor;
    }
}

