/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class BooleanEditor
implements PropertyEditor,
TableCellEditor {
    private JCheckBox editor;
    private Model model;
    private boolean selected;
    private Class type;
    private PropertyChangeSupport pcSupport;
    private EventListenerList listeners = new EventListenerList();
    private ChangeEvent evt;

    public BooleanEditor() {
        this.pcSupport = new PropertyChangeSupport(this);
    }

    private void initEditor() {
        if (this.editor == null) {
            this.model = new Model();
            this.editor = new JCheckBox();
            this.editor.setModel(this.model);
        }
    }

    public String getAsText() {
        return String.valueOf(this.selected);
    }

    public Object getValue() {
        return this.selected ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAsText(String str) throws IllegalArgumentException {
        Boolean value;
        if ("true".equalsIgnoreCase(str)) {
            value = Boolean.TRUE;
        } else if ("false".equalsIgnoreCase(str)) {
            value = Boolean.FALSE;
        } else {
            throw new IllegalArgumentException(str);
        }
        this.setValue(value);
    }

    public void setValue(Object obj) {
        Boolean value = (Boolean)obj;
        if (this.selected ^ value) {
            Boolean oldValue = this.selected ? Boolean.TRUE : Boolean.FALSE;
            this.selected = value;
            this.pcSupport.firePropertyChange("value", oldValue, value);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.initEditor();
        return this.editor;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle r) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcSupport.removePropertyChangeListener(l);
    }

    public Object getCellEditorValue() {
        return this.selected ? Boolean.TRUE : Boolean.FALSE;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.initEditor();
        this.editor.setForeground(table.getForeground());
        this.editor.setBackground(table.getBackground());
        this.setValue(value);
        return this.editor;
    }

    public boolean isCellEditable(EventObject evt) {
        return true;
    }

    public boolean shouldSelectCell(EventObject evt) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.add(CellEditorListener.class, l);
    }

    private void fireEditingStopped() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingStopped(this.evt);
        }
    }

    private void fireEditingCanceled() {
        Object[] l = this.listeners.getListenerList();
        for (int i = 0; i < l.length; i += 2) {
            if (l[i] != CellEditorListener.class) continue;
            CellEditorListener cel = (CellEditorListener)l[i + 1];
            if (this.evt == null) {
                this.evt = new ChangeEvent(this);
            }
            cel.editingCanceled(this.evt);
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private Model() {
        }

        public void setSelected(boolean b) {
            BooleanEditor.this.setValue(b ? Boolean.TRUE : Boolean.FALSE);
            BooleanEditor.this.fireEditingStopped();
        }

        public boolean isSelected() {
            return (Boolean)BooleanEditor.this.getValue();
        }
    }
}

