/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.FormContainer;
import org.das2.dasml.FormRadioButton;
import org.das2.dasml.Orientation;
import org.das2.dasml.ParsedExpressionException;
import org.das2.dasml.TransferableFormComponent;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormRadioButtonGroup
extends FormContainer
implements Editable,
FormComponent {
    private ButtonGroup group;

    public FormRadioButtonGroup() {
        DataFlavor[] flavors = new DataFlavor[]{TransferableFormComponent.RADIOBUTTON_FLAVOR};
        this.flavorList = Arrays.asList(flavors);
        this.setDirection(Orientation.HORIZONTAL);
        this.setHasBorder(false);
        this.group = new ButtonGroup();
    }

    FormRadioButtonGroup(Element element, FormBase form) throws DasPropertyException, ParsedExpressionException, DasNameException, SAXException {
        DataFlavor[] flavors = new DataFlavor[]{TransferableFormComponent.RADIOBUTTON_FLAVOR};
        this.flavorList = Arrays.asList(flavors);
        this.group = new ButtonGroup();
        String alignment = element.getAttribute("alignment");
        this.horizontalComponentAlignment = alignment.equals("left") ? 0.0f : (alignment.equals("right") ? 1.0f : 0.5f);
        String direction = element.getAttribute("direction");
        if (direction.equals("horizontal")) {
            this.setDirection(Orientation.HORIZONTAL);
        } else {
            this.setDirection(Orientation.VERTICAL);
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int index = 0; index < length; ++index) {
            String tagName;
            Node node = children.item(index);
            if (!(node instanceof Element) || !(tagName = node.getNodeName()).equals("radiobutton")) continue;
            FormRadioButton radiobutton = new FormRadioButton((Element)node, form);
            radiobutton.setAlignmentX(this.horizontalComponentAlignment);
            this.add(radiobutton);
        }
        this.setHasBorder(element.getAttribute("border").equals("true"));
        this.setBorderTitle(element.getAttribute("border-title"));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof FormRadioButton)) {
            throw new IllegalArgumentException("Only FormRadioButton instances allowed");
        }
        FormRadioButton radiobutton = (FormRadioButton)comp;
        super.addImpl(radiobutton, constraints, index);
        this.group.add(radiobutton);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("group");
        for (int index = 0; index < this.getComponentCount(); ++index) {
            FormComponent comp = (FormComponent)((Object)this.getComponent(index));
            Element child = comp.getDOMElement(document);
            element.appendChild(child);
        }
        return element;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }
}

