/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.FormContainer;
import org.das2.dasml.FormPanel;
import org.das2.dasml.ParsedExpressionException;
import org.das2.dasml.Processor;
import org.das2.dasml.TransferableFormComponent;
import org.das2.graph.DasCanvas;
import org.das2.graph.dnd.TransferableCanvas;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormWindow
extends FormContainer
implements Editable,
FormComponent {
    FormBase form;
    JDialog dialog;
    JInternalFrame internalFrame;
    String title = "";
    int windowWidth = -1;
    int windowHeight = -1;
    boolean shouldBeVisible = false;
    private String dasName;

    public FormWindow(String name, String title) {
        this(name, title, -1, -1);
    }

    public FormWindow(String name, String title, int width, int height) {
        this.flavorList = Arrays.asList(TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR);
        this.setLayout(new BorderLayout());
        this.title = title;
        this.windowWidth = width;
        this.windowHeight = height;
        if (name == null) {
            name = "window_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    FormWindow(Element element, FormBase form) throws DasException, ParsedExpressionException, SAXException {
        this.flavorList = Arrays.asList(TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR);
        this.setLayout(new BorderLayout());
        this.form = form;
        String name = element.getAttribute("name");
        String title = element.getAttribute("title");
        String alignment = element.getAttribute("alignment");
        int width = Integer.parseInt(element.getAttribute("width"));
        int height = Integer.parseInt(element.getAttribute("height"));
        Point location = FormWindow.parsePoint(element.getAttribute("location"));
        boolean visible = element.getAttribute("visible").equals("true");
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (node instanceof Element && node.getNodeName().equals("panel")) {
                try {
                    FormPanel panel = new FormPanel((Element)node, form);
                    this.add(panel);
                }
                catch (ParseException ex) {
                    DasExceptionHandler.handle((Throwable)ex);
                }
                continue;
            }
            if (!(node instanceof Element) || !node.getNodeName().equals("canvas")) continue;
            try {
                DasCanvas canvas = Processor.processCanvasElement((Element)node, form);
                this.add(canvas);
                continue;
            }
            catch (ParseException ex) {
                DasExceptionHandler.handle((Throwable)ex);
            }
        }
        this.setTitle(title);
        this.windowWidth = width;
        this.windowHeight = height;
        this.setWindowVisible(visible);
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    private static Point parsePoint(String str) {
        int commaIndex = str.indexOf(44);
        return new Point(Integer.parseInt(str.substring(1, commaIndex)), Integer.parseInt(str.substring(commaIndex + 1, str.length() - 1)));
    }

    public FormBase getForm() {
        return this.form;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("window");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", String.valueOf(this.getWidth()));
        element.setAttribute("height", String.valueOf(this.getHeight()));
        element.setAttribute("title", this.title);
        element.setAttribute("visible", String.valueOf(this.isVisible()));
        if (this.getComponentCount() > 0) {
            Component comp = this.getComponent(0);
            if (comp instanceof FormComponent) {
                FormComponent child = (FormComponent)((Object)comp);
                element.appendChild(child.getDOMElement(document));
            } else if (comp instanceof DasCanvas) {
                DasCanvas child = (DasCanvas)comp;
                element.appendChild(Processor.getDOMElement(child, document));
            }
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public boolean isWindowVisible() {
        if (this.getEditingMode()) {
            return this.shouldBeVisible;
        }
        return this.dialog == null ? false : this.dialog.isVisible();
    }

    public void setWindowVisible(boolean b) {
        boolean oldValue = this.isWindowVisible();
        if (oldValue == b) {
            return;
        }
        this.shouldBeVisible = b;
        if (!this.getEditingMode() && b) {
            if (this.dialog == null) {
                this.initDialog();
            }
            this.dialog.setVisible(b);
        }
        this.firePropertyChange("visible", oldValue, b);
    }

    public void setEditingMode(boolean b) {
        if (this.getEditingMode() == b) {
            return;
        }
        if (b) {
            if (this.dialog != null) {
                this.shouldBeVisible = this.dialog.isVisible();
                this.dialog.setVisible(false);
            } else {
                this.shouldBeVisible = false;
            }
            this.maybeInitializeInternalFrame();
            this.internalFrame.setContentPane(this);
        } else if (this.dialog != null) {
            this.dialog.setContentPane(this);
            this.dialog.pack();
            this.dialog.setVisible(this.shouldBeVisible);
        } else if (this.shouldBeVisible) {
            this.initDialog();
            this.dialog.pack();
            this.dialog.setVisible(this.shouldBeVisible);
        }
        super.setEditingMode(b);
    }

    public Dimension getPreferredSize() {
        if (this.windowWidth == -1 || this.windowHeight == -1) {
            return super.getPreferredSize();
        }
        return new Dimension(this.windowWidth, this.windowHeight);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.title == title || this.title != null && this.title.equals(title)) {
            return;
        }
        String oldValue = this.title;
        this.title = title;
        if (this.getEditingMode() && this.internalFrame != null) {
            this.internalFrame.setTitle(title);
        }
        this.firePropertyChange("title", oldValue, title);
    }

    public void pack() {
        if (this.getEditingMode()) {
            this.maybeInitializeInternalFrame();
            this.internalFrame.pack();
        } else {
            if (this.dialog == null) {
                this.initDialog();
            }
            this.dialog.pack();
        }
    }

    public Dimension getWindowSize() {
        return new Dimension(this.windowWidth, this.windowHeight);
    }

    public void setWindowSize(int width, int height) {
        int oldWidth = this.windowWidth;
        int oldHeight = this.windowHeight;
        if (width != this.windowWidth) {
            this.windowWidth = width;
            this.firePropertyChange("width", oldWidth, width);
        }
        if (height != this.windowHeight) {
            this.windowHeight = height;
            this.firePropertyChange("height", oldHeight, height);
        }
        if (height != this.windowHeight || width != this.windowWidth) {
            this.pack();
        }
    }

    public void setWindowWidth(int width) {
        this.setWindowSize(width, this.windowHeight);
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowHeight(int height) {
        this.setWindowSize(this.windowWidth, height);
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    private void initDialog() {
        Window w = SwingUtilities.getWindowAncestor(this.form);
        this.dialog = w instanceof Frame ? new JDialog((Frame)w) : (w instanceof Dialog ? new JDialog((Dialog)w) : new JDialog());
        this.dialog.setContentPane(this);
        this.dialog.setTitle(this.title);
    }

    private void maybeInitializeInternalFrame() {
        if (this.internalFrame == null) {
            this.internalFrame = new InternalFrame();
            this.internalFrame.setTitle(this.title);
            this.internalFrame.setVisible(true);
            this.internalFrame.setDefaultCloseOperation(0);
            if (this.getEditingMode()) {
                this.internalFrame.setContentPane(this);
            }
            this.internalFrame.pack();
        }
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }

    protected void addImpl(Component c, Object constraints, int index) {
        if (this.getComponentCount() >= 1) {
            throw new IllegalArgumentException("Only one component allowed");
        }
        super.addImpl(c, constraints, index);
        if (c instanceof JComponent) {
            ((JComponent)c).setAlignmentY(0.0f);
        }
    }

    JInternalFrame getInternalFrame() {
        if (this.getEditingMode()) {
            this.maybeInitializeInternalFrame();
            return this.internalFrame;
        }
        return null;
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
        super.deregisterComponent();
    }

    public DasApplication getDasApplication() {
        if (this.form != null) {
            return this.form.getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
        super.registerComponent();
    }

    public class InternalFrame
    extends JInternalFrame {
        InternalFrame() {
            super(null, true, false, false, false);
        }

        public FormWindow getWindow() {
            return FormWindow.this;
        }
    }
}

