/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.dataset.AbstractDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public abstract class AbstractTableDataSet
extends AbstractDataSet
implements DataSet,
TableDataSet {
    private Units zUnits;
    protected List<Map> tableProperties;

    public AbstractTableDataSet(double[] xTags, Units xUnits, Units yUnits, Units zUnits, Map properties) {
        super(xTags, xUnits, yUnits, properties);
        this.zUnits = zUnits;
        this.tableProperties = null;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public String toString() {
        return TableUtil.toString(this);
    }

    public Object getProperty(int table, String name) {
        if (this.tableProperties != null) {
            return this.tableProperties.get(table).get(name);
        }
        return null;
    }

    protected static class YSliceDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private final int table;
        private final int jIndex;
        private final TableDataSet ds;

        protected YSliceDataSet(AbstractDataSet ds, int jIndex, int table) {
            this.jIndex = jIndex;
            this.table = table;
            this.ds = (TableDataSet)((Object)ds);
        }

        public DataSet getPlanarView(String planeID) {
            return new YSliceDataSet((AbstractDataSet)this.ds.getPlanarView(planeID), this.jIndex, this.table);
        }

        public String[] getPlaneIds() {
            return this.ds.getPlaneIds();
        }

        public Datum getDatum(int i) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getDatum(i + offset, this.jIndex);
        }

        public double getDouble(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getDouble(i + offset, this.jIndex, units);
        }

        public int getInt(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getInt(i + offset, this.jIndex, units);
        }

        public Datum getXTagDatum(int i) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getXTagDatum(i + offset);
        }

        public int getXLength() {
            return this.ds.tableEnd(this.table) - this.ds.tableStart(this.table);
        }

        public double getXTagDouble(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getXTagDouble(i + offset, units);
        }

        public Units getYUnits() {
            return this.ds.getZUnits();
        }

        public int getXTagInt(int i, Units units) {
            int offset = this.ds.tableStart(this.table);
            return this.ds.getXTagInt(i + offset, units);
        }

        public Object getProperty(String name) {
            return null;
        }

        public Map getProperties() {
            return new HashMap();
        }
    }

    protected static class XSliceDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private int iIndex;
        private TableDataSet ds;

        protected XSliceDataSet(AbstractDataSet ds, int i) {
            this.ds = (TableDataSet)((Object)ds);
            this.iIndex = i;
        }

        public DataSet getPlanarView(String planeID) {
            return new XSliceDataSet((AbstractDataSet)this.ds.getPlanarView(planeID), this.iIndex);
        }

        public String[] getPlaneIds() {
            return this.ds.getPlaneIds();
        }

        public Datum getDatum(int i) {
            return this.ds.getDatum(this.iIndex, i);
        }

        public double getDouble(int i, Units units) {
            return this.ds.getDouble(this.iIndex, i, units);
        }

        public int getInt(int i, Units units) {
            return this.ds.getInt(this.iIndex, i, units);
        }

        public Datum getXTagDatum(int i) {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagDatum(table, i);
        }

        public int getXLength() {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYLength(table);
        }

        public Units getXUnits() {
            return this.ds.getYUnits();
        }

        public double getXTagDouble(int i, Units units) {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagDouble(table, i, units);
        }

        public Units getYUnits() {
            return this.ds.getZUnits();
        }

        public int getXTagInt(int i, Units units) {
            int table = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagInt(table, i, units);
        }

        public Object getProperty(String name) {
            return null;
        }

        public String toString() {
            return VectorUtil.toString(this);
        }

        public Map getProperties() {
            return new HashMap();
        }
    }
}

