/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.DataSet;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;

public class AveragePeakTableRebinner {
    private boolean debug = false;

    public DataSet rebin(DataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException {
        if (!(ds instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tds = (TableDataSet)ds;
        if (ddY == null && tds.tableCount() == 0) {
            throw new IllegalArgumentException("empty table and null RebinDescriptor for Y, so result YTags are undefined.");
        }
        TableDataSet weights = (TableDataSet)ds.getPlanarView("weights");
        TableDataSet peaks = (TableDataSet)ds.getPlanarView("peaks");
        long timer = System.currentTimeMillis();
        int nx = ddX == null ? tds.getXLength() : ddX.numberOfBins();
        int ny = ddY == null ? tds.getYLength(0) : ddY.numberOfBins();
        double[][] averageData = new double[nx][ny];
        double[][] averageWeights = new double[nx][ny];
        double[][] peakData = new double[nx][ny];
        throw new RuntimeException("need to update");
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

