/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.system.DasLogger;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class AverageTableRebinner
implements DataSetRebinner {
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
    private boolean interpolate = true;
    private boolean enlargePixels = true;
    protected Interpolate interpolateType = Interpolate.Linear;
    public static final String PROP_INTERPOLATETYPE = "interpolateType";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public QDataSet rebin(QDataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException, DasException {
        MutablePropertyDataSet yy;
        ArrayDataSet xx;
        int ny;
        logger.finest("enter AverageTableRebinner.rebin");
        if (ds == null) {
            throw new NullPointerException("null data set");
        }
        if (!SemanticOps.isTableDataSet((QDataSet)ds)) {
            throw new IllegalArgumentException("Data set must be an instanceof TableDataSet: " + ds.getClass().getName());
        }
        QDataSet tds = ds;
        int rank = tds.rank();
        if (rank == 2) {
            JoinDataSet tdsx = new JoinDataSet(3);
            tdsx.join(tds);
            tds = tdsx;
        }
        QDataSet weights = SemanticOps.weightsDataSet((QDataSet)ds);
        QDataSet tds1 = tds.slice(0);
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds1);
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds1);
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        Units yunits = SemanticOps.getUnits((QDataSet)yds);
        if (ddX != null && tds.length() > 0) {
            UnitsConverter xc = xunits.getConverter(ddX.getUnits());
            QDataSet bounds = SemanticOps.bounds((QDataSet)tds);
            double start = xc.convert(bounds.value(0, 0));
            double end = xc.convert(bounds.value(0, 1));
            if (start > ddX.binStop(ddX.numberOfBins() - 1).doubleValue(ddX.getUnits())) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (end < ddX.binStart(0).doubleValue(ddX.getUnits())) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        int nx = ddX == null ? tds1.length() : ddX.numberOfBins();
        int n = ny = ddY == null ? tds1.length(0) : ddY.numberOfBins();
        if (ddY == null && rank != 2) {
            throw new IllegalArgumentException("ddY was null but there was rank 3 dataset");
        }
        logger.log(Level.FINEST, "Allocating rebinData and rebinWeights: {0} x {1}", new Object[]{nx, ny});
        double[][] rebinData = new double[nx][ny];
        double[][] rebinWeights = new double[nx][ny];
        AverageTableRebinner.average(tds, weights, rebinData, rebinWeights, ddX, ddY);
        if (this.interpolate) {
            AverageTableRebinner.doBoundaries2RL(tds, weights, rebinData, rebinWeights, ddX, ddY, this.interpolateType);
            AverageTableRebinner.doBoundaries2TB(tds, weights, rebinData, rebinWeights, ddX, ddY, this.interpolateType);
            AverageTableRebinner.doCorners(tds, weights, rebinData, rebinWeights, ddX, ddY, this.interpolateType);
        }
        if (this.interpolate) {
            Datum yTagWidth;
            Datum xTagWidth = AverageTableRebinner.getXTagWidth(xds, tds1);
            QDataSet yds1 = yds.rank() == 1 ? yds : yds.slice(0);
            RankZeroDataSet yTagWidthQ = DataSetUtil.guessCadenceNew((QDataSet)yds1, null);
            Datum datum = yTagWidth = yTagWidthQ == null ? null : DataSetUtil.asDatum((RankZeroDataSet)yTagWidthQ);
            if (ddX != null) {
                AverageTableRebinner.fillInterpolateXNew(rebinData, rebinWeights, ddX, xTagWidth, this.interpolateType);
            }
            if (ddY != null) {
                AverageTableRebinner.fillInterpolateY(rebinData, rebinWeights, ddY, yTagWidth, this.interpolateType);
            }
        } else if (this.enlargePixels) {
            this.enlargePixels(rebinData, rebinWeights);
        }
        DDataSet result = DDataSet.createRank2((int)nx, (int)ny);
        DDataSet weightResult = DDataSet.createRank2((int)nx, (int)ny);
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                result.putValue(i, j, rebinData[i][j]);
                weightResult.putValue(i, j, rebinWeights[i][j]);
            }
        }
        if (ddX == null) {
            xx = ArrayDataSet.copy((QDataSet)xds);
        } else {
            xx = DDataSet.createRank1((int)ddX.numberOfBins());
            for (int i = 0; i < xx.length(); ++i) {
                xx.putValue(i, ddX.binCenter(i, xunits));
            }
            xx.putProperty("UNITS", (Object)xunits);
        }
        if (ddY != null) {
            DDataSet yyy = DDataSet.createRank1((int)ddY.numberOfBins());
            for (int i = 0; i < yyy.length(); ++i) {
                yyy.putValue(i, ddY.binCenter(i, yunits));
            }
            yyy.putProperty("UNITS", (Object)yunits);
            yy = yyy;
        } else {
            yy = DataSetOps.makePropertiesMutable((QDataSet)yds);
        }
        for (String s : DataSetUtil.dimensionProperties()) {
            if (ds.property(s) != null) {
                result.putProperty(s, ds.property(s));
            }
            if (xds.property(s) != null) {
                xx.putProperty(s, xds.property(s));
            }
            if (yds.property(s) == null) continue;
            yy.putProperty(s, yds.property(s));
        }
        if (ddX != null) {
            xx.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)ddX.binWidthDatum()));
        }
        if (ddY != null) {
            yy.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)ddY.binWidthDatum()));
        }
        result.putProperty("DEPEND_0", (Object)xx);
        result.putProperty("DEPEND_1", (Object)yy);
        result.putProperty("WEIGHTS", (Object)weightResult);
        logger.finest("done, AverageTableRebinner.rebin");
        return result;
    }

    private static Datum getXTagWidth(QDataSet xds, QDataSet tds1) {
        Datum xTagWidth;
        if (xds.length() > 1) {
            Datum d = SemanticOps.guessXTagWidth((QDataSet)xds, (QDataSet)tds1);
            if (d == null) {
                System.err.println("failed to guessXTagWidth");
                Units xunits = SemanticOps.getUnits((QDataSet)xds).getOffsetUnits();
                Datum xTagWidth2 = xunits.createDatum(Double.MAX_VALUE);
                return xTagWidth2;
            }
            xTagWidth = d;
        } else {
            RankZeroDataSet xTagWidthDs = (RankZeroDataSet)xds.property("CADENCE");
            if (xTagWidthDs != null) {
                xTagWidth = DataSetUtil.asDatum((QDataSet)xTagWidthDs);
            } else {
                Units xunits = SemanticOps.getUnits((QDataSet)xds).getOffsetUnits();
                xTagWidth = xunits.createDatum(Double.MAX_VALUE);
            }
        }
        return xTagWidth;
    }

    private static int getNextPrevIndex(QDataSet xds, Datum xx, int sign) {
        if (SemanticOps.isMonotonic((QDataSet)xds)) {
            if (sign < 0) {
                return DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)xx);
            }
            return DataSetUtil.getNextIndex((QDataSet)xds, (Datum)xx);
        }
        double best = Double.MAX_VALUE;
        int ibest = -1;
        double lookFor = xx.doubleValue(SemanticOps.getUnits((QDataSet)xds));
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)xds);
        for (int i = 0; i < xds.length(); ++i) {
            double check = (double)sign * (xds.value(i) - lookFor);
            if (!(wds.value(i) > 0.0) || !(check > 0.0) || !(check < best)) continue;
            ibest = i;
            best = check;
        }
        return ibest;
    }

    static void doBoundaries2RL(QDataSet tds, QDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY, Interpolate interpolateType) {
        if (tds.rank() != 3) {
            throw new IllegalArgumentException("rank 3 expected");
        }
        for (int itable = 0; itable < tds.length(); ++itable) {
            QDataSet tds1 = tds.slice(itable);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds1);
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds1);
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds1);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            Datum xTagWidth = AverageTableRebinner.getXTagWidth(xds, tds1);
            for (int i = 0; i < 2; ++i) {
                DatumRange dr;
                int ix = i == 0 ? 0 : ddX.numberOfBins() - 1;
                Datum xx = i == 0 ? ddX.binCenter(0) : ddX.binCenter(ix);
                int i0 = AverageTableRebinner.getNextPrevIndex(xds, xx, -1);
                int i1 = AverageTableRebinner.getNextPrevIndex(xds, xx, 1);
                if (i0 == -1 || i1 == -1) {
                    return;
                }
                if (i1 == i0 || !(dr = DatumRangeUtil.union((Datum)xunits.createDatum(xds.value(i0)), (Datum)xunits.createDatum(xds.value(i1)))).width().ge(xTagWidth)) continue;
                double alpha = DatumRangeUtil.normalize((DatumRange)dr, (Datum)xx);
                if (interpolateType == Interpolate.NearestNeighbor) {
                    alpha = alpha < 0.5 ? 0.0 : 1.0;
                }
                int ny = ddY == null ? yds.length() : ddY.numberOfBins();
                QDataSet yds1 = yds.rank() == 2 ? yds.slice(i0) : yds;
                for (int j = 0; j < yds1.length(); ++j) {
                    int jj;
                    int n = jj = ddY == null ? j : ddY.whichBin(yds1.value(j), yunits);
                    if (jj < 0 || jj >= ny || rebinWeights[ix][jj] > 0.0 || wds.value(i0, j) * wds.value(i1, j) == 0.0) continue;
                    rebinData[ix][jj] = (1.0 - alpha) * tds1.value(i0, j) + alpha * tds1.value(i1, j);
                    rebinWeights[ix][jj] = 1.0;
                }
            }
        }
    }

    static void doBoundaries2TB(QDataSet tds, QDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY, Interpolate interpolateType) {
        if (ddY == null) {
            return;
        }
        for (int itable = 0; itable < tds.length(); ++itable) {
            QDataSet tds1 = tds.slice(itable);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds1);
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds1);
            if (yds.rank() == 2) {
                int islice = yds.length() / 2;
                if (yds.length() > 0 && yds.length(islice) > 0 && yds.value(islice, 0) != yds.value(islice, 0)) {
                    System.err.println("kludge assumes rank2 yds is repeating values");
                }
                yds = yds.slice(islice);
            }
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds1);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            for (int i = 0; i < 2; ++i) {
                int j1;
                int j0;
                Datum yy;
                int iy = i == 0 ? 0 : ddY.numberOfBins() - 1;
                Datum datum = yy = i == 0 ? ddY.binCenter(0) : ddY.binCenter(iy);
                if (SemanticOps.isMonotonic((QDataSet)yds)) {
                    j0 = DataSetUtil.getPreviousIndex((QDataSet)yds, (Datum)yy);
                    j1 = DataSetUtil.getNextIndex((QDataSet)yds, (Datum)yy);
                } else {
                    QDataSet myds = Ops.multiply((QDataSet)yds, (QDataSet)DataSetUtil.asDataSet((double)-1.0));
                    if (SemanticOps.isMonotonic((QDataSet)myds)) {
                        j0 = DataSetUtil.getPreviousIndex((QDataSet)myds, (Datum)yy);
                        j1 = DataSetUtil.getNextIndex((QDataSet)myds, (Datum)yy);
                    } else {
                        if (Ops.total((QDataSet)SemanticOps.weightsDataSet((QDataSet)yds)) != 0.0) continue;
                        return;
                    }
                }
                if (j1 == j0) continue;
                DatumRange dr = DatumRangeUtil.union((Datum)yunits.createDatum(yds.value(j0)), (Datum)yunits.createDatum(yds.value(j1)));
                if (ddY.isLog()) {
                    Units u = dr.getUnits();
                    double d = dr.min().doubleValue(u);
                    double d0 = Math.log(dr.min().doubleValue(u) / d);
                    double d1 = Math.log(dr.max().doubleValue(u) / d);
                    dr = new DatumRange(d0, d1, Units.logERatio);
                    yy = Units.logERatio.createDatum(Math.log(yy.doubleValue(u) / d));
                }
                double alpha = DatumRangeUtil.normalize((DatumRange)dr, (Datum)yy);
                if (interpolateType == Interpolate.NearestNeighbor) {
                    alpha = alpha < 0.5 ? 0.0 : 1.0;
                }
                int nx = ddX.numberOfBins();
                for (int ix = 0; ix < tds1.length(); ++ix) {
                    int ii = ddX.whichBin(xds.value(ix), xunits);
                    if (ii < 0 || ii >= nx || rebinWeights[ii][iy] > 0.0 || wds.value(ix, j0) * wds.value(ix, j1) == 0.0) continue;
                    rebinData[ii][iy] = (1.0 - alpha) * tds1.value(ix, j0) + alpha * tds1.value(ix, j1);
                    rebinWeights[ii][iy] = 1.0;
                }
            }
        }
    }

    static void doCorners(QDataSet tds, QDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY, Interpolate interpolateType) {
        if (ddY == null) {
            return;
        }
        for (int itable = 0; itable < tds.length(); ++itable) {
            QDataSet tds1 = tds.slice(itable);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds1);
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds1);
            if (yds.rank() == 2) {
                yds = yds.slice(0);
            }
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds1);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Datum xTagWidth = AverageTableRebinner.getXTagWidth(xds, tds1);
            for (int i = 0; i < 2; ++i) {
                int ix = i == 0 ? 0 : ddX.numberOfBins() - 1;
                Datum xx = ddX.binCenter(ix);
                int i0 = AverageTableRebinner.getNextPrevIndex(xds, xx, -1);
                int i1 = AverageTableRebinner.getNextPrevIndex(xds, xx, 1);
                if (i0 == -1 || i1 == -1 || i0 == i1) continue;
                DatumRange xdr = DatumRangeUtil.union((Datum)xunits.createDatum(xds.value(i0)), (Datum)xunits.createDatum(xds.value(i1)));
                double xalpha = DatumRangeUtil.normalize((DatumRange)xdr, (Datum)xx);
                if (interpolateType == Interpolate.NearestNeighbor) {
                    xalpha = xalpha < 0.5 ? 0.0 : 1.0;
                }
                for (int j = 0; j < 2; ++j) {
                    int iy = j == 0 ? 0 : ddY.numberOfBins() - 1;
                    Datum yy = ddY.binCenter(iy);
                    int j0 = AverageTableRebinner.getNextPrevIndex(yds, yy, -1);
                    int j1 = AverageTableRebinner.getNextPrevIndex(yds, yy, 1);
                    if (j0 == -1 || j1 == -1 || j0 == j1) continue;
                    DatumRange ydr = DatumRangeUtil.union((Datum)yunits.createDatum(yds.value(j0)), (Datum)yunits.createDatum(yds.value(j1)));
                    if (!xdr.width().lt(xTagWidth)) continue;
                    double yalpha = DatumRangeUtil.normalize((DatumRange)ydr, (Datum)yy);
                    if (interpolateType == Interpolate.NearestNeighbor) {
                        double d = yalpha = yalpha < 0.5 ? 0.0 : 1.0;
                    }
                    if (rebinWeights[ix][iy] > 0.0 || wds.value(i1, j1) * wds.value(i0, j0) * wds.value(i1, j0) * wds.value(i0, j1) == 0.0) continue;
                    rebinData[ix][iy] = tds1.value(i1, j1) * xalpha * yalpha + tds1.value(i0, j0) * (1.0 - xalpha) * (1.0 - yalpha) + tds1.value(i1, j0) * xalpha * (1.0 - yalpha) + tds1.value(i0, j1) * (1.0 - xalpha) * yalpha;
                    rebinWeights[ix][iy] = 1.0;
                }
            }
        }
    }

    static void average(QDataSet tds, QDataSet weights, double[][] rebinData, double[][] rebinWeights, RebinDescriptor ddX, RebinDescriptor ddY) {
        if (tds.rank() != 3) {
            throw new IllegalArgumentException("rank 3 expected");
        }
        Units zunits = SemanticOps.getUnits((QDataSet)tds);
        int nx = ddX == null ? tds.length(0) : ddX.numberOfBins();
        int ny = ddY == null ? tds.length(0, 0) : ddY.numberOfBins();
        int nTables = tds.length();
        for (int iTable = 0; iTable < nTables; ++iTable) {
            QDataSet tds1 = tds.slice(iTable);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)tds1);
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)tds1);
            if (yds.length() == 1 && yds.rank() == 2 && tds1.length() > 1) {
                yds = yds.slice(0);
            }
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds1);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            int[] ibiny = new int[tds1.length(0)];
            if (yds.rank() == 1) {
                for (int j = 0; j < ibiny.length; ++j) {
                    ibiny[j] = ddY != null ? ddY.whichBin(yds.value(j), yunits) : j;
                }
            }
            for (int i = 0; i < tds1.length(); ++i) {
                int ibinx;
                if (yds.rank() == 2) {
                    for (int j = 0; j < ibiny.length; ++j) {
                        ibiny[j] = ddY != null ? ddY.whichBin(yds.value(i, j), yunits) : j;
                    }
                }
                if ((ibinx = ddX != null ? ddX.whichBin(xds.value(i), xunits) : i) < 0 || ibinx >= nx) continue;
                for (int j = 0; j < tds1.length(i); ++j) {
                    double w;
                    double z;
                    try {
                        z = tds1.value(i, j);
                        w = wds.value(i, j);
                        if (ibiny[j] >= 0 && ibiny[j] < ny) {
                            double[] dArray = rebinData[ibinx];
                            int n = ibiny[j];
                            dArray[n] = dArray[n] + z * w;
                            double[] dArray2 = rebinWeights[ibinx];
                            int n2 = ibiny[j];
                            dArray2[n2] = dArray2[n2] + w;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("here");
                    }
                    z = tds1.value(i, j);
                    w = wds.value(i, j);
                    if (ibiny[j] < 0 || ibiny[j] >= ny) continue;
                    double[] dArray = rebinData[ibinx];
                    int n = ibiny[j];
                    dArray[n] = dArray[n] + z * w;
                    double[] dArray3 = rebinWeights[ibinx];
                    int n3 = ibiny[j];
                    dArray3[n3] = dArray3[n3] + w;
                }
            }
        }
        AverageTableRebinner.multiplyWeights(rebinData, rebinWeights, zunits.getFillDouble());
    }

    private static void multiplyWeights(double[][] data, double[][] weights, double fill) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = weights[i][j] > 0.0 ? data[i][j] / weights[i][j] : fill;
            }
        }
    }

    static void fillInterpolateX(double[][] data, double[][] weights, double[] xTags, double[] xTagMin, double[] xTagMax, double xSampleWidth, Interpolate interpolateType) {
        int nx = xTags.length;
        int ny = data[0].length;
        int[] i1 = new int[nx];
        int[] i2 = new int[nx];
        for (int j = 0; j < ny; ++j) {
            double a2;
            int i;
            int ii1 = -1;
            int ii2 = -1;
            for (i = 0; i < nx; ++i) {
                if (weights[i][j] > 0.0 && ii1 == i - 1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 == -1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    if (interpolateType != Interpolate.NearestNeighbor) continue;
                    for (int jjj = 0; jjj < i; ++jjj) {
                        i2[jjj] = ii1;
                    }
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 < i - 1) {
                    if (ii1 <= -1) continue;
                    i1[i] = -1;
                    i2[i] = -1;
                    ii2 = i;
                    for (int ii = ii1 + 1; ii < i; ++ii) {
                        i1[ii] = ii1;
                        i2[ii] = ii2;
                    }
                    ii1 = i;
                    continue;
                }
                i1[i] = -1;
                i2[i] = -1;
            }
            if (interpolateType == Interpolate.NearestNeighbor && ii1 > -1) {
                for (int jjj = ii1; jjj < nx; ++jjj) {
                    i1[jjj] = ii1;
                }
            }
            if (interpolateType == Interpolate.NearestNeighbor) {
                for (i = 0; i < nx; ++i) {
                    if (i1[i] <= -1 || i2[i] <= -1 || !(xTagMin[i2[i]] - xTagMax[i1[i]] <= xSampleWidth * 1.5)) continue;
                    int idx = -1;
                    if (i1[i] == -1) {
                        if (i2[i] == -1) continue;
                        idx = i2[i];
                    } else {
                        idx = i2[i] == -1 ? i1[i] : ((a2 = (xTags[i] - xTagMax[i1[i]]) / (xTagMin[i2[i]] - xTags[i1[i]])) < 0.5 ? i1[i] : i2[i]);
                    }
                    data[i][j] = data[idx][j];
                    weights[i][j] = weights[idx][j];
                }
                continue;
            }
            for (i = 0; i < nx; ++i) {
                if (i1[i] <= -1 || i2[i] <= -1 || !(xTagMin[i2[i]] - xTagMax[i1[i]] <= xSampleWidth * 1.5)) continue;
                a2 = (xTags[i] - xTagMax[i1[i]]) / (xTagMin[i2[i]] - xTags[i1[i]]);
                double a1 = 1.0 - a2;
                data[i][j] = data[i1[i]][j] * a1 + data[i2[i]][j] * a2;
                weights[i][j] = weights[i1[i]][j] * a1 + weights[i2[i]][j] * a2;
            }
        }
    }

    static void fillInterpolateXNew(double[][] data, double[][] weights, RebinDescriptor ddX, Datum xTagWidth, Interpolate interpolateType) {
        double xSampleWidth;
        double d;
        int ny = data[0].length;
        int nx = ddX.numberOfBins();
        int[] i1 = new int[nx];
        int[] i2 = new int[nx];
        double[] xTagTemp = new double[ddX.numberOfBins()];
        double[] xTags = ddX.binCenters();
        Units xTagUnits = ddX.getUnits();
        boolean log = ddX.isLog();
        if (log) {
            for (int i = 0; i < nx; ++i) {
                xTagTemp[i] = Math.log(xTags[i]);
            }
        } else {
            System.arraycopy(xTags, 0, xTagTemp, 0, nx);
        }
        double fudge = 1.35;
        if (interpolateType == Interpolate.NearestNeighbor) {
            fudge = 1.0;
        }
        if (xTagWidth == null) {
            xSampleWidth = d = 4.4942328371557893E307;
        } else if (UnitsUtil.isRatiometric((Units)xTagWidth.getUnits())) {
            double p = xTagWidth.doubleValue(Units.logERatio);
            xSampleWidth = p * fudge;
        } else {
            d = xTagWidth.doubleValue(xTagUnits.getOffsetUnits());
            xSampleWidth = d * fudge;
        }
        for (int j = 0; j < ny; ++j) {
            double a2;
            int i;
            int ii1 = -1;
            int ii2 = -1;
            for (i = 0; i < nx; ++i) {
                int iii;
                if (weights[i][j] > 0.0 && ii1 == i - 1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 == -1) {
                    i1[i] = -1;
                    i2[i] = -1;
                    ii1 = i;
                    if (interpolateType != Interpolate.NearestNeighbor) continue;
                    for (iii = 0; iii < i; ++iii) {
                        i2[iii] = ii1;
                    }
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 < i - 1) {
                    if (ii1 <= -1) continue;
                    i1[i] = -1;
                    i2[i] = -1;
                    ii2 = i;
                    for (iii = i - 1; iii >= ii1; --iii) {
                        i1[iii] = ii1;
                        i2[iii] = ii2;
                    }
                    ii1 = i;
                    continue;
                }
                i1[i] = -1;
                i2[i] = -1;
            }
            if (interpolateType == Interpolate.NearestNeighbor && ii1 > -1) {
                for (int iii = ii1; iii < nx; ++iii) {
                    i1[iii] = ii1;
                }
            }
            if (interpolateType == Interpolate.NearestNeighbor) {
                for (i = 0; i < nx; ++i) {
                    boolean doInterp;
                    if (i1[i] != -1 && i2[i] != -1) {
                        doInterp = xTagTemp[i2[i]] - xTagTemp[i1[i]] < xSampleWidth * 2.0 || i2[i] - i1[i] == 2;
                    } else if (i1[i] == -1 && i2[i] == -1) {
                        doInterp = false;
                    } else if (ddX.isLog() && !UnitsUtil.isRatiometric((Units)xTagWidth.getUnits())) {
                        doInterp = false;
                    } else if (i1[i] == -1) {
                        doInterp = xTagTemp[i2[i]] - xTagTemp[i] < xSampleWidth / 2.0;
                    } else {
                        boolean bl = doInterp = xTagTemp[i] - xTagTemp[i1[i]] < xSampleWidth / 2.0;
                    }
                    if (!doInterp) continue;
                    int idx = i1[i] == -1 ? i2[i] : (i2[i] == -1 ? i1[i] : ((a2 = (xTagTemp[i] - xTagTemp[i1[i]]) / (xTagTemp[i2[i]] - xTagTemp[i1[i]])) < 0.5 ? i1[i] : i2[i]));
                    data[i][j] = data[idx][j];
                    weights[i][j] = weights[idx][j];
                }
                continue;
            }
            for (i = 0; i < nx; ++i) {
                if (i1[i] == -1 || !(xTagTemp[i2[i]] - xTagTemp[i1[i]] < xSampleWidth) && i2[i] - i1[i] != 2) continue;
                a2 = (xTagTemp[i] - xTagTemp[i1[i]]) / (xTagTemp[i2[i]] - xTagTemp[i1[i]]);
                double a1 = 1.0 - a2;
                data[i][j] = data[i1[i]][j] * a1 + data[i2[i]][j] * a2;
                weights[i][j] = weights[i1[i]][j] * a1 + weights[i2[i]][j] * a2;
            }
        }
    }

    static void fillInterpolateY(double[][] data, double[][] weights, RebinDescriptor ddY, Datum yTagWidth, Interpolate interpolateType) {
        double ySampleWidth;
        double d;
        int nx = data.length;
        int ny = ddY.numberOfBins();
        int[] i1 = new int[ny];
        int[] i2 = new int[ny];
        double[] yTagTemp = new double[ddY.numberOfBins()];
        double[] yTags = ddY.binCenters();
        Units yTagUnits = ddY.getUnits();
        boolean log = ddY.isLog();
        if (log) {
            for (int j = 0; j < ny; ++j) {
                yTagTemp[j] = Math.log(yTags[j]);
            }
        } else {
            System.arraycopy(yTags, 0, yTagTemp, 0, ny);
        }
        double fudge = 1.35;
        if (interpolateType == Interpolate.NearestNeighbor) {
            fudge = 0.9900000000000001;
        }
        if (yTagWidth == null) {
            ySampleWidth = d = 4.4942328371557893E307;
        } else if (UnitsUtil.isRatiometric((Units)yTagWidth.getUnits())) {
            double p = yTagWidth.doubleValue(Units.logERatio);
            ySampleWidth = p * fudge;
        } else {
            d = yTagWidth.doubleValue(yTagUnits.getOffsetUnits());
            ySampleWidth = d * fudge;
        }
        for (int i = 0; i < nx; ++i) {
            double a2;
            int j;
            int ii1 = -1;
            int ii2 = -1;
            for (j = 0; j < ny; ++j) {
                if (weights[i][j] > 0.0 && ii1 == j - 1) {
                    i1[j] = -1;
                    i2[j] = -1;
                    ii1 = j;
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 == -1) {
                    i1[j] = -1;
                    i2[j] = -1;
                    ii1 = j;
                    if (interpolateType != Interpolate.NearestNeighbor) continue;
                    for (int jjj = 0; jjj < j; ++jjj) {
                        i2[jjj] = ii1;
                    }
                    continue;
                }
                if (weights[i][j] > 0.0 && ii1 < j - 1) {
                    if (ii1 <= -1) continue;
                    i1[j] = -1;
                    i2[j] = -1;
                    ii2 = j;
                    for (int jj = j - 1; jj >= ii1; --jj) {
                        i1[jj] = ii1;
                        i2[jj] = ii2;
                    }
                    ii1 = j;
                    continue;
                }
                i1[j] = -1;
                i2[j] = -1;
            }
            if (interpolateType == Interpolate.NearestNeighbor && ii1 > -1) {
                for (int jjj = ii1; jjj < ny; ++jjj) {
                    i1[jjj] = ii1;
                }
            }
            if (interpolateType == Interpolate.NearestNeighbor) {
                for (j = 0; j < ny; ++j) {
                    boolean doInterp;
                    if (i1[j] != -1 && i2[j] != -1) {
                        doInterp = yTagTemp[i2[j]] - yTagTemp[i1[j]] < ySampleWidth * 2.0;
                    } else if (ddY.isLog() && !UnitsUtil.isRatiometric((Units)yTagUnits)) {
                        doInterp = false;
                    } else if (i1[j] == -1 && i2[j] == -1) {
                        doInterp = false;
                    } else if (i1[j] == -1) {
                        doInterp = yTagTemp[i2[j]] - yTagTemp[j] < ySampleWidth / 2.0;
                    } else {
                        boolean bl = doInterp = yTagTemp[j] - yTagTemp[i1[j]] < ySampleWidth / 2.0;
                    }
                    if (!doInterp) continue;
                    int idx = i1[j] == -1 ? i2[j] : (i2[j] == -1 ? i1[j] : ((a2 = (yTagTemp[j] - yTagTemp[i1[j]]) / (yTagTemp[i2[j]] - yTagTemp[i1[j]])) < 0.5 ? i1[j] : i2[j]));
                    data[i][j] = data[i][idx];
                    weights[i][j] = weights[i][idx];
                }
                continue;
            }
            for (j = 0; j < ny; ++j) {
                if (i1[j] == -1 || !(yTagTemp[i2[j]] - yTagTemp[i1[j]] < ySampleWidth) && i2[j] - i1[j] != 2) continue;
                a2 = (yTagTemp[j] - yTagTemp[i1[j]]) / (yTagTemp[i2[j]] - yTagTemp[i1[j]]);
                double a1 = 1.0 - a2;
                data[i][j] = data[i][i1[j]] * a1 + data[i][i2[j]] * a2;
                weights[i][j] = weights[i][i1[j]] * a1 + weights[i][i2[j]] * a2;
            }
        }
    }

    private void enlargePixels(double[][] rebinData, double[][] rebinWeights) {
        int enlargeSize = 5;
        for (int aa = 0; aa < enlargeSize; ++aa) {
            int ii;
            int jj;
            int jj2;
            int ii2;
            for (ii2 = 0; ii2 < rebinData.length - 1; ++ii2) {
                for (jj2 = 0; jj2 < rebinData[0].length; ++jj2) {
                    if (rebinWeights[ii2][jj2] != 0.0) continue;
                    rebinData[ii2][jj2] = rebinData[ii2 + 1][jj2];
                    rebinWeights[ii2][jj2] = rebinWeights[ii2 + 1][jj2];
                }
            }
            for (ii2 = rebinData.length - 1; ii2 > 0; --ii2) {
                for (jj2 = 0; jj2 < rebinData[0].length; ++jj2) {
                    if (rebinWeights[ii2][jj2] != 0.0) continue;
                    rebinData[ii2][jj2] = rebinData[ii2 - 1][jj2];
                    rebinWeights[ii2][jj2] = rebinWeights[ii2 - 1][jj2];
                }
            }
            for (jj = 0; jj < rebinData[0].length - 1; ++jj) {
                for (ii = 0; ii < rebinData.length; ++ii) {
                    if (rebinWeights[ii][jj] != 0.0) continue;
                    rebinData[ii][jj] = rebinData[ii][jj + 1];
                    rebinWeights[ii][jj] = rebinWeights[ii][jj + 1];
                }
            }
            for (jj = rebinData[0].length - 1; jj > 0; --jj) {
                for (ii = 0; ii < rebinData.length; ++ii) {
                    if (rebinWeights[ii][jj] != 0.0) continue;
                    rebinData[ii][jj] = rebinData[ii][jj - 1];
                    rebinWeights[ii][jj] = rebinWeights[ii][jj - 1];
                }
            }
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setEnlargePixels(boolean enlargePixels) {
        this.enlargePixels = enlargePixels;
    }

    public boolean isEnlargePixels() {
        return this.enlargePixels;
    }

    public Interpolate getInterpolateType() {
        return this.interpolateType;
    }

    public void setInterpolateType(Interpolate interpolateType) {
        Interpolate oldInterpolateType = this.interpolateType;
        this.interpolateType = interpolateType;
        this.propertyChangeSupport.firePropertyChange(PROP_INTERPOLATETYPE, (Object)oldInterpolateType, (Object)interpolateType);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpolate {
        None,
        Linear,
        NearestNeighbor;

    }
}

