/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.stream.DataTransferType;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamMultiYDescriptor;
import org.das2.stream.StreamProducer;
import org.das2.stream.StreamXDescriptor;
import org.das2.stream.StreamYScanDescriptor;

public class DataSetStreamProducer {
    private boolean asciiTransferTypes = true;
    private boolean compressed = false;
    private DataSet dataSet;

    public void writeStream(OutputStream out) {
        this.writeStream(Channels.newChannel(out));
    }

    public void writeStream(WritableByteChannel out) {
        if (this.dataSet instanceof VectorDataSet) {
            this.writeVectorDataSetStream(out);
        } else {
            this.writeTableDataSetStream(out);
        }
    }

    private void writeTableDataSetStream(WritableByteChannel out) {
        TableDataSet tds = (TableDataSet)this.dataSet;
        if (tds.getXLength() == 0) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        try {
            DataTransferType yTransferType;
            DataTransferType xTransferType;
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            Map properties = tds.getProperties();
            if (properties != null) {
                for (String key : properties.keySet()) {
                    sd.setProperty(key, properties.get(key));
                }
            }
            if (this.compressed) {
                sd.setCompression("deflate");
            }
            producer.streamDescriptor(sd);
            if (this.asciiTransferTypes) {
                xTransferType = UnitsUtil.isTimeLocation((Units)tds.getXUnits()) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii10");
                yTransferType = DataTransferType.getByName("ascii10");
            } else {
                xTransferType = DataTransferType.getByName("sun_real8");
                yTransferType = DataTransferType.getByName("sun_real4");
            }
            PacketDescriptor pd = new PacketDescriptor();
            StreamXDescriptor xDescriptor = new StreamXDescriptor();
            xDescriptor.setUnits(tds.getXUnits());
            xDescriptor.setDataTransferType(xTransferType);
            pd.setXDescriptor(xDescriptor);
            String[] planeIds = DataSetUtil.getAllPlaneIds(tds);
            DatumVector[] yValues = new DatumVector[planeIds.length];
            for (int j = 0; j < tds.tableCount(); ++j) {
                int i;
                for (i = 0; i < planeIds.length; ++i) {
                    TableDataSet plane = (TableDataSet)tds.getPlanarView(planeIds[i]);
                    StreamYScanDescriptor yDescriptor = new StreamYScanDescriptor();
                    yDescriptor.setName(planeIds[i]);
                    yDescriptor.setDataTransferType(yTransferType);
                    yDescriptor.setZUnits(plane.getZUnits());
                    yDescriptor.setYCoordinates(plane.getYTags(j));
                    pd.addYDescriptor(yDescriptor);
                }
                producer.packetDescriptor(pd);
                for (i = tds.tableStart(j); i < tds.tableEnd(j); ++i) {
                    Datum xTag = tds.getXTagDatum(i);
                    for (int k = 0; k < planeIds.length; ++k) {
                        yValues[k] = tds.getScan(k);
                    }
                    producer.packet(pd, xTag, yValues);
                }
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            throw new RuntimeException(se);
        }
    }

    private static DatumVector toDatumVector(Datum d) {
        double[] array = new double[]{d.doubleValue(d.getUnits())};
        return DatumVector.newDatumVector((double[])array, (Units)d.getUnits());
    }

    private void writeVectorDataSetStream(WritableByteChannel out) {
        VectorDataSet vds = (VectorDataSet)this.dataSet;
        if (vds.getXLength() == 0) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        try {
            int i;
            DataTransferType yTransferType;
            DataTransferType xTransferType;
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            Map properties = vds.getProperties();
            if (properties != null) {
                for (String key : properties.keySet()) {
                    sd.setProperty(key, properties.get(key));
                }
            }
            if (this.compressed) {
                sd.setCompression("deflate");
            }
            producer.streamDescriptor(sd);
            if (this.asciiTransferTypes) {
                xTransferType = UnitsUtil.isTimeLocation((Units)vds.getXUnits()) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii10");
                yTransferType = DataTransferType.getByName("ascii10");
            } else {
                xTransferType = DataTransferType.getByName("sun_real8");
                yTransferType = DataTransferType.getByName("sun_real4");
            }
            StreamXDescriptor xDescriptor = new StreamXDescriptor();
            xDescriptor.setUnits(vds.getXUnits());
            xDescriptor.setDataTransferType(xTransferType);
            PacketDescriptor pd = new PacketDescriptor();
            pd.setXDescriptor(xDescriptor);
            String[] planeIds = DataSetUtil.getAllPlaneIds(vds);
            DatumVector[] yValues = new DatumVector[planeIds.length];
            for (i = 0; i < planeIds.length; ++i) {
                StreamMultiYDescriptor yDescriptor = new StreamMultiYDescriptor();
                yDescriptor.setName(planeIds[i]);
                yDescriptor.setDataTransferType(yTransferType);
                yDescriptor.setUnits(((VectorDataSet)vds.getPlanarView(planeIds[i])).getYUnits());
                pd.addYDescriptor(yDescriptor);
            }
            producer.packetDescriptor(pd);
            for (i = 0; i < vds.getXLength(); ++i) {
                Datum xTag = vds.getXTagDatum(i);
                for (int j = 0; j < planeIds.length; ++j) {
                    yValues[j] = DataSetStreamProducer.toDatumVector(((VectorDataSet)vds.getPlanarView(planeIds[j])).getDatum(i));
                }
                producer.packet(pd, xTag, yValues);
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            throw new RuntimeException(se);
        }
    }

    public boolean isAsciiTransferTypes() {
        return this.asciiTransferTypes;
    }

    public void setAsciiTransferTypes(boolean asciiTransferTypes) {
        this.asciiTransferTypes = asciiTransferTypes;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }
}

