/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.XSliceDataSet;
import org.das2.dataset.YSliceDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class TagMapTableDataSet
implements TableDataSet {
    TableDataSet source;
    int[] imap;
    int[][] jmap;
    int[] itableMap;
    int tableCount;
    int[] tableStart;
    int[] tableEnd;

    TagMapTableDataSet(TableDataSet source, int[] imap, int[][] jmap, int[] itableMap) {
        int i;
        this.imap = imap;
        this.jmap = jmap;
        this.itableMap = itableMap;
        int itable = itableMap[0];
        ArrayList<Integer> tableStartList = new ArrayList<Integer>();
        ArrayList<Integer> tableEndList = new ArrayList<Integer>();
        tableStartList.add(new Integer(0));
        for (i = 1; i < itableMap.length; ++i) {
            if (itableMap[i] <= itable) continue;
            tableStartList.add(new Integer(i));
            tableEndList.add(new Integer(i));
        }
        tableEndList.add(new Integer(itableMap.length));
        this.tableCount = tableEndList.size();
        this.tableStart = new int[this.tableCount];
        this.tableEnd = new int[this.tableCount];
        for (i = 0; i < this.tableCount; ++i) {
            this.tableStart[i] = (Integer)tableStartList.get(i);
            this.tableEnd[i] = (Integer)tableEndList.get(i);
        }
    }

    public Datum getDatum(int i, int j) {
        if (this.imap[i] != -1 && this.jmap[this.itableMap[i]][j] != -1) {
            return this.source.getDatum(this.imap[i], this.jmap[this.itableMap[i]][j]);
        }
        return this.source.getZUnits().createDatum(this.source.getZUnits().getFillDouble());
    }

    public double getDouble(int i, int j, Units units) {
        try {
            if (this.imap[i] != -1 && this.jmap[this.itableMap[i]][j] != -1) {
                return this.source.getDouble(this.imap[i], this.jmap[this.itableMap[i]][j], units);
            }
            return this.source.getZUnits().getFillDouble();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("here: " + e);
            throw new RuntimeException(e);
        }
    }

    public int getInt(int i, int j, Units units) {
        if (this.imap[i] != -1 && this.jmap[this.itableMap[i]][j] != -1) {
            return this.source.getInt(this.imap[i], this.jmap[this.itableMap[i]][j], units);
        }
        return this.source.getZUnits().getFillInt();
    }

    public DataSet getPlanarView(String planeID) {
        TableDataSet ds = (TableDataSet)this.source.getPlanarView(planeID);
        if (ds != null) {
            return new TagMapTableDataSet(ds, this.imap, this.jmap, this.itableMap);
        }
        return null;
    }

    public String[] getPlaneIds() {
        return this.source.getPlaneIds();
    }

    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    public Map getProperties() {
        return this.source.getProperties();
    }

    public int getXLength() {
        return this.imap.length;
    }

    public VectorDataSet getXSlice(int i) {
        return new XSliceDataSet(this, i);
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new YSliceDataSet(this, j, table);
    }

    public Datum getXTagDatum(int i) {
        return this.source.getXTagDatum(this.imap[i]);
    }

    public double getXTagDouble(int i, Units units) {
        return this.source.getXTagDouble(this.imap[i], units);
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.getXTagDouble(i, units);
    }

    public Units getXUnits() {
        return this.source.getXUnits();
    }

    public int getYLength(int table) {
        return this.jmap[table].length;
    }

    public Datum getYTagDatum(int table, int j) {
        return this.source.getYTagDatum(table, this.jmap[table][j]);
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.source.getYTagDouble(table, this.jmap[table][j], units);
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    public Units getYUnits() {
        return this.source.getYUnits();
    }

    public Units getZUnits() {
        return this.source.getZUnits();
    }

    public int tableCount() {
        return this.tableCount;
    }

    public int tableEnd(int table) {
        return this.tableEnd[table];
    }

    public int tableOfIndex(int i) {
        return 0;
    }

    public int tableStart(int table) {
        return this.tableStart[table];
    }

    public String toString() {
        return "TagMapTableDataSet " + TableUtil.toString(this);
    }

    public double[] getDoubleScan(int i, Units units) {
        int yLength = this.getYLength(this.tableOfIndex(i));
        double[] array = new double[yLength];
        for (int j = 0; j < yLength; ++j) {
            array[j] = this.getDouble(i, j, units);
        }
        return array;
    }

    public DatumVector getScan(int i) {
        Units zUnits = this.getZUnits();
        return DatumVector.newDatumVector((double[])this.getDoubleScan(i, zUnits), (Units)zUnits);
    }

    public DatumVector getYTags(int table) {
        double[] tags = new double[this.getYLength(table)];
        Units yUnits = this.getYUnits();
        for (int j = 0; j < tags.length; ++j) {
            tags[j] = this.getYTagDouble(table, j, yUnits);
        }
        return DatumVector.newDatumVector((double[])tags, (Units)yUnits);
    }

    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }
}

