/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.event.BoxRangeSelectorMouseModule;
import org.das2.event.BoxZoomGesturesRenderer;
import org.das2.event.Gesture;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.GraphUtil;

public class BoxZoomMouseModule
extends BoxRangeSelectorMouseModule {
    DatumRange xrange;
    DatumRange yrange;
    JLabel xrangeLabel;
    JLabel yrangeLabel;
    JCheckBox autoUpdateCB;
    JCheckBox constrainProportionsCB;
    boolean autoUpdate = true;
    boolean constrainProportions = false;

    public BoxZoomMouseModule(DasCanvasComponent parent, DataSetConsumer consumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, consumer, xAxis, yAxis);
        this.setDragRenderer(new BoxZoomGesturesRenderer(parent));
        this.setLabel("Box Zoom");
    }

    protected void zoomBox() {
        if (this.yrange != null) {
            this.yAxis.setDatumRange(this.yrange);
        }
        if (this.xrange != null) {
            this.xAxis.setDatumRange(this.xrange);
        }
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (e0 instanceof MouseBoxEvent) {
            boolean edgeX;
            MouseBoxEvent e = (MouseBoxEvent)e0;
            this.xrange = GraphUtil.invTransformRange(this.xAxis, e.getXMinimum(), e.getXMaximum());
            this.yrange = GraphUtil.invTransformRange(this.yAxis, e.getYMinimum(), e.getYMaximum());
            double boxAspect = (float)(e.getYMaximum() - e.getYMinimum()) / (float)(e.getXMaximum() - e.getXMinimum());
            boolean edgeY = e.getYMaximum() > this.yAxis.getRow().getDMaximum() || e.getYMinimum() < this.yAxis.getRow().getDMinimum();
            boolean bl = edgeX = e.getXMaximum() > this.xAxis.getColumn().getDMaximum() || e.getXMinimum() < this.xAxis.getColumn().getDMinimum();
            if (e.getYMaximum() - e.getYMinimum() < 5 || boxAspect < 0.1 && edgeY) {
                this.yrange = this.yAxis.getDatumRange();
            }
            if (e.getXMaximum() - e.getXMinimum() < 5 || boxAspect > 10.0 && edgeX) {
                this.xrange = this.xAxis.getDatumRange();
            }
            if (edgeY && boxAspect < 0.2) {
                this.yrange = this.yAxis.getDatumRange();
            }
            if (edgeX && boxAspect > 5.0) {
                this.xrange = this.xAxis.getDatumRange();
            }
            if (this.constrainProportions) {
                double aspect = (double)this.yAxis.getHeight() / (double)this.xAxis.getWidth();
                DatumRange mx = new DatumRange((double)e.getXMinimum(), (double)e.getXMaximum(), Units.dimensionless);
                DatumRange my = new DatumRange((double)e.getYMinimum(), (double)e.getYMaximum(), Units.dimensionless);
                double mouseAspect = my.width().divide(mx.width()).doubleValue(Units.dimensionless);
                if (mouseAspect > aspect) {
                    double f = mouseAspect / aspect;
                    mx = DatumRangeUtil.rescale((DatumRange)my, (double)(0.5 - f / 2.0), (double)(0.5 + f / 2.0));
                } else {
                    double f = aspect / mouseAspect;
                    my = DatumRangeUtil.rescale((DatumRange)my, (double)(0.5 - f / 2.0), (double)(0.5 + f / 2.0));
                }
                this.xrange = GraphUtil.invTransformRange(this.xAxis, mx.min().doubleValue(Units.dimensionless), mx.max().doubleValue(Units.dimensionless));
                this.yrange = GraphUtil.invTransformRange(this.yAxis, my.max().doubleValue(Units.dimensionless), my.min().doubleValue(Units.dimensionless));
            }
            this.zoomBox();
        } else if (e0.isGesture()) {
            if (e0.getGesture() == Gesture.ZOOMOUT) {
                this.xAxis.setDataRangeZoomOut();
                this.yAxis.setDataRangeZoomOut();
            } else if (e0.getGesture() == Gesture.BACK) {
                this.xAxis.setDataRangePrev();
                this.yAxis.setDataRangePrev();
            } else if (e0.getGesture() == Gesture.FORWARD) {
                this.xAxis.setDataRangeForward();
                this.yAxis.setDataRangeForward();
            }
        }
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isConstrainProportions() {
        return this.constrainProportions;
    }

    public void setConstrainProportions(boolean constrainProportions) {
        this.constrainProportions = constrainProportions;
    }
}

