/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.event.MouseEvent;
import javax.swing.event.EventListenerList;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalSliceSelectionRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;

public class ColorBarRepaletteMouseModule
extends MouseModule {
    DasColorBar colorBar;
    Renderer parent;
    DatumRange range0;
    boolean animated0;
    private EventListenerList listenerList = null;

    public String getLabel() {
        return "Repalette";
    }

    public ColorBarRepaletteMouseModule(Renderer parent, DasColorBar colorBar) {
        if (colorBar.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not vertical");
        }
        this.parent = parent;
        this.dragRenderer = new HorizontalSliceSelectionRenderer(parent.getParent());
        this.colorBar = colorBar;
    }

    private void setColorBar(int y) {
        DasRow row = this.colorBar.getRow();
        double alpha = (double)(row.getDMaximum() - y) / (1.0 * (double)row.getHeight());
        DatumRange dr = DatumRangeUtil.rescale((DatumRange)this.range0, (double)0.0, (double)alpha);
        this.colorBar.setDatumRange(dr);
        this.parent.update();
    }

    public void mouseReleased(MouseEvent e) {
        this.colorBar.setAnimated(this.animated0);
    }

    public void mousePointSelected(MousePointSelectionEvent e) {
        this.setColorBar(e.y);
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataRangeSelectionListener.class, listener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(DataRangeSelectionListener.class, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.animated0 = this.colorBar.isAnimated();
        this.colorBar.setAnimated(false);
        this.range0 = this.colorBar.getDatumRange();
    }
}

