/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsutil.QDataSetTableModel;

public class DisplayDataMouseModule
extends MouseModule {
    private static final String LABEL = "Display Data";
    private DasPlot plot;
    private JFrame myFrame;
    private JPanel myPanel;
    private JTable myEdit;
    private JComboBox comboBox;
    private Renderer[] rends;
    private DatumRange xrange;
    private DatumRange yrange;
    private ItemListener itemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            if (DisplayDataMouseModule.this.rends == null) {
                return;
            }
            int i = DisplayDataMouseModule.this.comboBox.getSelectedIndex();
            if (i < DisplayDataMouseModule.this.rends.length) {
                DisplayDataMouseModule.this.setDataSet(DisplayDataMouseModule.this.rends[i].getDataSet(), DisplayDataMouseModule.this.xrange, DisplayDataMouseModule.this.yrange);
            }
        }
    };
    private boolean yclip = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DisplayDataMouseModule(DasPlot parent) {
        super(parent, new BoxRenderer(parent), LABEL);
        this.plot = parent;
    }

    private void maybeCreateFrame(Object source) {
        if (this.myFrame == null) {
            Window w;
            this.myFrame = new JFrame(LABEL);
            if (source != null && source instanceof JComponent && (w = SwingUtilities.getWindowAncestor((JComponent)source)) instanceof JFrame) {
                this.myFrame.setIconImage(((JFrame)w).getIconImage());
            }
            this.myPanel = new JPanel();
            this.myPanel.setPreferredSize(new Dimension(300, 300));
            this.myPanel.setLayout(new BorderLayout());
            this.myEdit = new JTable();
            this.myEdit.setFont(Font.decode("fixed-10"));
            this.myEdit.setAutoResizeMode(0);
            this.myEdit.getTableHeader().setReorderingAllowed(false);
            JScrollPane scrollPane = new JScrollPane(this.myEdit, 20, 30);
            this.myPanel.add((Component)scrollPane, "Center");
            this.comboBox = new JComboBox();
            this.comboBox.addItemListener(this.itemListener);
            this.myPanel.add((Component)this.comboBox, "North");
            this.myFrame.getContentPane().add(this.myPanel);
            this.myFrame.pack();
        }
    }

    private String unitsStr(Units u) {
        return u == Units.dimensionless ? "" : "(" + u.toString() + ")";
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        MouseBoxEvent e = (MouseBoxEvent)e0;
        if (Point.distance(e.getXMaximum(), e.getYMinimum(), e.getXMaximum(), e.getYMaximum()) < 5.0) {
            return;
        }
        this.maybeCreateFrame(e0.getSource());
        DatumRange xrng = this.plot.getXAxis().isFlipped() ? new DatumRange(this.plot.getXAxis().invTransform(e.getXMaximum()), this.plot.getXAxis().invTransform(e.getXMinimum())) : new DatumRange(this.plot.getXAxis().invTransform(e.getXMinimum()), this.plot.getXAxis().invTransform(e.getXMaximum()));
        DatumRange yrng = this.yclip ? (this.plot.getYAxis().isFlipped() ? new DatumRange(this.plot.getYAxis().invTransform(e.getYMinimum()), this.plot.getYAxis().invTransform(e.getYMaximum())) : new DatumRange(this.plot.getYAxis().invTransform(e.getYMaximum()), this.plot.getYAxis().invTransform(e.getYMinimum()))) : null;
        Renderer[] rends = this.plot.getRenderers();
        if (rends.length == 0) {
            return;
        }
        this.myFrame.setVisible(true);
        String[] rlabels = new String[rends.length];
        int firstActive = -1;
        for (int i = 0; i < rends.length; ++i) {
            String label = rends[i].getLegendLabel();
            if (label == null || label.equals("")) {
                label = "Renderer " + i;
            }
            if (!rends[i].isActive()) {
                label = label + " (not visible)";
            } else if (firstActive == -1) {
                firstActive = i;
            }
            rlabels[i] = label;
        }
        if (firstActive == -1) {
            firstActive = 0;
        }
        this.rends = rends;
        this.xrange = xrng;
        this.yrange = yrng;
        this.comboBox.setModel(new DefaultComboBoxModel<String>(rlabels));
        this.comboBox.setSelectedIndex(firstActive);
        this.setDataSet(rends[firstActive].getDataSet(), this.xrange, this.yrange);
    }

    private void showMessageInTable(JTable t, final String message) {
        DefaultTableModel result = new DefaultTableModel(1, 1){

            public Object getValueAt(int row, int col) {
                return message;
            }
        };
        t.setModel(result);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn c = new TableColumn(0);
        c.setHeaderValue("");
        c.setPreferredWidth(250);
        tcm.addColumn(c);
        t.setColumnModel(tcm);
    }

    private void setDataSet(QDataSet ds, DatumRange xrange, DatumRange yrange) {
        QDataSetTableModel tm;
        if (ds == null) {
            this.showMessageInTable(this.myEdit, "no dataset");
            return;
        }
        if (ds.rank() > 2) {
            QDataSet ds2 = SemanticOps.getSimpleTableContaining((QDataSet)ds, (Datum)xrange.min(), (Datum)yrange.min());
            if (ds2 == null) {
                this.showMessageInTable(this.myEdit, "data cannot be displayed");
                return;
            }
            ds = ds2;
        }
        TableColumnModel tcm = new DefaultTableColumnModel();
        try {
            QDataSet tds = SemanticOps.trim((QDataSet)ds, (DatumRange)xrange, (DatumRange)yrange);
            tm = new QDataSetTableModel(tds);
            tcm = tm.getTableColumnModel();
        }
        catch (RuntimeException ex) {
            System.err.println("exception in mouseRangeSelected: " + ex);
            ex.printStackTrace();
            tm = new QDataSetTableModel(ds);
            tcm = tm.getTableColumnModel();
        }
        this.myEdit.setModel((TableModel)tm);
        this.myEdit.setColumnModel(tcm);
    }

    public String getListLabel() {
        return this.getLabel();
    }

    public Icon getListIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/icons/showDataMouseModule.png"));
        return icon;
    }

    public String getLabel() {
        return LABEL;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isYclip() {
        return this.yclip;
    }

    public void setYclip(boolean yclip) {
        boolean oldYclip = this.yclip;
        this.yclip = yclip;
        this.propertyChangeSupport.firePropertyChange("yclip", new Boolean(oldYclip), new Boolean(yclip));
    }
}

