/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import org.das2.datum.Units;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;

public class HorizontalRangeTorsionMouseModule
extends MouseModule {
    DasAxis axis;
    double min;
    double max;
    Units units;
    int x0;
    int y0;
    long tt;
    double inOutVelocity;
    double inOutPosition;
    double nextPrevVelocity;
    double nextPrevPosition;
    static final double inOutFactor = 1.0E-6;
    static final double nextPrevFactor = 100000.0;
    boolean mouseButtonPressed;

    public HorizontalRangeTorsionMouseModule(DasAxis axis) {
        this.axis = axis;
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.units = this.axis.getUnits();
        this.min = this.axis.getDataMinimum(this.units);
        this.max = this.axis.getDataMaximum(this.units);
        this.x0 = e.getX();
        this.y0 = e.getY();
        this.tt = System.currentTimeMillis();
        this.inOutPosition = 0.0;
        this.nextPrevPosition = 0.0;
        this.mouseButtonPressed = true;
    }

    void timerTask() {
        if (this.mouseButtonPressed) {
            long dt = System.currentTimeMillis() - this.tt;
            this.inOutPosition += this.inOutVelocity * (double)dt;
            this.nextPrevPosition += this.nextPrevVelocity * (double)dt;
            this.tt += dt;
            this.reportPosition();
            this.startTimer();
        }
    }

    public void startTimer() {
        int delay = 100;
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HorizontalRangeTorsionMouseModule.this.timerTask();
            }
        };
        new Timer(delay, taskPerformer).start();
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        int dx = e.getX() - this.x0;
        int dy = e.getY() - this.y0;
        long dt = System.currentTimeMillis() - this.tt;
        this.inOutVelocity = (double)dy * 1.0E-6;
        this.nextPrevVelocity = (double)dx * 100000.0;
        this.timerTask();
    }

    private void reportPosition() {
        double dd = this.max - this.min;
        double offset = this.nextPrevPosition;
        double scale = 1.0 + this.inOutPosition;
        double newMin = this.min + offset;
        double newMax = this.min + offset + dd * scale;
        this.axis.setDataRange(this.units.createDatum(newMin), this.units.createDatum(newMax));
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.mouseButtonPressed = false;
    }
}

