/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;

public class LengthDragRenderer
extends LabelDragRenderer {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DasPlot plot;
    NumberFormat nf;
    private boolean showSlope = false;
    protected boolean showFit = false;

    public LengthDragRenderer(DasCanvasComponent parent, DasAxis xaxis, DasAxis yaxis) {
        super(parent);
        this.plot = (DasPlot)parent;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
    }

    private String datumString(Datum d) {
        String result = d.toString();
        return result;
    }

    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        DasAxis ya;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double atan = Math.atan2(p2.y - p1.y, p2.x - p1.x);
        Line2D.Double line = new Line2D.Double(p1.x + (int)(4.0 * Math.cos(atan)), (int)((double)p1.y + 4.0 * Math.sin(atan)), p2.x, p2.y);
        g.draw(line);
        g.draw(new Ellipse2D.Double(p1.x - 4, p1.y - 4, 8.0, 8.0));
        Rectangle myDirtyBounds = new Rectangle();
        myDirtyBounds.setRect(p1.x - 3, p1.y - 3, 7.0, 7.0);
        myDirtyBounds.add(p2.x - 2, p2.y - 2);
        myDirtyBounds.add(p2.x + 2, p2.y + 2);
        DasAxis xa = this.xaxis == null ? this.plot.getXAxis() : this.xaxis;
        DasAxis dasAxis = ya = this.yaxis == null ? this.plot.getYAxis() : this.yaxis;
        if (!p1.equals(p2)) {
            String radString;
            Datum x1 = xa.invTransform(p2.x);
            Datum x0 = xa.invTransform(p1.x);
            Datum run = x1.subtract(x0);
            run = DatumUtil.asOrderOneUnits((Datum)run);
            String runString = x1.getUnits() == run.getUnits() ? x1.getFormatter().format(run) : this.datumString(run);
            Datum y1 = ya.invTransform(p2.y);
            Datum y0 = ya.invTransform(p1.y);
            Datum rise = y1.subtract(y0);
            String riseString = this.datumString(rise);
            if (rise.getUnits().isConvertableTo(run.getUnits())) {
                Units u = run.getUnits();
                double rised = rise.doubleValue(u);
                double rund = run.doubleValue(u);
                double rad = Math.sqrt(rised * rised + rund * rund);
                double srised = rise.getResolution(u);
                double srund = run.getResolution(u);
                double res = rad * Math.sqrt(Math.pow(srised / Math.max(Math.abs(rised), srised), 2.0) + Math.pow(srund / Math.max(Math.abs(rund), srund), 2.0));
                Datum radDatum = Datum.create((double)rad, (Units)u, (double)(res / 100.0));
                radString = "!cR:" + radDatum;
            } else {
                radString = "";
            }
            String label = "\u0394x: " + runString + " \u0394y: " + riseString + radString;
            if (this.showSlope) {
                label = label + "!c m: " + UnitsUtil.divideToString((Datum)rise, (Datum)run);
            }
            if (this.showFit) {
                String fit;
                Datum slope = rise.divide(run);
                if (this.yaxis.isLog() && this.xaxis.isLog()) {
                    double ycycles = Math.log10(y1.divide(y0).doubleValue(Units.dimensionless));
                    double xcycles = Math.log10(x1.divide(x0).doubleValue(Units.dimensionless));
                    DecimalFormat nf = new DecimalFormat("0.00");
                    String sslope = nf.format(ycycles / xcycles);
                    fit = "y= ( x/" + x1 + " )!A" + sslope + "!n * " + y1;
                } else if (this.yaxis.isLog() && !this.xaxis.isLog()) {
                    DecimalFormat nf = new DecimalFormat("0.00");
                    Units u = run.getUnits();
                    double drise = Math.log10(y1.divide(y0).doubleValue(Units.dimensionless));
                    double drun = x1.subtract(x0).doubleValue(u);
                    String sslope = nf.format(drise / drun);
                    String su = u.isConvertableTo(Units.seconds) ? UnitsUtil.divideToString((Datum)Units.dimensionless.createDatum(drise), (Datum)run) : (u == Units.dimensionless ? sslope : sslope + "/(" + u + ")");
                    fit = "!Cy=10!A( x-(" + x1 + ") )*" + su + "!n * " + y1;
                } else {
                    fit = !this.yaxis.isLog() && this.xaxis.isLog() ? "n/a" : "y=" + slope + " * ( x - (" + x1 + ") ) + " + y1;
                }
                label = label + "!c" + fit;
            }
            this.setLabel(label);
        } else {
            this.setLabel("");
        }
        super.renderDrag(g, p1, p2);
        return new Rectangle[]{this.dirtyBounds, myDirtyBounds};
    }

    public boolean isShowSlope() {
        return this.showSlope;
    }

    public void setShowSlope(boolean showSlope) {
        this.showSlope = showSlope;
    }

    public boolean isShowFit() {
        return this.showFit;
    }

    public void setShowFit(boolean showFit) {
        this.showFit = showFit;
    }
}

