/*
 * Decompiled with CFR 0.152.
 */
package org.das2.fsm;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.dataset.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.system.DasLogger;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorageModelNew {
    private Pattern pattern;
    private String regex;
    private Pattern gzpattern;
    FileStorageModelNew parent;
    FileSystem root;
    TimeParser timeParser;
    String template;
    static Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    HashMap fileNameMap = null;
    private boolean allowGz = true;
    VersioningType versioningType;
    protected boolean startTimeOnly = false;
    protected Datum implicitTimeDelta = null;

    private int toTimeUtilEnum(int i) {
        if (i < 100 || i > 300) {
            throw new IllegalArgumentException("enumeration is not of the correct type");
        }
        if ((i %= 100) == 0) {
            i = 1;
        }
        return i;
    }

    public FileSystem getFileSystem() {
        return this.root;
    }

    public String getRepresentativeFile(ProgressMonitor monitor) throws IOException {
        String ff;
        int last;
        String[] files1;
        int i;
        String listRegex;
        FileSystem[] fileSystems;
        String[] names;
        if (this.parent != null) {
            names = this.parent.getNamesFor(null);
            fileSystems = new FileSystem[names.length];
            for (int i2 = 0; i2 < names.length; ++i2) {
                try {
                    fileSystems[i2] = this.root.createFileSystem(names[i2]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String parentRegex = FileStorageModelNew.getParentRegex(this.regex);
            listRegex = this.regex.substring(parentRegex.length() + 1);
        } else {
            fileSystems = new FileSystem[]{this.root};
            names = new String[]{""};
            listRegex = this.regex;
        }
        String result = null;
        for (i = fileSystems.length - 1; result == null && i >= 0; --i) {
            files1 = fileSystems[i].listDirectory("/", listRegex);
            if (files1.length <= 0) continue;
            last = files1.length - 1;
            String string = ff = names[i].equals("") ? files1[last] : names[i] + "/" + files1[last];
            if (ff.endsWith("/")) {
                ff = ff.substring(0, ff.length() - 1);
            }
            result = ff;
        }
        if (this.allowGz && result == null) {
            for (i = fileSystems.length - 1; result == null && i >= 0; --i) {
                files1 = fileSystems[i].listDirectory("/", listRegex + ".gz");
                if (files1.length <= 0) continue;
                last = files1.length - 1;
                String string = ff = names[i].equals("") ? files1[last] : names[i] + "/" + files1[last];
                if (ff.endsWith("/")) {
                    ff = ff.substring(0, ff.length() - 1);
                }
                result = ff.substring(0, ff.length() - 3);
            }
        }
        return result;
    }

    private synchronized DatumRange getDatumRangeFor(String filename, Map<String, String> extra) {
        try {
            if (this.pattern.matcher(filename).matches()) {
                this.timeParser.parse(filename, extra);
                return this.timeParser.getTimeRange();
            }
            if (this.gzpattern != null && this.gzpattern.matcher(filename).matches()) {
                this.timeParser.parse(filename.substring(0, filename.length() - 3), extra);
                return this.timeParser.getTimeRange();
            }
            throw new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + ")");
        }
        catch (ParseException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + "), parse error in field", e);
            throw e2;
        }
        catch (NumberFormatException e) {
            IllegalArgumentException e2 = new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + "), parse error in field", e);
            throw e2;
        }
    }

    public String getFilenameFor(Datum start, Datum end) {
        return this.timeParser.format(start, end);
    }

    public String[] getNamesFor(DatumRange targetRange) throws IOException {
        return this.getNamesFor(targetRange, false, (ProgressMonitor)new NullProgressMonitor());
    }

    public String[] getNamesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        return this.getNamesFor(targetRange, false, monitor);
    }

    public String[] getBestNamesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        return this.getNamesFor(targetRange, true, monitor);
    }

    private String[] getNamesFor(DatumRange targetRange, boolean versioning, ProgressMonitor monitor) throws IOException {
        String ff;
        int j;
        String listRegex;
        FileSystem[] fileSystems;
        String[] names;
        if (this.parent != null) {
            names = this.parent.getNamesFor(targetRange, versioning, (ProgressMonitor)new NullProgressMonitor());
            fileSystems = new FileSystem[names.length];
            for (int i = 0; i < names.length; ++i) {
                try {
                    URI url = this.root.getRootURI().resolve(names[i]);
                    fileSystems[i] = FileSystem.create((URI)url);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String parentRegex = FileStorageModelNew.getParentRegex(this.regex);
            listRegex = this.regex.substring(parentRegex.length() + 1);
        } else {
            fileSystems = new FileSystem[]{this.root};
            names = new String[]{""};
            listRegex = this.regex;
        }
        List<Object> list = new ArrayList();
        ArrayList versionList = new ArrayList();
        ArrayList<DatumRange> rangeList = new ArrayList<DatumRange>();
        monitor.setTaskSize((long)(fileSystems.length * 10));
        monitor.started();
        HashMap<String, String> extra = new HashMap<String, String>();
        for (int i = 0; i < fileSystems.length; ++i) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException("cancel pressed");
            }
            monitor.setTaskProgress((long)(i * 10));
            String theListRegex = listRegex;
            if (this.allowGz) {
                theListRegex = theListRegex + "(.gz)?";
            }
            String[] files1 = fileSystems[i].listDirectory("/", theListRegex);
            for (j = 0; j < files1.length; ++j) {
                String string = ff = names[i].equals("") ? files1[j] : names[i] + "/" + files1[j];
                if (ff.endsWith("/")) {
                    ff = ff.substring(0, ff.length() - 1);
                }
                try {
                    DatumRange dr = this.getDatumRangeFor(ff, extra);
                    if (targetRange == null || dr.intersects(targetRange)) {
                        if (ff.endsWith(".gz") && this.allowGz) {
                            ff = ff.substring(0, ff.length() - 3);
                        }
                        list.add(ff);
                        rangeList.add(dr);
                        if (this.versioningType != VersioningType.none) {
                            if (extra.get("v") == null) {
                                throw new RuntimeException("expected version");
                            }
                            versionList.add(extra.get("v"));
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!e.getMessage().contains("invalid time before year 0001")) {
                        System.err.println(e);
                    }
                    System.err.println("ignoring file " + ff + " because of error when parsing as " + this.template);
                }
                monitor.setTaskProgress((long)(i * 10 + j * 10 / files1.length));
            }
        }
        if (versioning && this.versioningType != VersioningType.none) {
            Comparator<String> comp = this.versioningType.comp;
            HashMap<String, String> bestVersions = new HashMap<String, String>();
            HashMap<String, String> bestFiles = new HashMap<String, String>();
            for (j = 0; j < list.size(); ++j) {
                ff = (String)list.get(j);
                String key = ((DatumRange)rangeList.get(j)).toString();
                String thss = (String)versionList.get(j);
                String best = (String)bestVersions.get(key);
                if (best == null) {
                    try {
                        comp.compare(thss, thss);
                        bestVersions.put(key, thss);
                        bestFiles.put(key, ff);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                try {
                    if (comp.compare(best, thss) >= 0) continue;
                    bestVersions.put(key, thss);
                    bestFiles.put(key, ff);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            list = Arrays.asList(bestFiles.values().toArray(new String[bestFiles.size()]));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                DatumRange dr1 = FileStorageModelNew.this.getRangeFor((String)o1);
                DatumRange dr2 = FileStorageModelNew.this.getRangeFor((String)o2);
                return dr1.compareTo((Object)dr2);
            }
        });
        monitor.finished();
        return list.toArray(new String[list.size()]);
    }

    public static CacheTag getCacheTagFor(FileStorageModelNew fsm, DatumRange range, String[] names) {
        Datum min = range.min();
        Datum max = range.max();
        for (int i = 0; i < names.length; ++i) {
            DatumRange r = fsm.getRangeFor(names[i]);
            min = min.gt(range.min()) ? r.min() : min;
            max = max.lt(range.max()) ? r.max() : max;
        }
        return new CacheTag(min, max, null);
    }

    public static CacheTag getCacheTagFor(FileStorageModelNew fsm, DatumRange range, File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = fsm.getNameFor(files[i]);
        }
        return FileStorageModelNew.getCacheTagFor(fsm, range, names);
    }

    public File[] getFilesFor(DatumRange targetRange) throws IOException {
        return this.getFilesFor(targetRange, (ProgressMonitor)new NullProgressMonitor());
    }

    public File[] getBestFilesFor(DatumRange targetRange) throws IOException {
        return this.getBestFilesFor(targetRange, (ProgressMonitor)new NullProgressMonitor());
    }

    public DatumRange getRangeFor(String name) {
        return this.getDatumRangeFor(name, new HashMap<String, String>());
    }

    public boolean containsFile(File file) {
        if (!this.fileNameMap.containsKey(file)) {
            return false;
        }
        String name = this.getNameFor(file);
        Matcher m = this.pattern.matcher(name);
        return m.matches();
    }

    public String getNameFor(File file) {
        String result = (String)this.fileNameMap.get(file);
        if (result == null) {
            throw new IllegalArgumentException("File didn't come from this FileStorageModel");
        }
        return result;
    }

    private File maybeGetGzFile(String name, ProgressMonitor mon) throws IOException {
        File f0 = null;
        FileObject oz = this.root.getFileObject(name + ".gz");
        if (oz.exists()) {
            File fz = oz.getFile(mon);
            String sfz = fz.getPath().substring(0, fz.getPath().length() - 3);
            f0 = new File(sfz);
            FileSystemUtil.unzip((File)fz, (File)f0);
            if (!f0.setLastModified(fz.lastModified())) {
                throw new IllegalArgumentException("failed to set last modified");
            }
        }
        return f0;
    }

    public File[] getFilesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String[] names = this.getNamesFor(targetRange);
        File[] files = new File[names.length];
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
        if (names.length > 0) {
            monitor.setTaskSize((long)(names.length * 10));
        }
        monitor.started();
        for (int i = 0; i < names.length; ++i) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException("cancel pressed");
            }
            try {
                FileObject o = this.root.getFileObject(names[i]);
                if (o.exists()) {
                    files[i] = o.getFile((ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                } else if (this.allowGz) {
                    File f0;
                    files[i] = f0 = this.maybeGetGzFile(names[i], (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                }
                this.fileNameMap.put(files[i], names[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        monitor.finished();
        return files;
    }

    public File[] getBestFilesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String[] names = this.getNamesFor(targetRange, true, monitor);
        File[] files = new File[names.length];
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
        if (names.length > 0) {
            monitor.setTaskSize((long)(names.length * 10));
        }
        monitor.started();
        for (int i = 0; i < names.length; ++i) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException("cancel pressed");
            }
            try {
                FileObject o = this.root.getFileObject(names[i]);
                if (o.exists()) {
                    files[i] = o.getFile((ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                } else if (this.allowGz) {
                    File f0;
                    files[i] = f0 = this.maybeGetGzFile(names[i], (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)monitor, (long)(i * 10), (long)((i + 1) * 10)));
                }
                this.fileNameMap.put(files[i], names[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        monitor.finished();
        return files;
    }

    private static int countGroups(String regex) {
        boolean result = false;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher("");
        return m.groupCount();
    }

    private static String getParentRegex(String regex) {
        StringBuilder dirRegex;
        String[] s = regex.split("/");
        if (s.length > 1) {
            dirRegex = new StringBuilder(s[0]);
            for (int i = 1; i < s.length - 1; ++i) {
                dirRegex.append("/").append(s[i]);
            }
        } else {
            dirRegex = null;
        }
        return dirRegex == null ? null : dirRegex.toString();
    }

    public FileStorageModelNew getParent() {
        return this.parent;
    }

    protected static String makeCanonical(String template) {
        String result = template.contains("$Y") || template.contains("$y") ? template.replaceAll("\\$", "%") : template;
        int i = result.indexOf("/");
        if (i > -1 && result.indexOf("%") > i) {
            System.err.println("static folder in template not allowed: " + result.substring(0, i));
        }
        return result;
    }

    public static FileStorageModelNew create(FileSystem root, String template) {
        int i2;
        template = FileStorageModelNew.makeCanonical(template);
        int i = template.lastIndexOf("/");
        if (template.contains("$") && !template.contains("%")) {
            template = template.replaceAll("\\$", "%");
        }
        if ((i2 = template.lastIndexOf("%", i)) != -1) {
            String parentTemplate = template.substring(0, i);
            FileStorageModelNew parentFSM = FileStorageModelNew.create(root, parentTemplate);
            return new FileStorageModelNew(parentFSM, root, template);
        }
        return new FileStorageModelNew(null, root, template);
    }

    public static FileStorageModelNew create(FileSystem root, String template, String fieldName, TimeParser.FieldHandler fieldHandler) {
        int i2;
        template = FileStorageModelNew.makeCanonical(template);
        int i = template.lastIndexOf("/");
        if (template.contains("$") && !template.contains("%")) {
            template = template.replaceAll("\\$", "%");
        }
        if ((i2 = template.lastIndexOf("%", i)) != -1) {
            String parentTemplate = template.substring(0, i);
            FileStorageModelNew parentFSM = FileStorageModelNew.create(root, parentTemplate, fieldName, fieldHandler);
            return new FileStorageModelNew(parentFSM, root, template, fieldName, fieldHandler, new Object[0]);
        }
        return new FileStorageModelNew(null, root, template, fieldName, fieldHandler, new Object[0]);
    }

    private FileStorageModelNew(FileStorageModelNew parent, FileSystem root, String template, String fieldName, TimeParser.FieldHandler fieldHandler, Object ... moreHandler) {
        this.root = root;
        this.parent = parent;
        this.template = template.replaceAll("\\+", "\\\\+");
        String f = "v";
        this.versioningType = VersioningType.none;
        TimeParser.FieldHandler vh = new TimeParser.FieldHandler(){

            public String configure(Map<String, String> args) {
                String sep = args.get("sep");
                String alpha = args.get("alpha");
                if (alpha != null) {
                    if (sep != null) {
                        return "alpha with split not supported";
                    }
                    FileStorageModelNew.this.versioningType = VersioningType.alphanumeric;
                } else {
                    FileStorageModelNew.this.versioningType = sep != null ? VersioningType.numericSplit : VersioningType.numeric;
                }
                return null;
            }

            public void handleValue(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) {
                extra.put("v", fieldContent);
            }
        };
        this.timeParser = fieldName == null ? TimeParser.create((String)template, (String)f, (TimeParser.FieldHandler)vh, (Object[])new Object[0]) : (moreHandler == null || moreHandler.length == 0 ? TimeParser.create((String)template, (String)fieldName, (TimeParser.FieldHandler)fieldHandler, (Object[])new Object[]{f, vh}) : TimeParser.create((String)template, (String)fieldName, (TimeParser.FieldHandler)fieldHandler, (Object[])new Object[]{f, vh, moreHandler}));
        if (this.timeParser.isStartTimeOnly()) {
            this.startTimeOnly = true;
        }
        this.regex = this.timeParser.getRegex();
        this.pattern = Pattern.compile(this.regex);
        if (template.endsWith(".gz")) {
            this.allowGz = false;
        }
        if (this.allowGz) {
            this.gzpattern = Pattern.compile(this.regex + "\\.gz");
        }
    }

    private FileStorageModelNew(FileStorageModelNew parent, FileSystem root, String template) {
        this(parent, root, template, null, null, new Object[0]);
    }

    public String toString() {
        return String.valueOf(this.root) + this.regex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VersioningType {
        none(null),
        numeric(new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = Double.parseDouble((String)o1);
                Double d2 = Double.parseDouble((String)o2);
                return d1.compareTo(d2);
            }
        }),
        alphanumeric(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        }),
        numericSplit(new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] ss1 = o1.toString().split("\\.", -2);
                String[] ss2 = o2.toString().split("\\.", -2);
                int n = Math.min(ss1.length, ss2.length);
                for (int i = 0; i < n; ++i) {
                    double d2;
                    double d1 = Double.parseDouble(ss1[i]);
                    if (d1 == (d2 = Double.parseDouble(ss2[i]))) continue;
                    return d1 < d2 ? -1 : 1;
                }
                return ss1.length - ss2.length;
            }
        });

        Comparator<String> comp;

        private VersioningType(Comparator<String> comp) {
            this.comp = comp;
        }
    }
}

