/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;

public class Arrow
extends DasCanvasComponent {
    Point head;
    Point tail;
    Stroke stroke;
    double em = 24.0;

    public Arrow(DasCanvas c, Point head, Point tail) {
        this.head = head;
        this.tail = tail;
        this.setRow(new DasRow(c, head.getX(), tail.getX()));
        this.setColumn(new DasColumn(c, head.getY(), tail.getY()));
    }

    public void resize() {
        Rectangle bounds = new Rectangle();
        bounds.add((double)this.head.x - this.em, (double)this.head.y - this.em);
        bounds.add((double)this.tail.x + this.em, (double)this.tail.y + this.em);
        this.setBounds(bounds);
    }

    public static void paintArrow(Graphics2D g, Point head, Point tail, double em, HeadStyle style) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double line = new Line2D.Double(head, tail);
        double dx = -(head.getX() - tail.getX());
        double dy = -(head.getY() - tail.getY());
        double dd = Math.sqrt(dx * dx + dy * dy);
        dx = dx * em / 4.0 / dd;
        dy = dy * em / 4.0 / dd;
        double hx = head.getX();
        double hy = head.getY();
        g.setStroke(new BasicStroke((float)(em / 8.0), 1, 1));
        g.draw(line);
        GeneralPath p = new GeneralPath();
        p.moveTo((float)hx, (float)hy);
        if (style == HeadStyle.DRAFTING) {
            p.lineTo((float)(hx + 2.0 * dx + 0.5 * dy), (float)(hy + 2.0 * dy - 0.5 * dx));
            p.lineTo((float)(hx + 3.0 * dx + dy), (float)(hy + 3.0 * dy - dx));
            p.lineTo((float)(hx + 3.0 * dx - dy), (float)(hy + 3.0 * dy + dx));
            p.lineTo((float)(hx + 2.0 * dx - 0.5 * dy), (float)(hy + 2.0 * dy + 0.5 * dx));
            p.lineTo((float)hx, (float)hy);
        } else if (style == HeadStyle.FAT_TRIANGLE) {
            p.lineTo((float)(hx + 3.0 * dx + 1.5 * dy), (float)(hy + 3.0 * dy - 1.5 * dx));
            p.lineTo((float)(hx + 3.0 * dx - 1.5 * dy), (float)(hy + 3.0 * dy + 1.5 * dx));
            p.lineTo((float)hx, (float)hy);
        } else if (style == HeadStyle.THIN_TRIANGLE) {
            p.lineTo((float)(hx + 3.0 * dx + dy), (float)(hy + 3.0 * dy - dx));
            p.lineTo((float)(hx + 3.0 * dx - dy), (float)(hy + 3.0 * dy + dx));
            p.lineTo((float)hx, (float)hy);
        }
        g.fill(p);
        g.draw(p);
    }

    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        g.translate(-this.getX(), -this.getY());
        Arrow.paintArrow(g, this.head, this.tail, this.em, HeadStyle.DRAFTING);
        this.getDasMouseInputAdapter().paint(g1);
        g.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeadStyle {
        DRAFTING,
        FAT_TRIANGLE,
        THIN_TRIANGLE;

    }
}

