/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.system.DasLogger;

public class Auralizor {
    private static final int EXTERNAL_BUFFER_SIZE = 100000;
    ByteBuffer buffer;
    byte[] buf;
    SourceDataLine line = null;
    int bufferInputIndex;
    double min = -1.0;
    double max = 1.0;
    Units yUnits;
    VectorDataSet ds;

    void setDataSet(VectorDataSet ds) {
        this.ds = ds;
    }

    public void playSound() {
        float sampleRate = (float)(1.0 / this.ds.getXTagDatum(1).subtract(this.ds.getXTagDatum(0)).doubleValue(Units.seconds));
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("sampleRate= " + sampleRate);
        AudioFormat audioFormat = new AudioFormat(sampleRate, 16, 1, true, true);
        this.buf = new byte[100000];
        this.buffer = ByteBuffer.wrap(this.buf);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            this.line.addLineListener(this.getLineListener());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.bufferInputIndex = 0;
        this.line.start();
        int i = 0;
        int ibuf = 0;
        while (i < this.ds.getXLength()) {
            double d = this.ds.getDouble(i++, this.yUnits);
            int b = (int)(65536.0 * (d - this.min) / (this.max - this.min)) - 32768;
            try {
                this.buffer.putShort(ibuf, (short)b);
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
            if ((ibuf += 2) != 100000) continue;
            this.line.write(this.buf, 0, ibuf);
            try {
                FileChannel out = new FileOutputStream("/home/jbf/tmp/foo.bin").getChannel();
                out.write(this.buffer);
                this.buffer.flip();
            }
            catch (IOException ex) {
                Logger.getLogger(Auralizor.class.getName()).log(Level.SEVERE, null, ex);
            }
            ibuf = 0;
        }
        this.line.write(this.buf, 0, ibuf);
        try {
            FileChannel out = new FileOutputStream("/home/jbf/tmp/foo.bin").getChannel();
            out.write(this.buffer);
            this.buffer.flip();
        }
        catch (IOException ex) {
            Logger.getLogger(Auralizor.class.getName()).log(Level.SEVERE, null, ex);
        }
        ibuf = 0;
        this.line.drain();
        this.line.close();
    }

    LineListener getLineListener() {
        return new LineListener(){

            public void update(LineEvent e) {
                if (e.getType().equals(LineEvent.Type.CLOSE)) {
                    // empty if block
                }
            }
        };
    }

    public Auralizor(VectorDataSet ds) {
        DatumRange yrange = DataSetUtil.yRange(ds);
        this.yUnits = Units.dimensionless;
        this.min = yrange.min().doubleValue(this.yUnits);
        this.max = yrange.max().doubleValue(this.yUnits);
        this.ds = ds;
    }
}

