/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasException;
import org.das2.dataset.ClippedTableDataSet;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.math.Contour;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContoursRenderer
extends Renderer {
    GeneralPath[] paths;
    String[] pathLabels;
    private String contours = "-.7,-.6,-.5,-.4,-.3,-.2,-.1,0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9";
    private double labelCadence = 100.0;
    private boolean drawLabels;
    private Color color = Color.BLACK;
    private boolean simplifyPaths = true;
    public static final String PROP_SIMPLIFYPATHS = "simplifyPaths";
    private double lineThick = 1.0;
    public static final String PROP_LINETHICK = "lineThick";

    public synchronized void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g = (Graphics2D)g1;
        if (this.parent.getCanvas().isAntiAlias()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.paths == null) {
            return;
        }
        g.setColor(this.color);
        g.setStroke(new BasicStroke((float)this.lineThick));
        if (this.drawLabels) {
            Area labelClip = this.paintLabels(g);
            Shape rclip = g.getClip() == null ? new Rectangle(this.parent.getX(), this.parent.getY(), this.parent.getWidth(), this.parent.getHeight()) : g.getClip();
            Area clip = new Area(rclip);
            clip.subtract(labelClip);
            g.setClip(clip);
        }
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i] == null) continue;
            g.draw(this.paths[i]);
        }
    }

    private Area paintLabels(Graphics2D g) {
        Area clip = new Area();
        Font font0 = g.getFont();
        AffineTransform at0 = g.getTransform();
        Font font = font0.deriveFont(8.0f);
        g.setFont(font);
        String[] cons = this.contours.trim().split(",");
        double minLength = 20.0;
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i] == null) continue;
            String label = this.pathLabels[i];
            GeneralPath p = this.paths[i];
            if (p == null) continue;
            PathIterator it1 = p.getPathIterator(null);
            PathIterator it2 = p.getPathIterator(null);
            while (!it1.isDone()) {
                double len = GraphUtil.pointsAlongCurve(it1, null, null, null, true);
                int nlabel = 1 + (int)Math.floor(len / this.labelCadence);
                double phase = (len - (double)(nlabel - 1) * this.labelCadence) / 2.0;
                if (len < minLength) {
                    GraphUtil.pointsAlongCurve(it2, null, null, null, true);
                    continue;
                }
                double[] lens = new double[nlabel * 2];
                double labelWidth = 10.0;
                if (labelWidth > this.labelCadence) {
                    labelWidth = this.labelCadence * 0.99;
                }
                for (int ilabel = 0; ilabel < nlabel; ++ilabel) {
                    lens[ilabel * 2] = phase + this.labelCadence * (double)ilabel;
                    lens[ilabel * 2 + 1] = phase + this.labelCadence * (double)ilabel + labelWidth;
                }
                Point2D.Double[] points = new Point2D.Double[nlabel * 2];
                double[] orient = new double[nlabel * 2];
                GraphUtil.pointsAlongCurve(it2, lens, points, orient, true);
                for (int ilabel = 0; ilabel < nlabel; ++ilabel) {
                    AffineTransform at = new AffineTransform();
                    at.translate(points[ilabel * 2].x, points[ilabel * 2].y);
                    at.rotate(orient[ilabel * 2]);
                    Rectangle2D sbounds = g.getFontMetrics().getStringBounds(label, g);
                    double w = sbounds.getWidth();
                    GeneralPath rect = new GeneralPath(sbounds);
                    rect.transform(AffineTransform.getTranslateInstance(-w / 2.0, 0.0));
                    rect.transform(at);
                    clip.add(new Area(rect));
                    AffineTransform gat = new AffineTransform(at0);
                    gat.concatenate(at);
                    g.setTransform(gat);
                    g.setColor(this.color);
                    g.drawString(label, (int)(-w / 2.0), 0);
                }
            }
        }
        g.setTransform(at0);
        return clip;
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    protected Element getDOMElement(Document document) {
        return null;
    }

    public Icon getListIcon() {
        return new ImageIcon(ContoursRenderer.class.getResource("/images/icons/contoursRenderer.png"));
    }

    public String getListLabel() {
        return "" + (this.getLegendLabel().length() > 0 ? this.getLegendLabel() + " " : "contours");
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        super.updatePlotImage(xAxis, yAxis, monitor);
        Object tds = this.getDataSet();
        if (tds == null) {
            return;
        }
        tds = new ClippedTableDataSet((QDataSet)tds, xAxis.getDatumRange(), yAxis.getDatumRange());
        Units units = SemanticOps.getUnits((QDataSet)tds);
        String[] cons = this.contours.trim().split(",");
        double[] dcons = new double[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            double c;
            if (cons[i].trim().equals("")) continue;
            dcons[i] = c = Double.parseDouble(cons[i]);
        }
        DatumVector dv = DatumVector.newDatumVector((double[])dcons, (Units)units);
        boolean rebin = false;
        QDataSet vds = Contour.contour((QDataSet)tds, (QDataSet)DDataSet.wrap((double[])dv.toDoubleArray(units)));
        this.paths = new GeneralPath[dv.getLength()];
        double d0 = units.getFillDouble();
        int ii = -1;
        QDataSet xds = DataSetOps.unbundle((QDataSet)vds, (String)"x");
        QDataSet yds = DataSetOps.unbundle((QDataSet)vds, (String)"y");
        vds = DataSetOps.unbundle((QDataSet)vds, (int)2);
        Units xunits = xAxis.getUnits();
        Units yunits = yAxis.getUnits();
        ArrayList<GeneralPath> list = new ArrayList<GeneralPath>();
        ArrayList<String> labels = new ArrayList<String>();
        GeneralPath currentPath = null;
        double n0 = 0.0;
        double slen = 0.0;
        float fx0 = 0.0f;
        float fy0 = 0.0f;
        DecimalFormat nf = new DecimalFormat("0.00");
        for (int i = 0; i < vds.length(); ++i) {
            double d = vds.value(i);
            int n = (int)xds.value(i);
            float fx = (float)xAxis.transform(xds.value(i), xunits);
            float fy = (float)yAxis.transform(yds.value(i), yunits);
            if (d != d0) {
                ++ii;
                if (currentPath != null && this.simplifyPaths) {
                    GeneralPath newPath = new GeneralPath();
                    int points = GraphUtil.reducePath(currentPath.getPathIterator(null), newPath);
                    list.set(list.indexOf(currentPath), newPath);
                }
                currentPath = new GeneralPath();
                list.add(currentPath);
                labels.add(nf.format(d));
                d0 = d;
                currentPath.moveTo(fx, fy);
                slen = 0.0;
                fx0 = fx;
                fy0 = fy;
            }
            if ((double)n != n0 + 1.0) {
                currentPath.moveTo(fx, fy);
                fx0 = fx;
                fy0 = fy;
                slen = 0.0;
            } else {
                currentPath.lineTo(fx, fy);
            }
            n0 = n;
        }
        this.paths = list.toArray(new GeneralPath[list.size()]);
        this.pathLabels = labels.toArray(new String[labels.size()]);
    }

    public String getContours() {
        return this.contours;
    }

    public void setContours(String contours) {
        String oldContours = this.contours;
        this.contours = contours;
        this.update();
        this.propertyChangeSupport.firePropertyChange("contours", oldContours, contours);
    }

    public double getLabelCadence() {
        return this.labelCadence;
    }

    public void setLabelCadence(double labelCadence) {
        double oldLabelCadence = this.labelCadence;
        this.labelCadence = labelCadence;
        this.update();
        this.propertyChangeSupport.firePropertyChange("labelCadence", new Double(oldLabelCadence), new Double(labelCadence));
    }

    public boolean acceptContext(int x, int y) {
        if (this.paths == null) {
            return false;
        }
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i] == null || !this.paths[i].intersects(x - 2, y - 2, 5.0, 5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    public void setDrawLabels(boolean drawLabels) {
        boolean oldDrawLabels = this.drawLabels;
        this.drawLabels = drawLabels;
        this.update();
        this.propertyChangeSupport.firePropertyChange("drawLabels", new Boolean(oldDrawLabels), new Boolean(drawLabels));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.update();
        this.propertyChangeSupport.firePropertyChange("color", oldColor, color);
    }

    public boolean isSimplifyPaths() {
        return this.simplifyPaths;
    }

    public void setSimplifyPaths(boolean newsimplifyPaths) {
        boolean oldsimplifyPaths = this.simplifyPaths;
        this.simplifyPaths = newsimplifyPaths;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_SIMPLIFYPATHS, oldsimplifyPaths, newsimplifyPaths);
    }

    public double getLineThick() {
        return this.lineThick;
    }

    public void setLineThick(double newlineThick) {
        double oldlineThick = this.lineThick;
        this.lineThick = newlineThick;
        this.propertyChangeSupport.firePropertyChange(PROP_LINETHICK, oldlineThick, newlineThick);
    }
}

