/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.filechooser.FileFilter;
import org.das2.DasApplication;
import org.das2.DasNameException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Editable;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.event.DragRenderer;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Legend;
import org.das2.graph.Painter;
import org.das2.graph.dnd.TransferableCanvasComponent;
import org.das2.system.ChangesSupport;
import org.das2.system.DasLogger;
import org.das2.system.EventQueueBlocker_1;
import org.das2.system.RequestProcessor;
import org.das2.util.AboutUtil;
import org.das2.util.DasDie;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DasPNGEncoder;
import org.das2.util.DnDSupport;
import org.das2.util.awt.GraphicsOutput;

public class DasCanvas
extends JLayeredPane
implements Printable,
Editable,
Scrollable {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer PLOT_LAYER = 300;
    public static final Integer VERTICAL_AXIS_LAYER = 400;
    public static final Integer HORIZONTAL_AXIS_LAYER = 500;
    public static final Integer AXIS_LAYER = VERTICAL_AXIS_LAYER;
    public static final Integer ANNOTATION_LAYER = 1000;
    public static final Integer GLASS_PANE_LAYER = 30000;
    private static final Paint PAINT_ROW = new Color(255, 178, 178, 146);
    private static final Paint PAINT_COLUMN = new Color(178, 178, 255, 146);
    private static final Paint PAINT_SELECTION = Color.GRAY;
    private static final Stroke STROKE_DASHED;
    private List<Painter> topDecorators = new LinkedList<Painter>();
    private List<Painter> bottomDecorators = new LinkedList<Painter>();
    boolean lpaintingForPrint = false;
    private static File currentFile;
    public static final Action SAVE_AS_PNG_ACTION;
    public static final Action SAVE_AS_SVG_ACTION;
    public static final Action SAVE_AS_PDF_ACTION;
    public static final Action EDIT_DAS_PROPERTIES_ACTION;
    public static final Action PRINT_ACTION;
    public static final Action REFRESH_ACTION;
    public static final Action ABOUT_ACTION;
    public final Action PROPERTIES_ACTION = new CanvasAction("properties"){

        public void actionPerformed(ActionEvent e) {
            PropertyEditor editor = new PropertyEditor(DasCanvas.this);
            editor.showDialog(DasCanvas.this);
        }
    };
    private static boolean disableActions;
    private DasApplication application;
    private static final Logger logger;
    private final GlassPane glassPane;
    private String dasName;
    private JPopupMenu popup;
    private boolean editable;
    private int printing = 0;
    List devicePositionList = new ArrayList();
    DnDSupport dndSupport;
    ChangesSupport stateSupport;
    private Set printingThreads;
    private int displayLockCount = 0;
    private Object displayLockObject = new String("DISPLAY_LOCK_OBJECT");
    protected boolean scaleFonts = true;
    public static final String PROP_SCALEFONTS = "scaleFonts";
    public static final String PROP_BASEFONT = "baseFont";
    private Font baseFont = null;
    private static final int R_1024_X_768 = 786432;
    private static final int R_800_X_600 = 480000;
    private static final int R_640_X_480 = 307200;
    private static final int R_320_X_240 = 76800;
    private HashSet horizontalLineSet = new HashSet();
    private HashSet verticalLineSet = new HashSet();
    private HashSet cellSet = new HashSet();
    private String printingTag = "'UIOWA 'yyyyMMdd";
    private boolean textAntiAlias = true;
    private boolean antiAlias = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private boolean fitted;

    public static DasCanvas getFocusCanvas() {
        return CanvasAction.currentCanvas;
    }

    private static FileFilter getFileNameExtensionFilter(final String description, final String ext) {
        return new FileFilter(){

            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.toString().endsWith(ext);
            }

            public String getDescription() {
                return description;
            }
        };
    }

    public List devicePositionList() {
        return Collections.unmodifiableList(this.devicePositionList);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void invalidate() {
        super.invalidate();
    }

    public static void setDisableActions(boolean val) {
        disableActions = val;
    }

    public static Action[] getActions() {
        if (disableActions) {
            return new Action[0];
        }
        return new Action[]{ABOUT_ACTION, REFRESH_ACTION, EDIT_DAS_PROPERTIES_ACTION, PRINT_ACTION, SAVE_AS_PNG_ACTION, SAVE_AS_SVG_ACTION, SAVE_AS_PDF_ACTION};
    }

    public DasCanvas() {
        LookAndFeel.installColorsAndFont(this, "Panel.background", "Panel.foreground", "Panel.font");
        this.application = DasApplication.getDefaultApplication();
        String name = this.application.suggestNameFor(this);
        this.setName(name);
        this.setOpaque(true);
        this.setLayout(new RowColumnLayout());
        this.addComponentListener(this.createResizeListener());
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(400, 300));
        this.setDoubleBuffered(true);
        this.glassPane = new GlassPane();
        this.add((Component)this.glassPane, GLASS_PANE_LAYER);
        if (!this.application.isHeadless()) {
            this.popup = this.createPopupMenu();
            this.addMouseListener(this.createMouseInputAdapter());
            try {
                this.dndSupport = new CanvasDnDSupport();
            }
            catch (SecurityException ex) {
                this.dndSupport = new CanvasDnDSupport();
            }
        }
        CanvasAction.currentCanvas = this;
        this.stateSupport = new ChangesSupport(null, this);
        this.stateSupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (Boolean.FALSE.equals(e.getNewValue())) {
                    DasCanvas.this.setOpaque(true);
                    DasCanvas.this.repaint();
                } else {
                    DasCanvas.this.setOpaque(false);
                }
            }
        });
    }

    public void addTopDecorator(Painter painter) {
        this.topDecorators.add(painter);
        this.repaint();
    }

    public void removeTopDecorator(Painter painter) {
        this.topDecorators.remove(painter);
        this.repaint();
    }

    public boolean hasTopDecorators() {
        return !this.topDecorators.isEmpty();
    }

    public void addBottomDecorator(Painter painter) {
        this.bottomDecorators.add(painter);
        this.repaint();
    }

    public void removeBottomDecorator(Painter painter) {
        this.bottomDecorators.remove(painter);
        this.repaint();
    }

    public boolean hasBottomDecorators() {
        return !this.bottomDecorators.isEmpty();
    }

    private MouseInputAdapter createMouseInputAdapter() {
        return new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                CanvasAction.currentCanvas = DasCanvas.this;
                if (e.isPopupTrigger()) {
                    DasCanvas.this.popup.show(DasCanvas.this, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                CanvasAction.currentCanvas = DasCanvas.this;
                if (e.isPopupTrigger()) {
                    DasCanvas.this.popup.show(DasCanvas.this, e.getX(), e.getY());
                }
            }
        };
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem props = new JMenuItem(this.PROPERTIES_ACTION);
        popup.add(props);
        popup.addSeparator();
        Action[] actions = DasCanvas.getActions();
        if (!disableActions) {
            for (int iaction = 0; iaction < actions.length; ++iaction) {
                JMenuItem item = new JMenuItem();
                item.setAction(actions[iaction]);
                popup.add(item);
            }
        }
        popup.addSeparator();
        JMenuItem close = new JMenuItem("close");
        close.setToolTipText("close this popup");
        popup.add(close);
        return popup;
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public List getDevicePositionList() {
        return Collections.unmodifiableList(this.devicePositionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockDisplay(Object o) {
        Object object = this.displayLockObject;
        synchronized (object) {
            ++this.displayLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeDisplay(Object o) {
        Object object = this.displayLockObject;
        synchronized (object) {
            --this.displayLockCount;
            if (this.displayLockCount == 0) {
                this.displayLockObject.notifyAll();
            }
        }
    }

    public DasCanvas(int width, int height) {
        this();
        this.setPreferredSize(new Dimension(width, height));
    }

    public DasApplication getApplication() {
        return this.application;
    }

    public void setApplication(DasApplication application) {
        this.application = application;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics g1) {
        logger.finest("entering DasCanvas.paintComponent");
        if (this.stateSupport.isValueAdjusting()) {
            logger.finest("value is adjusting, returning");
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        for (Painter p : this.bottomDecorators) {
            p.paint(g);
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.isPrintingThread() || !this.getBackground().equals(Color.WHITE)) {
            g.setColor(this.getBackground());
            Graphics2D g2 = g;
            g2.fill(g2.getClipBounds());
        }
        g.setColor(this.getForeground());
        if (this.isPrintingThread() && !this.printingTag.equals("")) {
            Date now = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.printingTag);
            String s = dateFormat.format(now);
            Font oldFont = g.getFont();
            Font font = oldFont.deriveFont((float)oldFont.getSize() / 2.0f);
            FontMetrics metrics = g.getFontMetrics(font);
            int width = metrics.stringWidth(s);
            int height = metrics.getHeight();
            g.setFont(font);
            g.drawString(s, this.getWidth() - width - 2 * height, this.getHeight() - 2 * height);
            g.setFont(oldFont);
        }
    }

    public int print(Graphics printGraphics, PageFormat format, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)printGraphics;
        double canvasWidth = this.getWidth();
        double canvasHeight = this.getHeight();
        double printableWidth = format.getImageableWidth();
        double printableHeight = format.getImageableHeight();
        g2.translate(format.getImageableX(), format.getImageableY());
        double canvasMax = Math.max(canvasWidth, canvasHeight);
        double canvasMin = Math.min(canvasWidth, canvasHeight);
        double printableMax = Math.max(printableWidth, printableHeight);
        double printableMin = Math.min(printableWidth, printableHeight);
        double maxScaleFactor = printableMax / canvasMax;
        double minScaleFactor = printableMin / canvasMin;
        double scaleFactor = Math.min(maxScaleFactor, minScaleFactor);
        g2.scale(scaleFactor, scaleFactor);
        if (canvasWidth == canvasMax ^ printableWidth == printableMax) {
            g2.rotate(1.5707963267948966);
            g2.translate(0.0, -canvasHeight);
        }
        this.print(g2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isPrintingThread() {
        DasCanvas dasCanvas = this;
        synchronized (dasCanvas) {
            return this.printingThreads == null ? false : this.printingThreads.contains(Thread.currentThread());
        }
    }

    public boolean lisPaintingForPrint() {
        return this.lpaintingForPrint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics g) {
        DasCanvas dasCanvas = this;
        synchronized (dasCanvas) {
            if (this.printingThreads == null) {
                this.printingThreads = new HashSet();
            }
            this.printingThreads.add(Thread.currentThread());
        }
        try {
            this.setOpaque(false);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof DasPlot)) continue;
                DasPlot p = (DasPlot)c;
            }
            this.lpaintingForPrint = true;
            super.print(g);
            this.lpaintingForPrint = false;
        }
        finally {
            this.setOpaque(true);
            DasCanvas dasCanvas2 = this;
            synchronized (dasCanvas2) {
                this.printingThreads.remove(Thread.currentThread());
            }
        }
    }

    public Printable getPrintable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToPng(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        logger.fine("Enter writeToPng");
        Image image = this.getImage(this.getWidth(), this.getHeight());
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        try {
            logger.fine("Encoding image into png");
            encoder.write((BufferedImage)image, (OutputStream)out);
            logger.fine("write png file " + filename);
        }
        catch (IOException ioe) {
            try {
                out.close();
            }
            catch (IOException ioe2) {
                throw new RuntimeException(ioe2);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void writeToPDF(String filename) throws IOException {
        try {
            this.writeToGraphicsOutput(filename, "org.das2.util.awt.PdfGraphicsOutput");
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("write pdf file " + filename);
        }
        catch (NoClassDefFoundError cnfe) {
            DasExceptionHandler.handle((Throwable)new RuntimeException("PDF output is not available", cnfe));
        }
        catch (ClassNotFoundException cnfe) {
            DasExceptionHandler.handle((Throwable)new RuntimeException("PDF output is not available", cnfe));
        }
        catch (InstantiationException ie) {
            DasExceptionHandler.handleUncaught((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            DasExceptionHandler.handleUncaught((Throwable)iae);
        }
    }

    public void writeToGraphicsOutput(OutputStream out, GraphicsOutput go) throws IOException, IllegalAccessException {
        go.setOutputStream(out);
        go.setSize(this.getWidth(), this.getHeight());
        go.start();
        this.print(go.getGraphics());
        go.finish();
    }

    public void writeToGraphicsOutput(String filename, String graphicsOutput) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FileOutputStream out = new FileOutputStream(filename);
        Class<?> goClass = Class.forName(graphicsOutput);
        GraphicsOutput go = (GraphicsOutput)goClass.newInstance();
        this.writeToGraphicsOutput(out, go);
        out.close();
    }

    public void writeToSVG(String filename) throws IOException {
        try {
            this.writeToGraphicsOutput(filename, "org.das2.util.awt.SvgGraphicsOutput");
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("write svg file " + filename);
        }
        catch (ClassNotFoundException cnfe) {
            DasExceptionHandler.handle((Throwable)new RuntimeException("SVG output is not available", cnfe));
        }
        catch (InstantiationException ie) {
            DasExceptionHandler.handleUncaught((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            DasExceptionHandler.handleUncaught((Throwable)iae);
        }
    }

    public boolean isDirty() {
        DasCanvasComponent[] cc = this.getCanvasComponents();
        boolean result = false;
        for (int i = 0; i < cc.length; ++i) {
            result |= cc[i].isDirty();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() throws InterruptedException {
        String msg = "dasCanvas.waitUntilIdle";
        logger.fine(msg);
        final Object lockObject = new Object();
        EventQueueBlocker_1.clearEventQueue();
        logger.finer("pending events processed");
        Runnable request = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lockObject;
                synchronized (object) {
                    lockObject.notifyAll();
                }
            }
        };
        try {
            Object object = lockObject;
            synchronized (object) {
                logger.finer("submitting invokeAfter to RequestProcessor to block until all tasks are complete");
                RequestProcessor.invokeAfter(request, this);
                lockObject.wait();
                logger.finer("requestProcessor.invokeAfter task complete");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        EventQueueBlocker_1.clearEventQueue();
        logger.finer("post data-load pending events processed");
        if (this.stateSupport.isPendingChanges()) {
            logger.finer("waiting for pending changes");
            while (this.stateSupport.isPendingChanges()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.waitUntilIdle();
        }
        logger.fine("canvas is idle");
    }

    public void resizeAllComponents() {
        int i;
        for (i = 0; i < this.devicePositionList.size(); ++i) {
            ((DasDevicePosition)this.devicePositionList.get(i)).revalidate();
        }
        for (i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof DasCanvasComponent)) continue;
            ((DasCanvasComponent)c).resize();
        }
    }

    public void prepareForOutput(int width, int height) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("dasCanvas.prepareForOutput must not be called from event queue!");
        }
        this.setPreferredWidth(width);
        this.setPreferredHeight(height);
        if (!this.isShowing() || "true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.addNotify();
            logger.finer("setSize(" + this.getPreferredSize() + ")");
            this.setSize(this.getPreferredSize());
            logger.finer("validate()");
            this.validate();
            this.resizeAllComponents();
        }
        try {
            this.waitUntilIdle();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Image getImage(int width, int height) {
        String msg = "dasCanvas.getImage(" + width + "," + height + ")";
        logger.fine(msg);
        this.prepareForOutput(width, height);
        final BufferedImage image = new BufferedImage(width, height, 1);
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeToImageImmediately(image);
        } else {
            Runnable run = new Runnable(){

                public void run() {
                    logger.fine("writeToImageImmediately");
                    DasCanvas.this.writeToImageImmediately(image);
                }
            };
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException ex) {
                this.application.getExceptionHandler().handle((Throwable)ex);
            }
            catch (InterruptedException ex) {
                this.application.getExceptionHandler().handle((Throwable)ex);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToImageImmediately(Image image) {
        try {
            Object object = this.displayLockObject;
            synchronized (object) {
                if (this.displayLockCount != 0) {
                    this.displayLockObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, image.getWidth(this), image.getHeight(this));
        graphics.setColor(this.getForeground());
        this.print(graphics);
    }

    public void add(DasCanvasComponent c, DasRow row, DasColumn column) {
        if (c.getRow() == DasRow.NULL || c.getRow().getParent() != this) {
            c.setRow(row);
        }
        if (c.getColumn() == DasColumn.NULL || c.getColumn().getParent() != this) {
            c.setColumn(column);
        }
        this.add(c);
        PropertyChangeListener positionListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DasCanvas.this.repaint();
            }
        };
        row.addPropertyChangeListener(positionListener);
        column.addPropertyChangeListener(positionListener);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        Integer layer;
        if (comp == null) {
            DasDie.println((String)"NULL COMPONENT");
            Thread.dumpStack();
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if ((layer = (Integer)((JComponent)comp).getClientProperty("layeredContainerLayer")) == null) {
            if (comp instanceof DasPlot) {
                ((DasPlot)comp).putClientProperty("layeredContainerLayer", PLOT_LAYER);
            } else if (comp instanceof DasAxis) {
                ((DasAxis)comp).putClientProperty("layeredContainerLayer", AXIS_LAYER);
            } else if (comp instanceof Legend) {
                ((Legend)comp).putClientProperty("layeredContainerLayer", AXIS_LAYER);
            } else if (comp instanceof DasAnnotation) {
                ((DasAnnotation)comp).putClientProperty("layeredContainerLayer", ANNOTATION_LAYER);
            } else if (comp instanceof JComponent) {
                ((JComponent)comp).putClientProperty("layeredContainerLayer", DEFAULT_LAYER);
            }
        }
        super.addImpl(comp, constraints, index);
        if (comp instanceof DasCanvasComponent) {
            ((DasCanvasComponent)comp).installComponent();
        }
    }

    public void setPreferredWidth(int width) {
        Dimension pref = this.getPreferredSize();
        pref.width = width;
        this.setPreferredSize(pref);
        if (this.getParent() != null) {
            ((JComponent)this.getParent()).revalidate();
        }
    }

    public void setPreferredHeight(int height) {
        Dimension pref = this.getPreferredSize();
        pref.height = height;
        this.setPreferredSize(pref);
        if (this.getParent() != null) {
            ((JComponent)this.getParent()).revalidate();
        }
    }

    public boolean isScaleFonts() {
        return this.scaleFonts;
    }

    public void setScaleFonts(boolean scaleFonts) {
        boolean oldScaleFonts = this.scaleFonts;
        this.scaleFonts = scaleFonts;
        this.setBaseFont(this.getBaseFont());
        this.firePropertyChange(PROP_SCALEFONTS, oldScaleFonts, scaleFonts);
    }

    public Font getBaseFont() {
        if (this.baseFont == null) {
            this.baseFont = this.getFont();
        }
        return this.baseFont;
    }

    public void setBaseFont(Font font) {
        Font oldFont = this.getFont();
        Font oldBaseFont = this.baseFont;
        this.baseFont = font;
        if (this.scaleFonts) {
            this.setFont(this.getFontForSize(this.getWidth(), this.getHeight()));
        } else {
            this.setFont(font);
        }
        this.firePropertyChange("font", oldFont, this.getFont());
        this.firePropertyChange(PROP_BASEFONT, oldBaseFont, this.baseFont);
        this.repaint();
    }

    private Font getFontForSize(int width, int height) {
        int area = width * height;
        float baseFontSize = this.getBaseFont().getSize2D();
        Font f = area >= 633216 ? this.getBaseFont().deriveFont(baseFontSize / 12.0f * 18.0f) : (area >= 393600 ? this.getBaseFont().deriveFont(baseFontSize / 12.0f * 14.0f) : (area >= 192000 ? this.getBaseFont().deriveFont(baseFontSize / 12.0f * 12.0f) : (area >= 38400 ? this.getBaseFont().deriveFont(baseFontSize / 12.0f * 8.0f) : this.getBaseFont().deriveFont(baseFontSize / 12.0f * 6.0f))));
        return f;
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Font aFont = DasCanvas.this.scaleFonts ? DasCanvas.this.getFontForSize(DasCanvas.this.getWidth(), DasCanvas.this.getHeight()) : DasCanvas.this.getBaseFont();
                if (!aFont.equals(DasCanvas.this.getFont())) {
                    DasCanvas.this.setFont(aFont);
                }
            }
        };
    }

    public DasCanvasComponent getCanvasComponentAt(int x, int y) {
        Component[] components = this.getComponents();
        for (int index = 1; index < components.length; ++index) {
            DasCanvasComponent cc;
            Component c = components[index];
            if (!(c instanceof DasCanvasComponent) || !(cc = (DasCanvasComponent)c).getActiveRegion().contains(x, y)) continue;
            return cc;
        }
        return null;
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        super.remove(index);
        if (comp instanceof DasCanvasComponent) {
            ((DasCanvasComponent)comp).uninstallComponent();
        }
    }

    public HotLine getLineAt(int x, int y) {
        for (HotLine line : this.horizontalLineSet) {
            if (y < line.position - 1 || y > line.position + 1) continue;
            return line;
        }
        for (HotLine line : this.verticalLineSet) {
            if (x < line.position - 1 || x > line.position + 1) continue;
            return line;
        }
        return null;
    }

    public Cell getCellAt(int x, int y) {
        Cell best = null;
        Point bestCenter = null;
        Point boxCenter = null;
        for (Cell box : this.cellSet) {
            Rectangle rc = box.rc;
            if (!rc.contains(x, y)) continue;
            if (best == null) {
                best = box;
                continue;
            }
            if (bestCenter == null) {
                bestCenter = new Point();
                boxCenter = new Point();
            }
            if (best.rc.contains(rc)) {
                best = box;
                continue;
            }
            bestCenter.setLocation(best.rc.x + best.rc.width / 2, best.rc.y + best.rc.height / 2);
            boxCenter.setLocation(rc.x + rc.width / 2, rc.y + rc.height / 2);
            int bestDistance = DasCanvas.distanceSquared(x, y, bestCenter.x, bestCenter.y);
            int boxDistance = DasCanvas.distanceSquared(x, y, boxCenter.x, boxCenter.y);
            if (boxDistance < bestDistance) {
                best = box;
                continue;
            }
            if (boxDistance != bestDistance || rc.width * rc.height >= best.rc.width * best.rc.height) continue;
            best = box;
        }
        return best;
    }

    private static int distanceSquared(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    void addDevicePosition(DasDevicePosition position) {
        this.devicePositionList.add(position);
        if (position instanceof DasRow) {
            this.addRow((DasRow)position);
        } else if (position instanceof DasColumn) {
            this.addColumn((DasColumn)position);
        }
    }

    private void addRow(DasRow row) {
        HotLine min = new HotLine(row, -1);
        HotLine max = new HotLine(row, 1);
        this.horizontalLineSet.add(min);
        this.horizontalLineSet.add(max);
        for (DasDevicePosition position : this.devicePositionList) {
            if (!(position instanceof DasColumn)) continue;
            DasColumn column = (DasColumn)position;
            this.cellSet.add(new Cell(row, column));
        }
    }

    private void addColumn(DasColumn column) {
        HotLine min = new HotLine(column, -1);
        HotLine max = new HotLine(column, 1);
        this.verticalLineSet.add(min);
        this.verticalLineSet.add(max);
        for (DasDevicePosition position : this.devicePositionList) {
            if (!(position instanceof DasRow)) continue;
            DasRow row = (DasRow)position;
            this.cellSet.add(new Cell(row, column));
        }
    }

    public void removepwDevicePosition(DasDevicePosition position) {
        this.devicePositionList.remove(position);
        if (position instanceof DasRow) {
            this.removeRow((DasRow)position);
        } else if (position instanceof DasColumn) {
            this.removeColumn((DasColumn)position);
        }
    }

    private void removeRow(DasRow row) {
        Iterator i = this.horizontalLineSet.iterator();
        while (i.hasNext()) {
            HotLine line = (HotLine)i.next();
            if (line.devicePosition != row) continue;
            i.remove();
        }
        i = this.cellSet.iterator();
        while (i.hasNext()) {
            Cell cell = (Cell)i.next();
            if (cell.row != row) continue;
            i.remove();
        }
    }

    private void removeColumn(DasColumn column) {
        Iterator i = this.verticalLineSet.iterator();
        while (i.hasNext()) {
            HotLine line = (HotLine)i.next();
            if (line.devicePosition != column) continue;
            i.remove();
        }
        i = this.cellSet.iterator();
        while (i.hasNext()) {
            Cell cell = (Cell)i.next();
            if (cell.column != column) continue;
            i.remove();
        }
    }

    public static DasCanvas createFormCanvas(String name, int width, int height) {
        DasCanvas canvas = new DasCanvas(width, height);
        if (name == null) {
            name = "canvas_" + Integer.toHexString(System.identityHashCode(canvas));
        }
        try {
            canvas.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        return canvas;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean b) {
        if (this.editable == b) {
            return;
        }
        this.editable = b;
        this.revalidate();
    }

    public DnDSupport getDnDSupport() {
        return this.dndSupport;
    }

    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(x, y)) continue;
            this.dndSupport.startDrag(x, y, action, evt);
            return true;
        }
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public DasApplication getDasApplication() {
        return this.getApplication();
    }

    public DasCanvasComponent getCanvasComponents(int index) {
        return (DasCanvasComponent)this.getComponent(index + 1);
    }

    public DasCanvasComponent[] getCanvasComponents() {
        int n = this.getComponentCount() - 1;
        DasCanvasComponent[] result = new DasCanvasComponent[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.getCanvasComponents(i);
        }
        return result;
    }

    public String toString() {
        return "[DasCanvas " + this.getWidth() + "x" + this.getHeight() + " " + this.getDasName() + "]";
    }

    public String getPrintingTag() {
        return this.printingTag;
    }

    public void setPrintingTag(String printingTag) {
        String old = this.printingTag;
        this.printingTag = printingTag;
        this.firePropertyChange("printingTag", old, printingTag);
    }

    public boolean isTextAntiAlias() {
        return this.textAntiAlias;
    }

    public void setTextAntiAlias(boolean textAntiAlias) {
        boolean old = this.textAntiAlias;
        this.textAntiAlias = textAntiAlias;
        this.firePropertyChange("textAntiAlias", old, textAntiAlias);
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        boolean old = this.antiAlias;
        this.antiAlias = antiAlias;
        this.firePropertyChange("antiAlias", old, antiAlias);
    }

    public boolean isFitted() {
        return this.fitted;
    }

    public void setFitted(boolean fitted) {
        boolean oldValue = this.fitted;
        this.fitted = fitted;
        this.firePropertyChange("fitted", oldValue, fitted);
        this.revalidate();
    }

    public void makeCurrent() {
        CanvasAction.currentCanvas = this;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width / 10;
            }
            case 1: {
                return visibleRect.height / 10;
            }
        }
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width;
            }
            case 1: {
                return visibleRect.height;
            }
        }
        return 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.fitted;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.fitted;
    }

    public void registerPendingChange(Object client, Object lockObject) {
        this.stateSupport.registerPendingChange(client, lockObject);
    }

    public void performingChange(Object client, Object lockObject) {
        this.stateSupport.performingChange(client, lockObject);
    }

    public void changePerformed(Object client, Object lockObject) {
        this.stateSupport.changePerformed(client, lockObject);
    }

    public boolean isPendingChanges() {
        return this.stateSupport.isPendingChanges();
    }

    public Lock mutatorLock() {
        return this.stateSupport.mutatorLock();
    }

    public boolean isValueAdjusting() {
        return this.stateSupport.isValueAdjusting();
    }

    static {
        float thick = 3.0f;
        int cap = 2;
        int join = 0;
        float[] dash = new float[]{thick * 4.0f, thick * 4.0f};
        STROKE_DASHED = new BasicStroke(thick, cap, join, thick, dash, 0.0f);
        SAVE_AS_PNG_ACTION = new CanvasAction("Save as PNG"){

            public void actionPerformed(ActionEvent e) {
                int choice;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Write to PNG");
                fileChooser.setFileFilter(DasCanvas.getFileNameExtensionFilter("png files", "png"));
                Preferences prefs = Preferences.userNodeForPackage(DasCanvas.class);
                String savedir = prefs.get("savedir", null);
                if (savedir != null) {
                    fileChooser.setCurrentDirectory(new File(savedir));
                }
                if (currentFile != null) {
                    fileChooser.setSelectedFile(currentFile);
                }
                if ((choice = fileChooser.showSaveDialog(currentCanvas)) == 0) {
                    final DasCanvas canvas = currentCanvas;
                    String fname = fileChooser.getSelectedFile().toString();
                    if (!fname.toLowerCase().endsWith(".png")) {
                        fname = fname + ".png";
                    }
                    final String ffname = fname;
                    prefs.put("savedir", new File(ffname).getParent());
                    currentFile = new File(ffname.substring(0, ffname.length() - 4));
                    Runnable run = new Runnable(){

                        public void run() {
                            try {
                                canvas.writeToPng(ffname);
                            }
                            catch (IOException ioe) {
                                DasExceptionHandler.handle((Throwable)ioe);
                            }
                        }
                    };
                    new Thread(run, "writePng").start();
                }
            }
        };
        SAVE_AS_SVG_ACTION = new CanvasAction("Save as SVG"){

            public void actionPerformed(ActionEvent e) {
                int choice;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setApproveButtonText("Select File");
                fileChooser.setDialogTitle("Write to SVG");
                fileChooser.setFileFilter(DasCanvas.getFileNameExtensionFilter("svg files", "svg"));
                Preferences prefs = Preferences.userNodeForPackage(DasCanvas.class);
                String savedir = prefs.get("savedir", null);
                if (savedir != null) {
                    fileChooser.setCurrentDirectory(new File(savedir));
                }
                if (currentFile != null) {
                    fileChooser.setSelectedFile(currentFile);
                }
                if ((choice = fileChooser.showSaveDialog(currentCanvas)) == 0) {
                    final DasCanvas canvas = currentCanvas;
                    String fname = fileChooser.getSelectedFile().toString();
                    if (!fname.toLowerCase().endsWith(".svg")) {
                        fname = fname + ".svg";
                    }
                    final String ffname = fname;
                    prefs.put("savedir", new File(ffname).getParent());
                    currentFile = new File(ffname.substring(0, ffname.length() - 4));
                    Runnable run = new Runnable(){

                        public void run() {
                            try {
                                canvas.writeToSVG(ffname);
                            }
                            catch (IOException ioe) {
                                DasExceptionHandler.handle((Throwable)ioe);
                            }
                        }
                    };
                    new Thread(run, "writeSvg").start();
                }
            }
        };
        SAVE_AS_PDF_ACTION = new CanvasAction("Save as PDF"){

            public void actionPerformed(ActionEvent e) {
                int choice;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setApproveButtonText("Select File");
                fileChooser.setDialogTitle("Write to PDF");
                fileChooser.setFileFilter(DasCanvas.getFileNameExtensionFilter("pdf files", "pdf"));
                Preferences prefs = Preferences.userNodeForPackage(DasCanvas.class);
                String savedir = prefs.get("savedir", null);
                if (savedir != null) {
                    fileChooser.setCurrentDirectory(new File(savedir));
                }
                if (currentFile != null) {
                    fileChooser.setSelectedFile(currentFile);
                }
                if ((choice = fileChooser.showDialog(currentCanvas, "Select File")) == 0) {
                    final DasCanvas canvas = currentCanvas;
                    String fname = fileChooser.getSelectedFile().toString();
                    if (!fname.toLowerCase().endsWith(".pdf")) {
                        fname = fname + ".pdf";
                    }
                    final String ffname = fname;
                    prefs.put("savedir", new File(ffname).getParent());
                    currentFile = new File(ffname.substring(0, ffname.length() - 4));
                    Runnable run = new Runnable(){

                        public void run() {
                            try {
                                canvas.writeToPDF(ffname);
                            }
                            catch (IOException ioe) {
                                DasExceptionHandler.handle((Throwable)ioe);
                            }
                        }
                    };
                    new Thread(run, "writePdf").start();
                }
            }
        };
        EDIT_DAS_PROPERTIES_ACTION = new AbstractAction("DAS Properties"){

            public void actionPerformed(ActionEvent e) {
                DasProperties.showEditor();
            }
        };
        PRINT_ACTION = new CanvasAction("Print..."){

            public void actionPerformed(ActionEvent e) {
                Printable p = currentCanvas.getPrintable();
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setPrintable(p);
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pe) {
                        Object[] message = new Object[]{"Error printing", pe.getMessage()};
                        JOptionPane.showMessageDialog(null, message, "ERROR", 0);
                    }
                }
            }
        };
        REFRESH_ACTION = new CanvasAction("Refresh"){

            public void actionPerformed(ActionEvent e) {
                DasCanvasComponent[] comps = currentCanvas.getCanvasComponents();
                for (int i = 0; i < comps.length; ++i) {
                    comps[i].update();
                }
            }
        };
        ABOUT_ACTION = new CanvasAction("About"){

            public void actionPerformed(ActionEvent e) {
                String aboutContent = AboutUtil.getAboutHtml();
                JOptionPane.showConfirmDialog(currentCanvas, aboutContent, "about das2", -1);
            }
        };
        disableActions = false;
        logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    }

    public static class Cell
    implements PropertyChangeListener {
        Rectangle rc;
        DasRow row;
        DasColumn column;

        Cell(DasRow row, DasColumn column) {
            this.row = row;
            this.column = column;
            this.rc = new Rectangle();
            row.addPropertyChangeListener("dMinimum", this);
            row.addPropertyChangeListener("dMaximum", this);
            column.addPropertyChangeListener("dMinimum", this);
            column.addPropertyChangeListener("dMaximum", this);
            this.rc.x = (int)Math.floor((double)column.getDMinimum() + 0.5);
            this.rc.y = (int)Math.floor((double)row.getDMinimum() + 0.5);
            this.rc.width = (int)Math.floor((double)column.getDMaximum() + 0.5) - this.rc.x;
            this.rc.height = (int)Math.floor((double)row.getDMaximum() + 0.5) - this.rc.y;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == this.row) {
                this.rc.y = (int)Math.floor((double)this.row.getDMinimum() + 0.5);
                this.rc.height = (int)Math.floor((double)this.row.getDMaximum() + 0.5) - this.rc.y;
            } else {
                this.rc.x = (int)Math.floor((double)this.column.getDMinimum() + 0.5);
                this.rc.width = (int)Math.floor((double)this.column.getDMaximum() + 0.5) - this.rc.x;
            }
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + (this.row != null ? this.row.hashCode() : 0);
            hash = 79 * hash + (this.column != null ? this.column.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell box = (Cell)o;
                return box.row == this.row && box.column == this.column;
            }
            return false;
        }

        public String toString() {
            return "{" + this.row.getDasName() + " x " + this.column.getDasName() + ": " + this.rc.toString() + "}";
        }

        public Rectangle getCellBounds() {
            return new Rectangle(this.rc);
        }

        public Rectangle getCellBounds(Rectangle r) {
            if (r == null) {
                return this.getCellBounds();
            }
            r.setBounds(this.rc);
            return r;
        }

        public DasRow getRow() {
            return this.row;
        }

        public DasColumn getColumn() {
            return this.column;
        }
    }

    public static class HotLine
    implements PropertyChangeListener {
        public static final int MIN = -1;
        public static final int NONE = 0;
        public static final int MAX = 1;
        int position;
        DasDevicePosition devicePosition;
        int minOrMax;

        HotLine(DasDevicePosition devicePosition, int minOrMax) {
            this.devicePosition = devicePosition;
            this.minOrMax = minOrMax;
            this.refresh();
            devicePosition.addPropertyChangeListener(minOrMax == -1 ? "dMinimum" : "dMaximum", this);
        }

        void refresh() {
            this.position = this.minOrMax == -1 ? (int)Math.floor((double)this.devicePosition.getDMinimum() + 0.5) : (int)Math.floor((double)this.devicePosition.getDMaximum() + 0.5);
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.refresh();
        }

        public boolean equals(Object o) {
            if (o instanceof HotLine) {
                HotLine h = (HotLine)o;
                return h.devicePosition == this.devicePosition && h.minOrMax == this.minOrMax;
            }
            return false;
        }

        public int hashCode() {
            return this.minOrMax * this.devicePosition.hashCode();
        }

        public String toString() {
            return "{" + this.devicePosition.getDasName() + (this.minOrMax == -1 ? ", MIN, " : ", MAX, ") + this.position + "}";
        }

        public DasDevicePosition getDevicePosition() {
            return this.devicePosition;
        }

        public int getMinOrMax() {
            return this.minOrMax;
        }
    }

    public static class GlassPane
    extends JPanel
    implements MouseInputListener,
    KeyListener {
        boolean blocking = false;
        boolean accepting = false;
        Rectangle target;
        DragRenderer dragRenderer = null;
        Point p1 = null;
        Point p2 = null;

        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
        }

        DasCanvas getCanvas() {
            return (DasCanvas)this.getParent();
        }

        void setBlocking(boolean b) {
            if (b != this.blocking) {
                this.blocking = b;
                if (b) {
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                } else {
                    this.removeMouseListener(this);
                    this.removeMouseMotionListener(this);
                }
                this.repaint();
            }
        }

        void setAccepting(boolean b) {
            if (b != this.accepting) {
                this.accepting = b;
                this.repaint();
            }
        }

        public void setDragRenderer(DragRenderer r, Point p1, Point p2) {
            this.dragRenderer = r;
            this.p1 = p1;
            this.p2 = p2;
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.blocking) {
                this.paintLoading(g2);
            }
            if (((DasCanvas)this.getParent()).getEditingMode()) {
                this.paintRowColumn(g2);
            }
            if (this.accepting && this.target != null) {
                this.paintDnDTarget(g2);
            }
            if (this.dragRenderer != null) {
                this.dragRenderer.renderDrag(g2, this.p1, this.p2);
            }
            for (Painter p : this.getCanvas().topDecorators) {
                try {
                    p.paint(g2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            g2.dispose();
        }

        private void paintRowColumn(Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            DasCanvas canvas = this.getCanvas();
            for (DasDevicePosition d : canvas.devicePositionList) {
                Paint paint;
                int height;
                int y;
                int width;
                int x;
                double minimum = d.getMinimum();
                double maximum = d.getMaximum();
                int cWidth = canvas.getWidth();
                int cHeight = canvas.getHeight();
                if (d instanceof DasRow) {
                    x = 0;
                    width = cWidth;
                    y = (int)Math.floor(minimum * (double)cHeight + 0.5);
                    height = (int)Math.floor(maximum * (double)cHeight + 0.5) - y;
                    paint = PAINT_ROW;
                } else {
                    x = (int)Math.floor(minimum * (double)cWidth + 0.5);
                    width = (int)Math.floor(maximum * (double)cWidth + 0.5) - x;
                    y = 0;
                    height = cHeight;
                    paint = PAINT_COLUMN;
                }
                g2.setPaint(paint);
                g2.fillRect(x, y, width, height);
            }
        }

        private void paintDnDTarget(Graphics2D g2) {
            g2.setStroke(STROKE_DASHED);
            g2.setPaint(PAINT_SELECTION);
            g2.drawRect(this.target.x + 1, this.target.y + 1, this.target.width - 2, this.target.height - 2);
        }

        private void paintLoading(Graphics2D g2) {
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setColor(new Color(-587202561, true));
            Rectangle rect = g2.getClipBounds();
            if (rect == null) {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class CanvasDnDSupport
    extends DnDSupport {
        private List acceptList;

        CanvasDnDSupport() {
            super((Component)DasCanvas.this, 3, null);
            this.acceptList = Arrays.asList(TransferableCanvasComponent.PLOT_FLAVOR, TransferableCanvasComponent.AXIS_FLAVOR, TransferableCanvasComponent.COLORBAR_FLAVOR);
        }

        private Rectangle getAxisRectangle(Rectangle rc, Rectangle t, int x, int y) {
            if (t == null) {
                t = new Rectangle();
            }
            int o = this.getAxisOrientation(rc, x, y);
            switch (o) {
                case 1: {
                    t.width = rc.width;
                    t.height = 3 * DasCanvas.this.getFont().getSize();
                    t.x = rc.x;
                    t.y = rc.y - t.height;
                    break;
                }
                case 4: {
                    t.width = 3 * DasCanvas.this.getFont().getSize();
                    t.height = rc.height;
                    t.x = rc.x + rc.width;
                    t.y = rc.y;
                    break;
                }
                case 3: {
                    t.width = 3 * DasCanvas.this.getFont().getSize();
                    t.height = rc.height;
                    t.x = rc.x - t.width;
                    t.y = rc.y;
                    break;
                }
                case 2: {
                    t.width = rc.width;
                    t.height = 3 * DasCanvas.this.getFont().getSize();
                    t.x = rc.x;
                    t.y = rc.y + rc.height;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid orientation: " + o);
                }
            }
            return t;
        }

        private int getAxisOrientation(Rectangle rc, int x, int y) {
            boolean b;
            int nx = (x - rc.x) * rc.height;
            int ny = (y - rc.y) * rc.width;
            int a = rc.width * rc.height;
            boolean bl = b = nx + ny < a;
            return nx > ny ? (b ? 1 : 4) : (b ? 3 : 2);
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            DasCanvas.this.glassPane.setAccepting(true);
            List<DataFlavor> flavorList = Arrays.asList(flavors);
            Cell cell = DasCanvas.this.getCellAt(x, y);
            Rectangle cellBounds = cell == null ? null : cell.getCellBounds();
            Rectangle target = ((DasCanvas)DasCanvas.this).glassPane.target;
            if (flavorList.contains(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                return action;
            }
            if (flavorList.contains(TransferableCanvasComponent.AXIS_FLAVOR)) {
                if (!(target == cellBounds || target != null && target.equals(cellBounds))) {
                    if (target != null) {
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    }
                    if (cellBounds != null) {
                        target = ((DasCanvas)DasCanvas.this).glassPane.target = this.getAxisRectangle(cellBounds, target, x, y);
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    } else {
                        ((DasCanvas)DasCanvas.this).glassPane.target = null;
                    }
                }
                return action;
            }
            if (flavorList.contains(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR)) {
                if (!(target == cellBounds || target != null && target.equals(cellBounds))) {
                    if (target != null) {
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    }
                    target = ((DasCanvas)DasCanvas.this).glassPane.target = cellBounds;
                    if (cellBounds != null) {
                        DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
                    }
                }
                return action;
            }
            return -1;
        }

        protected void done() {
            DasCanvas.this.glassPane.setAccepting(false);
            if (((DasCanvas)DasCanvas.this).glassPane.target != null) {
                Rectangle target = ((DasCanvas)DasCanvas.this).glassPane.target;
                ((DasCanvas)DasCanvas.this).glassPane.target = null;
                DasCanvas.this.glassPane.repaint(target.x - 1, target.y - 1, target.width + 2, target.height + 2);
            }
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                Cell c;
                if (t.isDataFlavorSupported(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                    Cell c2 = DasCanvas.this.getCellAt(x, y);
                    if (c2 != null) {
                        DasCanvasComponent comp = (DasCanvasComponent)t.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        comp.setRow(c2.getRow());
                        comp.setColumn(c2.getColumn());
                        DasCanvas.this.add(comp);
                        DasCanvas.this.revalidate();
                        success = true;
                    }
                } else if (t.isDataFlavorSupported(TransferableCanvasComponent.AXIS_FLAVOR)) {
                    Cell c3 = DasCanvas.this.getCellAt(x, y);
                    if (c3 != null) {
                        DasAxis axis = (DasAxis)t.getTransferData(TransferableCanvasComponent.AXIS_FLAVOR);
                        axis.setRow(c3.getRow());
                        axis.setColumn(c3.getColumn());
                        Rectangle cellBounds = c3.getCellBounds();
                        int orientation = this.getAxisOrientation(cellBounds, x, y);
                        axis.setOrientation(orientation);
                        DasCanvas.this.add(axis);
                        DasCanvas.this.revalidate();
                        success = true;
                    }
                } else if (t.isDataFlavorSupported(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR) && (c = DasCanvas.this.getCellAt(x, y)) != null) {
                    DasCanvasComponent comp = (DasCanvasComponent)t.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                    comp.setRow(c.getRow());
                    comp.setColumn(c.getColumn());
                    DasCanvas.this.add(comp);
                    DasCanvas.this.revalidate();
                    success = true;
                }
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return success;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            DasCanvasComponent component = DasCanvas.this.getCanvasComponentAt(x, y);
            if (component instanceof DasColorBar) {
                return new TransferableCanvasComponent((DasColorBar)component);
            }
            if (component instanceof DasAxis) {
                return new TransferableCanvasComponent((DasAxis)component);
            }
            if (component instanceof DasPlot) {
                return new TransferableCanvasComponent((DasPlot)component);
            }
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    protected static class RowColumnLayout
    implements LayoutManager {
        protected RowColumnLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int count = target.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component c = target.getComponent(i);
                    if (c instanceof DasCanvasComponent) {
                        ((DasCanvasComponent)c).update();
                        continue;
                    }
                    if (c != ((DasCanvas)target).glassPane) continue;
                    Dimension size = target.getSize();
                    c.setBounds(0, 0, size.width, size.height);
                }
            }
        }

        public Dimension minimumLayoutSize(Container target) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container target) {
            return new Dimension(400, 300);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    protected static abstract class CanvasAction
    extends AbstractAction {
        protected static DasCanvas currentCanvas;

        CanvasAction(String label) {
            super(label);
        }
    }
}

