/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.graph.DasCanvas;

public class DasCanvasStateSupport {
    DasCanvas canvas;
    Map<Object, Object> changesPending;
    private static final Logger logger = Logger.getLogger("das2.graphics");
    public static final String PROP_PENDINGCHANGES = "pendingChanges";

    DasCanvasStateSupport(DasCanvas canvas) {
        this.canvas = canvas;
        this.changesPending = new HashMap<Object, Object>();
    }

    synchronized void registerPendingChange(Object client, Object lockObject) {
        logger.fine("registerPendingChange " + lockObject + " by " + client);
        Object existingClient = this.changesPending.get(lockObject);
        if (existingClient != null) {
            if (existingClient != client) {
                throw new IllegalStateException("lock object in use: " + lockObject + ", by " + this.changesPending.get(lockObject));
            }
            return;
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.put(lockObject, client);
        this.canvas.firePropertyChange(PROP_PENDINGCHANGES, oldVal, true);
    }

    synchronized void performingChange(Object client, Object lockObject) {
    }

    synchronized void changePerformed(Object client, Object lockObject) {
        logger.fine("clearPendingChange " + lockObject + " by " + client);
        if (this.changesPending.get(lockObject) == null) {
            // empty if block
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.remove(lockObject);
        this.canvas.firePropertyChange(PROP_PENDINGCHANGES, oldVal, true);
    }

    public boolean isPendingChanges() {
        return this.changesPending.size() > 0;
    }
}

