/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.das2.CancelledOperationException;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.event.BoxZoomMouseModule;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DisplayDataMouseModule;
import org.das2.event.HorizontalRangeSelectorMouseModule;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.VerticalRangeSelectorMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRendererUpdateEvent;
import org.das2.graph.GraphUtil;
import org.das2.graph.LegendPosition;
import org.das2.graph.Renderer;
import org.das2.graph.TickVDescriptor;
import org.das2.graph.dnd.TransferableRenderer;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DasPlot
extends DasCanvasComponent {
    public static final String PROP_TITLE = "title";
    protected DataSetDescriptor dataSetDescriptor;
    private DasAxis xAxis;
    private DasAxis yAxis;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    protected String offsetTime = "";
    protected String plotTitle = "";
    protected double[] psym_x;
    protected double[] psym_y;
    protected RebinListener rebinListener = new RebinListener();
    protected transient PropertyChangeListener ticksListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (DasPlot.this.drawGrid || DasPlot.this.drawMinorGrid) {
                DasPlot.this.invalidateCacheImage();
            }
        }
    };
    DnDSupport dndSupport;
    static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private JMenuItem editRendererMenuItem;
    boolean cacheImageValid = false;
    BufferedImage cacheImage;
    Rectangle cacheImageBounds;
    boolean preview = false;
    private int titleHeight = 0;
    protected Renderer focusRenderer = null;
    public static final String PROP_FOCUSRENDERER = "focusRenderer";
    public Action DUMP_TO_FILE_ACTION = new AbstractAction("Dump Data Set to File"){

        public void actionPerformed(ActionEvent e) {
            List<Renderer> renderers1 = Arrays.asList(DasPlot.this.getRenderers());
            if (renderers1.isEmpty()) {
                return;
            }
            Renderer renderer = renderers1.get(0);
            JFileChooser chooser = new JFileChooser();
            int result = chooser.showSaveDialog(DasPlot.this);
            if (result == 0) {
                File selected = chooser.getSelectedFile();
                try {
                    FileChannel out = new FileOutputStream(selected).getChannel();
                    DataSet ds = DataSetAdapter.createLegacyDataSet(renderer.getDataSet());
                    if (ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)ds, out);
                    } else if (ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)ds, out);
                    }
                }
                catch (IOException ioe) {
                    DasExceptionHandler.handle((Throwable)ioe);
                }
            }
        }
    };
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    List messages;
    List<LegendElement> legendElements;
    public static final String PROP_CONTEXT = "context";
    DatumRange context = null;
    private List<Renderer> renderers = null;
    private LegendPosition legendPosition = LegendPosition.NE;
    public static final String PROP_LEGENDPOSITION = "legendPosition";
    private boolean drawGrid = false;
    public static final String PROP_DRAWGRID = "drawGrid";
    private boolean drawMinorGrid;
    public static final String PROP_DRAWMINORGRID = "drawMinorGrid";
    protected boolean gridOver = true;
    public static final String PROP_GRIDOVER = "gridOver";
    protected boolean overSize = false;
    public static final String PROP_OVERSIZE = "overSize";

    public DasPlot(DasAxis xAxis, DasAxis yAxis) {
        this.addMouseListener(new MouseInputAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mousePressed(MouseEvent e) {
                int ir;
                Renderer r = null;
                DasPlot dasPlot = DasPlot.this;
                synchronized (dasPlot) {
                    ir = DasPlot.this.findRendererAt(DasPlot.this.getX() + e.getX(), DasPlot.this.getY() + e.getY());
                    if (ir > -1) {
                        r = (Renderer)DasPlot.this.renderers.get(ir);
                    }
                    DasPlot.this.setFocusRenderer(r);
                }
                if (DasPlot.this.editRendererMenuItem != null) {
                    DasPlot.this.editRendererMenuItem.setText("Renderer Properties");
                    if (ir > -1) {
                        DasPlot.this.editRendererMenuItem.setEnabled(true);
                        DasPlot.this.editRendererMenuItem.setIcon(r.getListIcon());
                    } else {
                        DasPlot.this.editRendererMenuItem.setEnabled(false);
                        DasPlot.this.editRendererMenuItem.setIcon(null);
                    }
                }
            }
        });
        this.setOpaque(false);
        this.renderers = new ArrayList<Renderer>();
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
            yAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.addDefaultMouseModules();
        }
    }

    public Renderer getFocusRenderer() {
        return this.focusRenderer;
    }

    public void setFocusRenderer(Renderer focusRenderer) {
        Renderer oldFocusRenderer = this.focusRenderer;
        this.focusRenderer = focusRenderer;
        this.firePropertyChange(PROP_FOCUSRENDERER, null, focusRenderer);
    }

    private Rectangle getLegendBounds(Graphics2D graphics, int msgx, int msgy) {
        Rectangle mrect;
        int maxIconWidth = 0;
        Rectangle boundRect = null;
        int em = (int)this.getEmSize();
        if (this.legendElements == null) {
            return null;
        }
        if (graphics == null) {
            return null;
        }
        for (int i = 0; i < this.legendElements.size(); ++i) {
            LegendElement le = this.legendElements.get(i);
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString((Graphics)graphics, String.valueOf(le.label));
            mrect = gtr.getBounds();
            maxIconWidth = Math.max(maxIconWidth, le.icon.getIconWidth());
            int theheight = Math.max(mrect.height, le.icon.getIconHeight());
            mrect.translate(msgx, msgy + (int)gtr.getAscent());
            mrect.height = theheight;
            if (boundRect == null) {
                boundRect = mrect;
            } else {
                boundRect.add(mrect);
            }
            msgy += theheight;
        }
        if (boundRect == null) {
            return null;
        }
        int iconColumnWidth = maxIconWidth + em / 4;
        mrect = new Rectangle(boundRect);
        mrect.width += iconColumnWidth;
        if (this.legendPosition == LegendPosition.NE || this.legendPosition == LegendPosition.NW) {
            mrect.y = this.yAxis.getRow().getDMinimum() + em / 2;
            if (this.legendPosition == LegendPosition.NE) {
                mrect.x = this.xAxis.getColumn().getDMaximum() - em - mrect.width;
            } else if (this.legendPosition == LegendPosition.NW) {
                mrect.x = this.xAxis.getColumn().getDMinimum() + em;
            }
        } else if (this.legendPosition == LegendPosition.SE || this.legendPosition == LegendPosition.SW) {
            mrect.y = this.yAxis.getRow().getDMaximum() - boundRect.height - em;
            if (this.legendPosition == LegendPosition.SE) {
                mrect.x = this.xAxis.getColumn().getDMaximum() - em - mrect.width;
            } else if (this.legendPosition == LegendPosition.SW) {
                mrect.x = this.xAxis.getColumn().getDMinimum() + em;
            }
        } else if (this.legendPosition == LegendPosition.OutsideNE) {
            boundRect.x = mrect.x = this.xAxis.getColumn().getDMaximum() + em + maxIconWidth;
            mrect.y = this.yAxis.getRow().getDMinimum();
        } else {
            throw new IllegalArgumentException("not supported: " + this.legendPosition);
        }
        Rectangle axisBounds = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
        axisBounds.width = Math.max(axisBounds.width, mrect.x + mrect.width - axisBounds.x);
        Rectangle2D rr = mrect.createIntersection(axisBounds);
        return new Rectangle((int)rr.getX(), (int)rr.getY(), (int)rr.getWidth(), (int)rr.getHeight());
    }

    private void drawLegend(Graphics2D g) {
        LegendElement le;
        int i;
        Graphics2D graphics = (Graphics2D)g.create();
        int em = (int)this.getEmSize();
        Color backColor = GraphUtil.getRicePaperColor();
        em = (int)this.getEmSize();
        int msgx = this.xAxis.getColumn().getDMiddle() + em;
        int msgy = this.yAxis.getRow().getDMinimum() + em / 2;
        int maxIconWidth = 0;
        for (i = 0; i < this.legendElements.size(); ++i) {
            le = this.legendElements.get(i);
            maxIconWidth = Math.max(maxIconWidth, le.icon.getIconWidth());
        }
        Rectangle mrect = this.getLegendBounds(graphics, msgx, msgy);
        msgx = mrect.x;
        msgy = mrect.y;
        if (this.legendPosition != LegendPosition.OutsideNE) {
            msgx += maxIconWidth + em / 4;
        }
        if (this.legendPosition != LegendPosition.OutsideNE) {
            graphics.setColor(backColor);
            graphics.fillRoundRect(mrect.x - em / 4, mrect.y - em / 4, mrect.width + em / 2, mrect.height + em / 2, 5, 5);
            graphics.setColor(this.getForeground());
            graphics.drawRoundRect(mrect.x - em / 4, mrect.y - em / 4, mrect.width + em / 2, mrect.height + em / 2, 5, 5);
        }
        for (i = 0; i < this.legendElements.size(); ++i) {
            le = this.legendElements.get(i);
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString((Graphics)graphics, String.valueOf(le.label));
            mrect = gtr.getBounds();
            mrect.translate(msgx, msgy + (int)gtr.getAscent());
            int theheight = Math.max(mrect.height, le.icon.getIconHeight());
            int icony = theheight / 2 - le.icon.getIconHeight() / 2;
            int texty = theheight / 2 - (int)gtr.getHeight() / 2 + (int)gtr.getAscent();
            gtr.draw((Graphics)graphics, (float)msgx, (float)(msgy + texty));
            mrect.height = theheight;
            Rectangle imgBounds = new Rectangle(msgx - (le.icon.getIconWidth() + em / 4), msgy + icony, le.icon.getIconWidth(), le.icon.getIconHeight());
            boolean printing = true;
            if (printing) {
                le.drawIcon(graphics, msgx - (le.icon.getIconWidth() + em / 4), msgy + icony);
            } else {
                graphics.drawImage(le.icon.getImage(), imgBounds.x, imgBounds.y, null);
            }
            msgy = (int)((double)msgy + mrect.getHeight());
            mrect.add(imgBounds);
            if (msgy > this.getRow().bottom()) break;
            le.bounds = mrect;
        }
        graphics.dispose();
    }

    private void drawMessages(Graphics2D g) {
        Graphics2D graphics = (Graphics2D)g.create();
        Font font0 = graphics.getFont();
        int msgem = (int)Math.max(8.0f, font0.getSize2D() / 2.0f);
        graphics.setFont(font0.deriveFont((float)msgem));
        int em = (int)this.getEmSize();
        boolean rightJustify = false;
        int msgx = this.xAxis.getColumn().getDMinimum() + em;
        int msgy = this.yAxis.getRow().getDMinimum() + em;
        if (this.legendPosition == LegendPosition.NW) {
            rightJustify = true;
            msgx = this.xAxis.getColumn().getDMaximum() - em;
        }
        Color warnColor = new Color(255, 255, 100, 200);
        Color errorColor = new Color(255, 140, 140, 200);
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageDescriptor message = (MessageDescriptor)this.messages.get(i);
            List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
            Icon icon = null;
            if (message.renderer != null && renderers1.size() > 1) {
                icon = message.renderer.getListIcon();
            }
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString((Graphics)graphics, String.valueOf(message.text));
            Rectangle mrect = gtr.getBounds();
            if (icon != null && mrect.height < icon.getIconHeight()) {
                mrect.height = icon.getIconHeight();
            }
            int spc = 2;
            if (icon != null) {
                mrect.width += icon.getIconWidth() + spc;
            }
            int msgx1 = msgx;
            if (rightJustify) {
                msgx1 = msgx - (int)mrect.getWidth();
            }
            mrect.translate(msgx1, msgy);
            Color backColor = GraphUtil.getRicePaperColor();
            if (message.messageType == 1) {
                backColor = warnColor;
            } else if (message.messageType == 2) {
                backColor = errorColor;
            }
            graphics.setColor(backColor);
            graphics.fillRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
            graphics.setColor(this.getForeground());
            if (icon != null) {
                icon.paintIcon(this, g, mrect.x, mrect.y);
            }
            graphics.drawRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
            if (icon != null) {
                gtr.draw((Graphics)graphics, (float)(msgx1 + icon.getIconWidth() + spc), (float)msgy);
            } else {
                gtr.draw((Graphics)graphics, (float)msgx1, (float)msgy);
            }
            message.bounds = mrect;
            msgy = (int)((double)msgy + (gtr.getHeight() + (double)(msgem / 2)));
        }
        graphics.dispose();
    }

    private void maybeDrawGrid(Graphics2D plotGraphics) {
        DatumVector yticks;
        DatumVector xticks;
        Color gridColor = new Color(128, 128, 128, 70);
        Color minorGridColor = new Color(128, 128, 128, 40);
        TickVDescriptor xtickv = this.getXAxis().getTickV();
        TickVDescriptor ytickv = this.getYAxis().getTickV();
        if (this.drawMinorGrid) {
            xticks = null;
            yticks = null;
            if (this.getXAxis().isVisible() && xtickv != null) {
                xticks = xtickv.getMinorTicks();
            }
            if (this.getYAxis().isVisible() && ytickv != null) {
                yticks = ytickv.getMinorTicks();
            }
            plotGraphics.setColor(minorGridColor);
            this.drawGrid(plotGraphics, xticks, yticks);
        }
        if (this.drawGrid) {
            xticks = null;
            yticks = null;
            if (this.getXAxis().isVisible() && xtickv != null) {
                xticks = xtickv.getMajorTicks();
            }
            if (this.getYAxis().isVisible() && ytickv != null) {
                yticks = ytickv.getMajorTicks();
            }
            plotGraphics.setColor(gridColor);
            this.drawGrid(plotGraphics, xticks, yticks);
        }
    }

    private void drawCacheImage(Graphics2D plotGraphics) {
        this.messages = new ArrayList();
        this.legendElements = new ArrayList<LegendElement>();
        if (!this.gridOver) {
            this.maybeDrawGrid(plotGraphics);
        }
        this.drawContent(plotGraphics);
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        boolean noneActive = true;
        for (int i = 0; i < renderers1.size(); ++i) {
            Renderer rend = renderers1.get(i);
            if (rend.isActive()) {
                logger.log(Level.FINEST, "rendering #{0}: {1}", new Object[]{i, rend});
                try {
                    rend.render(plotGraphics, this.xAxis, this.yAxis, (ProgressMonitor)new NullProgressMonitor());
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    this.postException(rend, ex);
                }
                noneActive = false;
                if (!rend.isDrawLegendLabel()) continue;
                this.addToLegend(rend, (ImageIcon)rend.getListIcon(), 0, rend.getLegendLabel());
                continue;
            }
            if (!rend.isDrawLegendLabel()) continue;
            this.addToLegend(rend, (ImageIcon)rend.getListIcon(), 0, rend.getLegendLabel() + " (inactive)");
        }
        if (this.gridOver) {
            this.maybeDrawGrid(plotGraphics);
        }
        if (renderers1.isEmpty()) {
            this.postMessage(null, "(no renderers)", 0, null, null);
            logger.fine("dasPlot has no renderers");
        } else if (noneActive) {
            this.postMessage(null, "(no active renderers)", 0, null, null);
        }
    }

    public int findRendererAt(int x, int y) {
        int result;
        int i;
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        for (i = 0; this.messages != null && i < this.messages.size(); ++i) {
            MessageDescriptor message = (MessageDescriptor)this.messages.get(i);
            if (message.bounds == null || !message.bounds.contains(x, y) || message.renderer == null || (result = renderers1.indexOf(message.renderer)) == -1) continue;
            return result;
        }
        for (i = 0; this.legendElements != null && i < this.legendElements.size(); ++i) {
            LegendElement legendElement = this.legendElements.get(i);
            if (legendElement.bounds == null || !legendElement.bounds.contains(x, y) || legendElement.renderer == null || (result = renderers1.indexOf(legendElement.renderer)) == -1) continue;
            return result;
        }
        for (i = renderers1.size() - 1; i >= 0; --i) {
            Renderer rend = renderers1.get(i);
            if (!rend.isActive() || !rend.acceptContext(x, y)) continue;
            return i;
        }
        return -1;
    }

    private Action getEditAction() {
        return new AbstractAction("Renderer Properties"){

            public void actionPerformed(ActionEvent e) {
                Point p = DasPlot.this.getDasMouseInputAdapter().getMousePressPosition();
                int i = DasPlot.this.findRendererAt(p.x + DasPlot.this.getX(), p.y + DasPlot.this.getY());
                if (i > -1) {
                    Renderer rend = DasPlot.this.getRenderer(i);
                    PropertyEditor editor = new PropertyEditor(rend);
                    editor.showDialog(DasPlot.this);
                }
            }
        };
    }

    private void addDefaultMouseModules() {
        HorizontalRangeSelectorMouseModule hrs = new HorizontalRangeSelectorMouseModule(this, this.xAxis);
        this.mouseAdapter.addMouseModule(hrs);
        hrs.addDataRangeSelectionListener(this.xAxis);
        VerticalRangeSelectorMouseModule vrs = new VerticalRangeSelectorMouseModule(this, this.yAxis);
        this.mouseAdapter.addMouseModule(vrs);
        vrs.addDataRangeSelectionListener(this.yAxis);
        MouseModule x = CrossHairMouseModule.create(this);
        this.mouseAdapter.addMouseModule(x);
        this.mouseAdapter.setSecondaryModule(new ZoomPanMouseModule((DasCanvasComponent)this, this.getXAxis(), this.getYAxis()));
        this.mouseAdapter.setPrimaryModule(x);
        this.mouseAdapter.addMouseModule(new BoxZoomMouseModule(this, null, this.getXAxis(), this.getYAxis()));
        x = new MouseModule(this, new LengthDragRenderer(this, null, null), "Length");
        this.mouseAdapter.addMouseModule(x);
        x = new DisplayDataMouseModule(this);
        this.mouseAdapter.addMouseModule(x);
        this.setEnableRenderPropertiesAction(true);
        if (DasApplication.hasAllPermission()) {
            JMenuItem dumpMenuItem = new JMenuItem(this.DUMP_TO_FILE_ACTION);
            this.mouseAdapter.addMenuItem(dumpMenuItem);
        }
    }

    public void setXAxis(DasAxis xAxis) {
        DasAxis oldValue = this.xAxis;
        Container parent = this.getParent();
        if (this.xAxis != null) {
            DasProperties.getLogger().fine("setXAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.xAxis);
            }
            xAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.removePropertyChangeListener("datumRange", this.rebinListener);
            xAxis.removePropertyChangeListener("log", this.rebinListener);
            xAxis.removePropertyChangeListener("ticks", this.ticksListener);
        }
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            if (parent != null) {
                parent.add(this.xAxis);
                parent.validate();
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        if (xAxis != oldValue) {
            this.firePropertyChange("xAxis", oldValue, xAxis);
        }
    }

    public void setYAxis(DasAxis yAxis) {
        DasAxis oldValue = this.yAxis;
        logger.log(Level.FINE, "setYAxis({0}), removes {1}", new Object[]{yAxis == null ? "null" : yAxis.getName(), this.yAxis});
        Container parent = this.getParent();
        if (this.yAxis != null) {
            DasProperties.getLogger().fine("setYAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.yAxis);
            }
            this.yAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("datumRange", this.rebinListener);
            this.yAxis.removePropertyChangeListener("log", this.rebinListener);
            this.yAxis.removePropertyChangeListener("ticks", this.ticksListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.setRow(this.getRow());
            yAxis.setColumn(this.getColumn());
            if (parent != null) {
                parent.add(this.yAxis);
                parent.validate();
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener("datumRange", this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
            yAxis.addPropertyChangeListener("ticks", this.ticksListener);
        }
        if (yAxis != oldValue) {
            this.firePropertyChange("yAxis", oldValue, yAxis);
        }
    }

    protected void updateImmediately() {
        super.updateImmediately();
        logger.finer("DasPlot.updateImmediately");
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        for (int i = 0; i < renderers1.size(); ++i) {
            Renderer rend = renderers1.get(i);
            rend.update();
        }
    }

    protected AffineTransform getAffineTransform(DasAxis xAxis, DasAxis yAxis) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform at = new AffineTransform();
        at = xAxis.getAffineTransform(this.xmemento, at);
        at = yAxis.getAffineTransform(this.ymemento, at);
        return at;
    }

    private boolean isIdentity(AffineTransform at) {
        return at.isIdentity() || Math.abs(at.getScaleX() - 1.0) < 0.001 && Math.abs(at.getScaleY() - 1.0) < 0.001 && Math.abs(at.getTranslateX()) < 0.001 && Math.abs(at.getTranslateY()) < 0.001;
    }

    private void paintInvalidScreen(Graphics atGraphics, AffineTransform at) {
        Color c = GraphUtil.getRicePaperColor();
        atGraphics.setColor(c);
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        atGraphics.fillRect(x - 1, y - 1, this.getWidth(), this.getHeight());
        boolean debug = false;
        logger.finest(" using cacheImage with ricepaper to invalidate");
    }

    private void resetCacheImageBounds(boolean printing) {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        if (this.overSize && !printing) {
            this.cacheImageBounds = new Rectangle();
            this.cacheImageBounds.width = 16 * this.getWidth() / 10;
            this.cacheImageBounds.height = this.getHeight();
            this.cacheImageBounds.x = x - 3 * this.getWidth() / 10;
            this.cacheImageBounds.y = y - 1;
        } else {
            this.cacheImageBounds = new Rectangle();
            this.cacheImageBounds.width = this.getWidth();
            this.cacheImageBounds.height = this.getHeight();
            this.cacheImage = new BufferedImage(this.cacheImageBounds.width, this.cacheImageBounds.height, 6);
            this.cacheImageBounds.x = x - 1;
            this.cacheImageBounds.y = y - 1;
        }
    }

    protected void printComponent(Graphics g) {
        this.resetCacheImageBounds(true);
        List<Renderer> renderers1 = Arrays.asList(this.getRenderers());
        for (int i = 0; i < renderers1.size(); ++i) {
            Renderer rend = renderers1.get(i);
            if (!rend.isActive()) continue;
            logger.log(Level.FINEST, "updating renderer #{0}: {1}", new Object[]{i, rend});
            try {
                rend.updatePlotImage(this.xAxis, this.yAxis, (ProgressMonitor)new NullProgressMonitor());
                continue;
            }
            catch (DasException ex) {
                Logger.getLogger(DasPlot.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        super.printComponent(g);
        this.invalidateCacheImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void paintComponent(Graphics graphics0) {
        Object atGraphics;
        boolean useCacheImage;
        Shape saveClip;
        if (this.getCanvas().isValueAdjusting()) {
            this.repaint();
            return;
        }
        if (!this.getCanvas().isPrintingThread() && !EventQueue.isDispatchThread()) {
            throw new RuntimeException("not event thread: " + Thread.currentThread().getName());
        }
        logger.finest("entering DasPlot.paintComponent");
        if (this.getCanvas().isPrintingThread()) {
            logger.fine("* printing thread *");
        }
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int xSize = this.getColumn().getDMaximum() - x;
        int ySize = this.getRow().getDMaximum() - y;
        if (this.getCanvas().isPrintingThread()) {
            saveClip = graphics0.getClip();
            graphics0.setClip(null);
        } else {
            saveClip = null;
        }
        logger.log(Level.FINEST, "DasPlot clip={0} @ {1},{2}", new Object[]{graphics0.getClip(), this.getX(), this.getY()});
        Rectangle clip = graphics0.getClipBounds();
        if (clip != null && clip.y + this.getY() >= y + ySize) {
            logger.finer("returning because clip indicates nothing to be done.");
            return;
        }
        boolean disableImageCache = false;
        Graphics2D graphics = (Graphics2D)graphics0.create();
        Rectangle clip0 = graphics.getClipBounds();
        Rectangle plotClip = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
        plotClip.height += 2;
        plotClip.height += this.titleHeight;
        plotClip.width += 2;
        plotClip.translate(-x, -y);
        if (clip != null) {
            plotClip = plotClip.intersection(clip);
        }
        graphics.setClip(plotClip);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(-this.getX(), -this.getY());
        boolean bl = useCacheImage = this.cacheImageValid && !this.getCanvas().isPrintingThread() && !disableImageCache;
        if (useCacheImage) {
            atGraphics = (Graphics2D)graphics.create();
            AffineTransform at = this.getAffineTransform(this.xAxis, this.yAxis);
            if (at == null || !this.preview && !this.isIdentity(at)) {
                ((Graphics)atGraphics).drawImage(this.cacheImage, this.cacheImageBounds.x, this.cacheImageBounds.y, this.cacheImageBounds.width, this.cacheImageBounds.height, this);
                this.paintInvalidScreen((Graphics)atGraphics, at);
            } else {
                String atDesc;
                if (!at.isIdentity()) {
                    atDesc = GraphUtil.getATScaleTranslateString(at);
                    logger.log(Level.FINEST, " using cacheImage w/AT {0}", atDesc);
                    ((Graphics2D)atGraphics).transform(at);
                } else {
                    atDesc = "identity";
                    logger.log(Level.FINEST, " using cacheImage {0} {1} {2}", new Object[]{this.cacheImageBounds, this.xmemento, this.ymemento});
                }
                if (this.cacheImageBounds.width != this.cacheImage.getWidth()) {
                    System.err.println(" cbw: " + this.cacheImageBounds.width + "  ciw:" + this.cacheImage.getWidth());
                }
                ((Graphics)atGraphics).drawImage(this.cacheImage, this.cacheImageBounds.x, this.cacheImageBounds.y, this.cacheImageBounds.width, this.cacheImageBounds.height, this);
            }
            ((Graphics)atGraphics).dispose();
        } else {
            atGraphics = this;
            synchronized (atGraphics) {
                Graphics2D plotGraphics;
                if (this.getCanvas().isPrintingThread() || disableImageCache) {
                    plotGraphics = (Graphics2D)graphics.create(x - 1, y - 1, xSize + 2, ySize + 2);
                    this.resetCacheImageBounds(true);
                    logger.finest(" printing thread, drawing");
                } else {
                    this.resetCacheImageBounds(false);
                    this.cacheImage = new BufferedImage(this.cacheImageBounds.width, this.cacheImageBounds.height, 6);
                    plotGraphics = (Graphics2D)this.cacheImage.getGraphics();
                    plotGraphics.setBackground(this.getBackground());
                    plotGraphics.setColor(this.getForeground());
                    plotGraphics.setRenderingHints(DasProperties.getRenderingHints());
                    if (this.overSize) {
                        plotGraphics.translate(x - this.cacheImageBounds.x - 1, y - this.cacheImageBounds.y - 1);
                    }
                    logger.finest(" rebuilding cacheImage");
                }
                plotGraphics.translate(-x + 1, -y + 1);
                Renderer[] rends = this.getRenderers();
                if (rends.length > 0) {
                    DasAxis.Memento xmem = this.getXAxis().getMemento();
                    DasAxis.Memento ymem = this.getYAxis().getMemento();
                    for (Renderer r : rends) {
                        boolean dirt = false;
                        if (r.getXmemento() == null || !r.getXmemento().equals(xmem)) {
                            dirt = true;
                        }
                        if (r.getYmemento() == null || !r.getYmemento().equals(ymem)) {
                            dirt = true;
                        }
                        if (!dirt) continue;
                        try {
                            r.updatePlotImage(this.getXAxis(), this.getYAxis(), (ProgressMonitor)new NullProgressMonitor());
                        }
                        catch (DasException ex) {
                            Logger.getLogger(DasPlot.class.getName()).log(Level.SEVERE, null, ex);
                            ex.printStackTrace();
                        }
                        dirt = false;
                    }
                }
                this.drawCacheImage(plotGraphics);
            }
            if (!disableImageCache && !this.getCanvas().isPrintingThread()) {
                this.cacheImageValid = true;
                graphics.drawImage(this.cacheImage, this.cacheImageBounds.x, this.cacheImageBounds.y, this.cacheImageBounds.width, this.cacheImageBounds.height, this);
                this.xmemento = this.xAxis.getMemento();
                this.ymemento = this.yAxis.getMemento();
                logger.log(Level.FINEST, "recalc cacheImage, xmemento={0} ymemento={1}", new Object[]{this.xmemento, this.ymemento});
            }
        }
        graphics.setColor(this.getForeground());
        graphics.drawRect(x - 1, y - 1, xSize + 1, ySize + 1);
        if (clip0 != null) {
            clip0.translate(this.getX(), this.getY());
        }
        graphics.setClip(clip0);
        if (this.plotTitle != null && this.plotTitle.length() != 0) {
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setAlignment(1);
            gtr.setString((Graphics)graphics, this.plotTitle);
            int titleWidth = (int)gtr.getWidth();
            int titleX = x + (xSize - titleWidth) / 2;
            int titleY = y - (int)gtr.getDescent() - (int)gtr.getAscent() / 2;
            gtr.draw((Graphics)graphics, (float)titleX, (float)titleY);
        }
        graphics.setClip(null);
        Font font0 = graphics.getFont();
        if (this.messages.size() > 0) {
            this.drawMessages(graphics);
        }
        if (this.legendElements.size() > 0) {
            this.drawLegend(graphics);
        }
        graphics.dispose();
        this.getDasMouseInputAdapter().paint(graphics0);
        if (saveClip != null) {
            graphics0.setClip(saveClip);
        }
    }

    public void setEnableRenderPropertiesAction(boolean b) {
        if (b) {
            this.editRendererMenuItem = new JMenuItem(this.getEditAction());
            this.getDasMouseInputAdapter().addMenuItem(this.editRendererMenuItem);
        } else {
            if (this.editRendererMenuItem != null) {
                this.getDasMouseInputAdapter().removeMenuItem(this.editRendererMenuItem.getText());
            }
            this.editRendererMenuItem = null;
        }
    }

    private boolean isEnableRenderPropertiesAction() {
        return this.editRendererMenuItem != null;
    }

    public void postMessage(Renderer renderer, String message, int messageType, Datum x, Datum y) {
        if (this.messages != null) {
            this.messages.add(new MessageDescriptor(renderer, message, messageType, x, y));
        }
    }

    public void postException(Renderer renderer, Exception exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = String.valueOf(exception);
        }
        int errorLevel = 2;
        if (exception instanceof CancelledOperationException) {
            errorLevel = 0;
            if (exception.getMessage() == null) {
                message = "Operation Cancelled";
            }
        }
        this.postMessage(renderer, message, errorLevel, null, null);
    }

    public void addToLegend(Renderer renderer, ImageIcon icon, int pos, String message) {
        this.legendElements.add(new LegendElement(icon, renderer, message));
    }

    private void drawGrid(Graphics2D g, DatumVector xticks, DatumVector yticks) {
        int i;
        int xmin = this.cacheImageBounds.x;
        int xmax = this.cacheImageBounds.x + this.cacheImageBounds.width;
        int ymin = this.cacheImageBounds.y;
        int ymax = this.cacheImageBounds.y + this.cacheImageBounds.height;
        if (yticks != null && yticks.getUnits().isConvertableTo(this.yAxis.getUnits())) {
            for (i = 0; i < yticks.getLength(); ++i) {
                int y = (int)this.yAxis.transform(yticks.get(i));
                g.drawLine(xmin, y, xmax, y);
            }
        }
        if (xticks != null && xticks.getUnits().isConvertableTo(this.xAxis.getUnits())) {
            for (i = 0; i < xticks.getLength(); ++i) {
                int x = (int)this.xAxis.transform(xticks.get(i));
                g.drawLine(x, ymin, x, ymax);
            }
        }
    }

    protected void drawContent(Graphics2D g) {
    }

    public void resize() {
        logger.finer("resize DasPlot");
        if (this.isDisplayable()) {
            Rectangle oldBounds = this.getBounds();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(this.getFont(), this.getTitle());
            this.titleHeight = (int)gtr.getHeight() + (int)gtr.getAscent() / 2;
            Rectangle legendBounds = this.getLegendBounds((Graphics2D)this.getGraphics(), 0, 0);
            Rectangle bounds = new Rectangle();
            bounds.x = this.getColumn().getDMinimum() - 1;
            bounds.y = this.getRow().getDMinimum() - 1;
            bounds.width = this.getColumn().getDMaximum() - bounds.x + 1;
            bounds.height = this.getRow().getDMaximum() - bounds.y + 1;
            if (!this.getTitle().equals("")) {
                bounds.y -= this.titleHeight;
                bounds.height += this.titleHeight;
            }
            if (legendBounds != null) {
                bounds.add(legendBounds);
            }
            logger.log(Level.FINER, "DasPlot setBounds {0}", bounds);
            if (!bounds.equals(oldBounds)) {
                this.setBounds(bounds);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        List<Renderer> renderers1 = Arrays.asList(DasPlot.this.getRenderers());
                        for (int i = 0; i < renderers1.size(); ++i) {
                            renderers1.get(i).refresh();
                        }
                        DasPlot.this.invalidateCacheImage();
                    }
                });
            }
        }
    }

    public void setTitle(String t) {
        String oldValue = this.plotTitle;
        this.plotTitle = t;
        if (t == null) {
            t = "";
        }
        if (this.getCanvas() != null) {
            FontMetrics fm = this.getFontMetrics(this.getCanvas().getFont());
            this.titleHeight = fm.getHeight() + fm.getHeight() / 2;
            this.resize();
            this.invalidateCacheImage();
        }
        if (!t.equals(oldValue)) {
            this.firePropertyChange(PROP_TITLE, oldValue, t);
        }
    }

    public String getTitle() {
        return this.plotTitle;
    }

    public DatumRange getContext() {
        return this.context;
    }

    public void setContext(DatumRange context) {
        DatumRange old = this.context;
        this.context = context;
        this.firePropertyChange(PROP_CONTEXT, old, context);
    }

    public DasAxis getXAxis() {
        return this.xAxis;
    }

    public DasAxis getYAxis() {
        return this.yAxis;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dataSetDescriptor;
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dataSetDescriptor = dataSetDescriptor;
        this.markDirty();
    }

    protected void installComponent() {
        super.installComponent();
        if (this.xAxis != null) {
            this.getCanvas().add(this.xAxis, this.getRow(), this.getColumn());
        }
        if (this.yAxis != null) {
            this.getCanvas().add(this.yAxis, this.getRow(), this.getColumn());
        }
        Renderer[] r = this.getRenderers();
        for (int index = 0; index < r.length; ++index) {
            r[index].installRenderer();
        }
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
        if (this.xAxis != null && this.xAxis.getCanvas() != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null && this.yAxis.getCanvas() != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        Renderer[] r = this.getRenderers();
        for (int index = 0; index < r.length; ++index) {
            r[index].uninstallRenderer();
        }
    }

    public void addRenderer(Renderer rend) {
        logger.log(Level.FINE, "addRenderer({0})", rend);
        if (rend.parent != null) {
            rend.parent.removeRenderer(rend);
        }
        this.renderers.add(rend);
        rend.parent = this;
        if (this.getCanvas() != null) {
            rend.installRenderer();
        }
        rend.update();
        this.invalidateCacheImage();
    }

    public void addRenderer(int index, Renderer rend) {
        logger.log(Level.FINE, "addRenderer({0},{1})", new Object[]{index, rend});
        if (rend.parent != null) {
            rend.parent.removeRenderer(rend);
        }
        this.renderers.add(index, rend);
        rend.parent = this;
        if (this.getCanvas() != null) {
            rend.installRenderer();
        }
        rend.update();
        this.invalidateCacheImage();
    }

    public void removeRenderer(Renderer rend) {
        logger.log(Level.FINE, "removeRenderer({0})", new Object[]{rend});
        if (this.getCanvas() != null) {
            rend.uninstallRenderer();
        }
        if (this.focusRenderer == rend) {
            this.setFocusRenderer(null);
        }
        this.renderers.remove(rend);
        rend.parent = null;
        this.invalidateCacheImage();
    }

    public synchronized void removeRenderers() {
        if (this.getCanvas() != null) {
            for (Renderer rend : this.renderers) {
                rend.uninstallRenderer();
                rend.parent = null;
            }
            this.setFocusRenderer(null);
            this.renderers.clear();
        }
        this.invalidateCacheImage();
    }

    public static DasPlot createDummyPlot() {
        DasAxis xAxis = new DasAxis(Datum.create((int)-10), Datum.create((int)10), 2);
        DasAxis yAxis = new DasAxis(Datum.create((int)-10), Datum.create((int)10), 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public static DasPlot createPlot(DatumRange xrange, DatumRange yrange) {
        DasAxis xAxis = new DasAxis(xrange, 2);
        DasAxis yAxis = new DasAxis(yrange, 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public synchronized Renderer getRenderer(int index) {
        return this.renderers.get(index);
    }

    public synchronized Renderer[] getRenderers() {
        return this.renderers.toArray(new Renderer[this.renderers.size()]);
    }

    public Shape getActiveRegion() {
        return this.getBounds();
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (existingEvent instanceof DasRendererUpdateEvent && newEvent instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent e1 = (DasRendererUpdateEvent)existingEvent;
            DasRendererUpdateEvent e2 = (DasRendererUpdateEvent)newEvent;
            if (e1.getRenderer() == e2.getRenderer()) {
                return existingEvent;
            }
            return null;
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent drue = (DasRendererUpdateEvent)e;
            drue.getRenderer().updateImmediately();
            this.cacheImageValid = false;
            this.repaint();
        } else {
            super.processEvent(e);
        }
    }

    public void repaint() {
        super.repaint();
    }

    protected synchronized void invalidateCacheImage() {
        if (!this.cacheImageValid) {
            return;
        }
        this.cacheImageValid = false;
        this.repaint();
    }

    void markDirty() {
        logger.finer("DasPlot.markDirty");
        super.markDirty();
        this.repaint();
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(LegendPosition newlegendPosition) {
        LegendPosition oldlegendPosition = this.legendPosition;
        this.legendPosition = newlegendPosition;
        this.firePropertyChange(PROP_LEGENDPOSITION, oldlegendPosition, newlegendPosition);
        this.resize();
        this.repaint();
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        boolean bOld = this.drawGrid;
        this.drawGrid = drawGrid;
        this.invalidateCacheImage();
        this.repaint();
        if (bOld != drawGrid) {
            this.firePropertyChange(PROP_DRAWGRID, bOld, drawGrid);
        }
    }

    public boolean isDrawMinorGrid() {
        return this.drawMinorGrid;
    }

    public void setDrawMinorGrid(boolean newdrawMinorGrid) {
        boolean olddrawMinorGrid = this.drawMinorGrid;
        this.drawMinorGrid = newdrawMinorGrid;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_DRAWMINORGRID, olddrawMinorGrid, newdrawMinorGrid);
    }

    public boolean isGridOver() {
        return this.gridOver;
    }

    public void setGridOver(boolean gridOver) {
        boolean oldGridOver = this.gridOver;
        this.gridOver = gridOver;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_GRIDOVER, oldGridOver, gridOver);
    }

    public void setPreviewEnabled(boolean preview) {
        this.preview = preview;
    }

    public boolean isPreviewEnabled() {
        return this.preview;
    }

    public void setAxisPlotVisible(boolean visible) {
        this.setVisible(visible);
        this.xAxis.setVisible(visible);
        this.yAxis.setVisible(visible);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public boolean isOverSize() {
        return this.overSize;
    }

    public void setOverSize(boolean overSize) {
        boolean oldOverSize = this.overSize;
        this.overSize = overSize;
        this.invalidateCacheImage();
        this.firePropertyChange(PROP_OVERSIZE, oldOverSize, overSize);
    }

    protected Rectangle getUpdateImageBounds() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        this.cacheImageBounds = new Rectangle();
        if (this.overSize) {
            this.cacheImageBounds.width = 16 * this.getWidth() / 10;
            this.cacheImageBounds.height = this.getHeight();
            this.cacheImageBounds.x = x - 3 * this.getWidth() / 10;
        } else {
            this.cacheImageBounds.width = this.getWidth();
            this.cacheImageBounds.height = this.getHeight();
            this.cacheImageBounds.x = x - 1;
        }
        this.cacheImageBounds.y = y - 1;
        return this.cacheImageBounds;
    }

    protected Rectangle getCacheImageBounds() {
        return this.cacheImageBounds;
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport parent) {
            super((Component)DasPlot.this, 3, parent);
        }

        public void drop(DropTargetDropEvent dtde) {
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(TransferableRenderer.RENDERER_FLAVOR)) continue;
                return action;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                Renderer r = (Renderer)t.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                DasPlot.this.addRenderer(r);
                DasPlot.this.revalidate();
                success = true;
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return success;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            logger.log(Level.FINE, "rebin listener got property change: {0}", e.getNewValue());
            DasPlot.this.markDirty();
            DasPlot.this.update();
        }
    }

    private class LegendElement {
        ImageIcon icon;
        Renderer renderer;
        String label;
        Rectangle bounds;

        LegendElement(ImageIcon icon, Renderer rend, String label) {
            this.icon = icon;
            this.renderer = rend;
            this.label = label;
        }

        protected void drawIcon(Graphics2D graphics, int x, int y) {
            this.renderer.drawListIcon(graphics, x, y);
        }
    }

    private class MessageDescriptor {
        Renderer renderer;
        String text;
        int messageType;
        Datum x;
        Datum y;
        Rectangle bounds;

        MessageDescriptor(Renderer renderer, String text, int messageType, Datum x, Datum y) {
            this.renderer = renderer;
            this.text = text;
            this.messageType = messageType;
            this.x = x;
            this.y = y;
        }
    }
}

