/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;

public class ImageVectorDataSetRenderer
extends Renderer {
    BufferedImage plotImage;
    Rectangle plotImageBounds;
    DatumRange imageXRange;
    DatumRange imageYRange;
    private Color color = Color.BLACK;
    private int ixstepLimitSq = 1000000;
    private Shape selectionArea;
    int saturationHitCount = 5;
    protected int envelope = 0;
    public static final String PROP_ENVELOPE = "envelope";
    private boolean print300dpi;

    public ImageVectorDataSetRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)i.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.parent != null) {
            g.setBackground(this.parent.getBackground());
        }
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        g.setStroke(new BasicStroke(0.5f));
        g.drawLine(2, 3, 13, 7);
        g.setStroke(stroke0);
        i.setRGB(7, 5, this.color.getRGB());
        return new ImageIcon(i);
    }

    public synchronized void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        if (this.ds == null) {
            this.parent.postMessage(this, "no data set", 0, null, null);
            return;
        }
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)this.ds);
        QDataSet vds = this.ds.rank() == 2 && SemanticOps.isBundle((QDataSet)this.ds) ? DataSetOps.unbundleDefaultDataSet((QDataSet)this.ds) : this.ds;
        if (!xAxis.getUnits().isConvertableTo(SemanticOps.getUnits((QDataSet)xds))) {
            this.parent.postMessage(this, "inconvertible xaxis units", 0, null, null);
            return;
        }
        if (!yAxis.getUnits().isConvertableTo(SemanticOps.getUnits((QDataSet)vds))) {
            this.parent.postMessage(this, "inconvertible yaxis units", 0, null, null);
            return;
        }
        Graphics2D g2 = (Graphics2D)g1;
        if (this.plotImage == null) {
            if (this.lastException != null) {
                if (this.lastException instanceof NoDataInIntervalException) {
                    this.parent.postMessage(this, "no data in interval:!c" + this.lastException.getMessage(), 1, null, null);
                } else {
                    this.parent.postException(this, this.lastException);
                }
            } else if (this.getDataSet() == null) {
                this.parent.postMessage(this, "no data set", 0, null, null);
            } else if (this.getDataSet().length() == 0) {
                this.parent.postMessage(this, "empty data set", 0, null, null);
            }
        } else if (this.plotImage != null) {
            Point2D.Float p = new Point2D.Float(this.plotImageBounds.x, this.plotImageBounds.y);
            int x = (int)(((Point2D)p).getX() + 0.5);
            int y = (int)(((Point2D)p).getY() + 0.5);
            if (this.parent.getCanvas().isPrintingThread() && this.print300dpi) {
                AffineTransform atinv;
                AffineTransformOp atop = new AffineTransformOp(AffineTransform.getScaleInstance(4.0, 4.0), 1);
                BufferedImage image300 = atop.filter(this.plotImage, null);
                try {
                    atinv = atop.getTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex);
                }
                atinv.translate(x * 4, y * 4);
                g2.drawImage(image300, atinv, this.getParent());
            } else {
                g2.drawImage((Image)this.plotImage, x, y, this.getParent());
            }
        }
    }

    private void ghostlyImage2(DasAxis xAxis, DasAxis yAxis, QDataSet ds, Rectangle plotImageBounds2) {
        int ny = plotImageBounds2.height;
        int nx = plotImageBounds2.width;
        logger.fine("create Image");
        BufferedImage image = new BufferedImage(nx, ny, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(1.0f / (float)this.saturationHitCount));
        g.translate(-plotImageBounds2.x, -plotImageBounds2.y);
        DatumRange visibleRange = this.imageXRange = GraphUtil.invTransformRange(xAxis, plotImageBounds2.x, plotImageBounds2.x + plotImageBounds2.width);
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        QDataSet vds = ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds) ? DataSetOps.unbundleDefaultDataSet((QDataSet)ds) : ds;
        boolean xmono = Boolean.TRUE == SemanticOps.isMonotonic((QDataSet)xds);
        int firstIndex = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min()) : 0;
        int lastIndex = xmono ? DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1 : xds.length();
        int STATE_LINETO = -991;
        int STATE_MOVETO = -992;
        int state = -992;
        int ix0 = 0;
        int iy0 = 0;
        if (vds.length() > 0) {
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)vds);
            Units dsunits = SemanticOps.getUnits((QDataSet)vds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            for (int i = firstIndex; i < lastIndex; ++i) {
                boolean isValid;
                boolean bl = isValid = wds.value(i) > 0.0;
                if (!isValid) {
                    state = -992;
                    continue;
                }
                int iy = (int)yAxis.transform(vds.value(i), dsunits);
                int ix = (int)xAxis.transform(xds.value(i), xunits);
                if ((ix - ix0) * (ix - ix0) > this.ixstepLimitSq) {
                    state = -992;
                }
                switch (state) {
                    case -992: {
                        g.fillRect(ix, iy, 1, 1);
                        ix0 = ix;
                        iy0 = iy;
                        break;
                    }
                    case -991: {
                        g.draw(new Line2D.Float(ix0, iy0, ix, iy));
                        g.fillRect(ix, iy, 1, 1);
                        ix0 = ix;
                        iy0 = iy;
                    }
                }
                state = -991;
            }
        }
        logger.fine("done");
        this.plotImage = image;
        this.selectionArea = null;
    }

    private QDataSet histogram(RebinDescriptor ddx, RebinDescriptor ddy, QDataSet ds) {
        ddx.setOutOfBoundsAction(-3);
        ddy.setOutOfBoundsAction(-3);
        FDataSet tds = FDataSet.createRank2((int)ddx.numberOfBins(), (int)ddy.numberOfBins());
        if (ds.length() > 0) {
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
            QDataSet vds = ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds) ? DataSetOps.unbundleDefaultDataSet((QDataSet)ds) : ds;
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Units yunits = SemanticOps.getUnits((QDataSet)vds);
            boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
            int firstIndex = xmono ? DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)ddx.binStart(0)) : 0;
            int lastIndex = xmono ? DataSetUtil.getNextIndex((QDataSet)xds, (Datum)ddx.binStop(ddx.numberOfBins() - 1)) : vds.length() - 1;
            int n = lastIndex;
            for (int i = firstIndex; i <= n; ++i) {
                boolean isValid;
                boolean bl = isValid = wds.value(i) > 0.0;
                if (!isValid) continue;
                int ix = ddx.whichBin(xds.value(i), xunits);
                int iy = ddy.whichBin(vds.value(i), yunits);
                if (ix == -1 || iy == -1) continue;
                double d = tds.value(ix, iy);
                tds.putValue(ix, iy, d + 1.0);
            }
        }
        return tds;
    }

    private void ghostlyImage(DasAxis xAxis, DasAxis yAxis, QDataSet ds, Rectangle plotImageBounds2) {
        DatumRange xrange = new DatumRange(xAxis.invTransform(plotImageBounds2.x), xAxis.invTransform(plotImageBounds2.x + plotImageBounds2.width));
        DatumRange yrange = new DatumRange(yAxis.invTransform(plotImageBounds2.y + plotImageBounds2.height), yAxis.invTransform(plotImageBounds2.y));
        RebinDescriptor ddx = new RebinDescriptor(xrange.min(), xrange.max(), plotImageBounds2.width, xAxis.isLog());
        RebinDescriptor ddy = new RebinDescriptor(yrange.min(), yrange.max(), plotImageBounds2.height, yAxis.isLog());
        QDataSet newHist = this.histogram(ddx, ddy, ds);
        int h = ddy.numberOfBins();
        int w = ddx.numberOfBins();
        int[] raster = new int[h * w];
        int colorInt = this.color.getRGB() & 0xFFFFFF;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
        int envelopeColor = Integer.MIN_VALUE | colorInt;
        if (this.envelope == 1) {
            envelopeColor = 128 / this.saturationHitCount << 24 | colorInt;
        }
        for (int i = 0; i < w; ++i) {
            int j;
            int ymin = -1;
            int ymax = -1;
            for (j = 0; j < h; ++j) {
                if (!(newHist.value(i, j) > 0.0)) continue;
                if (ymin < 0) {
                    ymin = j;
                }
                ymax = j;
            }
            if (ymin < 0) continue;
            for (j = ymin; j <= ymax; ++j) {
                int index = i + (h - j - 1) * w;
                if (!xmono || this.envelope != 2 && (this.envelope == 0 || newHist.value(i, j) > 0.0)) {
                    int alpha = 255 * (int)newHist.value(i, j) / this.saturationHitCount;
                    if (alpha > 255) {
                        alpha = 255;
                    }
                    raster[index] = alpha << 24 | colorInt;
                    continue;
                }
                raster[index] = envelopeColor;
            }
        }
        this.plotImage = new BufferedImage(w, h, 2);
        this.selectionArea = null;
        WritableRaster r = this.plotImage.getRaster();
        r.setDataElements(0, 0, w, h, raster);
        this.imageXRange = xrange;
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        int lastIndex;
        int firstIndex;
        super.updatePlotImage(xAxis, yAxis, monitor);
        QDataSet ds1 = this.getDataSet();
        if (ds1 == null) {
            return;
        }
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)this.ds);
        if (!xAxis.getUnits().isConvertableTo(SemanticOps.getUnits((QDataSet)xds))) {
            this.parent.postMessage(this, "inconvertible xaxis units", 0, null, null);
            return;
        }
        if (!yAxis.getUnits().isConvertableTo(SemanticOps.getUnits((QDataSet)ds1))) {
            this.parent.postMessage(this, "inconvertible yaxis units", 0, null, null);
            return;
        }
        this.plotImageBounds = this.parent.getCacheImageBounds();
        if (this.plotImageBounds == null) {
            return;
        }
        DatumRange visibleRange = xAxis.getDatumRange();
        boolean xmono = SemanticOps.isMonotonic((QDataSet)xds);
        if (xmono) {
            firstIndex = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
            lastIndex = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max());
            if (xAxis.isLog()) {
                this.ixstepLimitSq = 100000000;
            } else {
                RankZeroDataSet d = DataSetUtil.guessCadenceNew((QDataSet)xds, (QDataSet)ds1);
                if (d != null) {
                    Datum sw = DataSetUtil.asDatum((RankZeroDataSet)d);
                    Datum xmax = xAxis.getDataMaximum();
                    int ixstepLimit = 0;
                    ixstepLimit = UnitsUtil.isRatiometric((Units)sw.getUnits()) ? 1 + (int)(xAxis.transform(xmax) - xAxis.transform(xmax.divide(sw))) : 1 + (int)(xAxis.transform(xmax) - xAxis.transform(xmax.subtract(sw)));
                    this.ixstepLimitSq = ixstepLimit * ixstepLimit;
                } else {
                    this.ixstepLimitSq = 100000000;
                }
            }
        } else {
            firstIndex = 0;
            lastIndex = ds1.length();
            this.ixstepLimitSq = 100000000;
        }
        if (lastIndex - firstIndex > 20 * xAxis.getColumn().getWidth()) {
            logger.fine("rendering with histogram");
            this.ghostlyImage(xAxis, yAxis, ds1, this.plotImageBounds);
        } else {
            logger.fine("rendinging with lines");
            this.ghostlyImage2(xAxis, yAxis, ds1, this.plotImageBounds);
        }
        logger.fine("done updatePlotImage");
    }

    public void setSaturationHitCount(int d) {
        if (d > 10) {
            d = 10;
        }
        this.saturationHitCount = d;
        this.update();
    }

    public int getSaturationHitCount() {
        return this.saturationHitCount;
    }

    public void setColor(Color color) {
        this.color = color;
        this.refreshImage();
    }

    public Color getColor() {
        return this.color;
    }

    public int getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(int envelope) {
        int oldEnvelope = this.envelope;
        this.envelope = envelope;
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange(PROP_ENVELOPE, oldEnvelope, envelope);
    }

    public boolean acceptContext(int x, int y) {
        if (this.plotImage == null) {
            return false;
        }
        Shape s = this.selectionArea();
        return s.contains(x, y);
    }

    public boolean isPrint300dpi() {
        return this.print300dpi;
    }

    public void setPrint300dpi(boolean print300dpi) {
        this.print300dpi = print300dpi;
    }

    private void calcSelectionArea() {
        BufferedImage plotImage = this.plotImage;
        if (plotImage == null) {
            return;
        }
        int w = plotImage.getWidth();
        int h = plotImage.getHeight();
        int imagex = (int)this.parent.getCacheImageBounds().getX();
        int imagey = (int)this.parent.getCacheImageBounds().getY();
        GeneralPath result = new GeneralPath();
        for (int i = 0; i < w; i += 5) {
            for (int j = 0; j < h; j += 5) {
                int n = 0;
                int x = 0;
                int y = 0;
                for (int ii = 0; ii < 10; ++ii) {
                    for (int jj = 0; jj < 10; ++jj) {
                        if (i + ii >= w || j + jj >= h || (plotImage.getRGB(i + ii, j + jj) & 0xFF000000) == 0) continue;
                        ++n;
                        x += ii;
                        y += jj;
                    }
                }
                if (n <= 0) continue;
                result.append(new Rectangle((int)((float)i + (float)x / (float)n + (float)imagex - 5.0f), (int)((float)j + (float)y / (float)n + (float)imagey - 5.0f), 10, 10), true);
            }
        }
        this.selectionArea = result;
    }

    Shape selectionArea() {
        if (this.selectionArea == null) {
            this.calcSelectionArea();
        }
        return this.selectionArea;
    }
}

