/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class RGBImageRenderer
extends Renderer {
    BufferedImage image = null;

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        QDataSet ds = this.getDataSet();
        if (ds == null || ds.length() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        BufferedImage im = this.image;
        if (im == null) {
            return;
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep0 == null) {
            dep0 = Ops.dindgen((int)im.getWidth());
        }
        if (dep1 == null) {
            dep1 = Ops.dindgen((int)im.getHeight());
        }
        Units xunits = SemanticOps.getUnits((QDataSet)dep0);
        Units yunits = SemanticOps.getUnits((QDataSet)dep1);
        int h = im.getHeight();
        int w = im.getWidth();
        double dx0 = dep0.value(1) - dep0.value(0);
        double dy0 = dep1.value(1) - dep1.value(0);
        int x0 = (int)xAxis.transform(dep0.value(0) - dx0 / 2.0, xunits);
        int y0 = (int)yAxis.transform(dep1.value(0) - dy0 / 2.0, yunits);
        int x1 = (int)xAxis.transform(dep0.value(w - 1) + dx0 / 2.0, xunits);
        int y1 = (int)yAxis.transform(dep1.value(h - 1) + dy0 / 2.0, yunits);
        g.drawImage(im, x0, y0, x1 - x0, y1 - y0, null);
    }

    public void setDataSet(QDataSet ds) {
        super.setDataSet(ds);
        this.image = ds == null ? null : this.getImage(ds);
        this.refresh();
    }

    private BufferedImage getImage(QDataSet ds) throws IllegalArgumentException {
        BufferedImage im;
        block25: {
            int h;
            int w;
            block24: {
                int imageType = -19999;
                w = 0;
                h = 0;
                w = ds.length();
                h = ds.length(0);
                if (ds.rank() == 2) {
                    imageType = 10;
                } else if (ds.rank() == 3) {
                    String s2;
                    String s1;
                    String s0;
                    QDataSet dep2;
                    if (ds.length(0, 0) == 3) {
                        dep2 = (QDataSet)ds.property("DEPEND_2");
                        imageType = 1;
                        if (dep2 != null) {
                            s0 = DataSetUtil.asDatum((QDataSet)dep2.slice(0)).toString().toLowerCase();
                            s1 = DataSetUtil.asDatum((QDataSet)dep2.slice(1)).toString().toLowerCase();
                            s2 = DataSetUtil.asDatum((QDataSet)dep2.slice(2)).toString().toLowerCase();
                            if (s0.startsWith("r") && s1.startsWith("g") && s2.startsWith("b")) {
                                imageType = 1;
                            } else if (s0.startsWith("b") && s1.startsWith("g") && s2.startsWith("r")) {
                                imageType = 4;
                            }
                        }
                    } else if (ds.length(0, 0) == 4) {
                        dep2 = (QDataSet)ds.property("DEPEND_2");
                        imageType = 2;
                        if (dep2 != null) {
                            s0 = DataSetUtil.asDatum((QDataSet)dep2.slice(0)).toString().toLowerCase();
                            s1 = DataSetUtil.asDatum((QDataSet)dep2.slice(1)).toString().toLowerCase();
                            s2 = DataSetUtil.asDatum((QDataSet)dep2.slice(2)).toString().toLowerCase();
                            String s3 = DataSetUtil.asDatum((QDataSet)dep2.slice(3)).toString().toLowerCase();
                            if (s0.startsWith("a") && s1.startsWith("r") && s2.startsWith("g") && s3.startsWith("b")) {
                                imageType = 2;
                            } else if (s0.startsWith("a") && s1.startsWith("b") && s2.startsWith("g") && s3.startsWith("r")) {
                                imageType = 6;
                            }
                        }
                    }
                } else {
                    throw new IllegalArgumentException("DataSet must be rank 2 or rank 3: " + ds);
                }
                if (imageType == -19999) {
                    throw new IllegalArgumentException("DataSet must be ds[w,h] ds[w,h,3] or ds[w,h,4] and be RGB, BGR, or ARGB.  Default is RBG");
                }
                im = new BufferedImage(w, h, imageType);
                if (ds.rank() != 2) break block24;
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < h; ++j) {
                        im.setRGB(i, j, 65536 * (int)ds.value(i, j) + 256 * (int)ds.value(i, j) + (int)ds.value(i, j));
                    }
                }
                break block25;
            }
            if (ds.rank() != 3) break block25;
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int v;
                    if (ds.length(0, 0) == 4) {
                        v = 0x1000000 * (int)ds.value(i, j, 0) + 65536 * (int)ds.value(i, j, 1) + 256 * (int)ds.value(i, j, 2) + (int)ds.value(i, j, 3);
                    } else if (ds.length(0, 0) == 3) {
                        v = 65536 * (int)ds.value(i, j, 0) + 256 * (int)ds.value(i, j, 1) + (int)ds.value(i, j, 2);
                    } else {
                        throw new IllegalArgumentException("ds.length=" + ds.length());
                    }
                    im.setRGB(i, j, v);
                }
            }
        }
        return im;
    }

    public static QDataSet doAutorange(QDataSet ds) {
        DDataSet yrange;
        DDataSet xrange;
        if (ds.rank() == 2) {
            xrange = DDataSet.wrap((double[])new double[]{0.0, ds.length()});
            yrange = DDataSet.wrap((double[])new double[]{0.0, ds.length(0)});
        } else if (ds.rank() == 3) {
            xrange = DDataSet.wrap((double[])new double[]{0.0, ds.length()});
            yrange = DDataSet.wrap((double[])new double[]{0.0, ds.length(0)});
        } else {
            throw new IllegalArgumentException("dataset should be rank 2 or rank 3: " + ds);
        }
        JoinDataSet bds = new JoinDataSet(2);
        bds.join((QDataSet)xrange);
        bds.join((QDataSet)yrange);
        return bds;
    }
}

