/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.components.VerticalSpectrogramAverager;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.HorizontalDragRangeSelectorMouseModule;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;

public class SpectrogramRenderer
extends Renderer
implements TableDataSetConsumer,
Displayable {
    private final Object lockObject = new Object();
    private DasColorBar colorBar;
    private Image plotImage;
    private Rectangle plotImageBounds;
    private byte[] raster;
    private int rasterWidth;
    private int rasterHeight;
    private int validCount;
    DatumRange imageXRange;
    DatumRange imageYRange;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    DasAxis.Memento cmemento;
    int updateImageCount = 0;
    int renderCount = 0;
    private QDataSet rebinDataSet;
    private String xrangeWarning = null;
    RebinListener rebinListener = new RebinListener();
    private RebinnerEnum rebinnerEnum;
    int count = 0;
    private boolean sliceRebinnedData = true;
    private boolean print300dpi;
    private Shape selectionArea = null;
    private Color fillColor = Color.GRAY;

    public SpectrogramRenderer(DataSetDescriptor dsd, DasColorBar colorBar) {
        super(dsd);
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
            colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
        }
        this.setRebinner(RebinnerEnum.binAverage);
    }

    public SpectrogramRenderer(DasPlot parent, DataSetDescriptor dsd, DasColorBar colorBar) {
        this(dsd, colorBar);
        this.parent = parent;
    }

    public DasAxis getZAxis() {
        return this.colorBar;
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            this.colorBar.removePropertyChangeListener("fillColor", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = cb;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            this.colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
        }
    }

    private QDataSet bounds(QDataSet ds) {
        return DataSetOps.dependBounds((QDataSet)ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        logger.finer("entering SpectrogramRenderer.render");
        Graphics2D g2 = (Graphics2D)g;
        if (this.parent == null) {
            return;
        }
        ++this.renderCount;
        this.reportCount();
        Object object = this.lockObject;
        synchronized (object) {
            if (this.plotImage == null) {
                if (this.lastException != null) {
                    if (this.lastException instanceof NoDataInIntervalException) {
                        this.parent.postMessage(this, "no data in interval:!c" + this.lastException.getMessage(), 1, null, null);
                    } else {
                        this.parent.postException(this, this.lastException);
                    }
                } else {
                    QDataSet zds = this.getDataSet();
                    QDataSet xds = null;
                    QDataSet yds = null;
                    if (zds == null) {
                        this.parent.postMessage(this, "no data set", 0, null, null);
                    } else {
                        if (zds.rank() == 2) {
                            xds = SemanticOps.xtagsDataSet((QDataSet)zds);
                            yds = SemanticOps.ytagsDataSet((QDataSet)zds);
                        } else if (zds.rank() == 3) {
                            xds = SemanticOps.xtagsDataSet((QDataSet)zds.slice(0));
                            yds = SemanticOps.ytagsDataSet((QDataSet)zds.slice(0));
                        }
                        if (this.getDataSet().length() == 0) {
                            this.parent.postMessage(this, "empty data set", 0, null, null);
                        } else {
                            if (!SemanticOps.getUnits((QDataSet)yds).isConvertableTo(yAxis.getUnits())) {
                                this.parent.postMessage(this, "inconvertible yaxis units", 0, null, null);
                            }
                            if (!SemanticOps.getUnits((QDataSet)xds).isConvertableTo(xAxis.getUnits())) {
                                this.parent.postMessage(this, "inconvertible xaxis units", 0, null, null);
                            }
                            if (!SemanticOps.isTableDataSet((QDataSet)zds)) {
                                if (!SemanticOps.isBundle((QDataSet)zds)) {
                                    this.parent.postMessage(this, "expected table dataset", 0, null, null);
                                    return;
                                }
                                zds = SemanticOps.getDependentDataSet((QDataSet)zds);
                            }
                            if (!SemanticOps.getUnits((QDataSet)zds).isConvertableTo(this.colorBar.getUnits())) {
                                this.parent.postMessage(this, "inconvertible colorbar units", 0, null, null);
                            }
                        }
                    }
                }
            } else if (this.plotImage != null) {
                Point2D.Float p = new Point2D.Float(this.plotImageBounds.x, this.plotImageBounds.y);
                int x = (int)(((Point2D)p).getX() + 0.5);
                int y = (int)(((Point2D)p).getY() + 0.5);
                if (this.parent.getCanvas().isPrintingThread() && this.print300dpi) {
                    AffineTransform atinv;
                    AffineTransformOp atop = new AffineTransformOp(AffineTransform.getScaleInstance(4.0, 4.0), 1);
                    BufferedImage image300 = atop.filter((BufferedImage)this.plotImage, null);
                    try {
                        atinv = atop.getTransform().createInverse();
                    }
                    catch (NoninvertibleTransformException ex) {
                        throw new RuntimeException(ex);
                    }
                    atinv.translate(x * 4, y * 4);
                    g2.drawImage(image300, atinv, this.getParent());
                } else {
                    g2.drawImage(this.plotImage, x, y, this.getParent());
                }
                if (this.validCount == 0) {
                    QDataSet bounds = this.bounds(this.ds);
                    DatumRange xdr = DataSetUtil.asDatumRange((QDataSet)bounds.slice(0), (boolean)true);
                    DatumRange ydr = DataSetUtil.asDatumRange((QDataSet)bounds.slice(1), (boolean)true);
                    if (xAxis.getDatumRange().intersects(xdr) && yAxis.getDatumRange().intersects(ydr)) {
                        this.parent.postMessage(this, "dataset contains no valid data", 0, null, null);
                    } else {
                        this.parent.postMessage(this, "dataset is outside of axis range", 0, null, null);
                    }
                }
                if (this.xrangeWarning != null) {
                    this.parent.postMessage(this, "no data in interval:!c" + this.xrangeWarning, 1, null, null);
                }
            }
        }
    }

    private static byte[] makePixMap(QDataSet rebinData, byte[] pix) {
        logger.fine("converting to pixel map");
        int ny = rebinData.length(0);
        int nx = rebinData.length();
        pix = new byte[nx * ny];
        return pix;
    }

    private static int transformSimpleTableDataSet(QDataSet rebinData, DasColorBar cb, boolean flipY, byte[] pix) {
        if (rebinData.rank() != 2) {
            throw new IllegalArgumentException("rank 2 expected");
        }
        logger.fine("converting to pixel map");
        int ny = rebinData.length(0);
        int nx = rebinData.length();
        Units units = SemanticOps.getUnits((QDataSet)rebinData);
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)rebinData);
        Arrays.fill(pix, (byte)cb.getFillColorIndex());
        int validCount = 0;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                if (!(wds.value(i, j) > 0.0)) continue;
                int index = flipY ? i + j * nx : i - 0 + (ny - j - 1) * nx;
                int icolor = cb.indexColorTransform(rebinData.value(i, j), units);
                pix[index] = (byte)icolor;
                ++validCount;
            }
        }
        if (validCount == 0) {
            logger.fine("dataset contains no valid data");
        }
        return validCount;
    }

    private void reportCount() {
        if (this.updateImageCount % 10 == 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        SpectrogramRenderer.logger.finer("entering SpectrogramRenderer.updatePlotImage");
        ++this.updateImageCount;
        this.reportCount();
        lparent = this.getParent();
        this.xrangeWarning = null;
        if (lparent == null) {
            return;
        }
        fds = this.ds;
        lraster = this.raster;
        try {
            block42: {
                block41: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block44: {
                                        var8_7 = this.lockObject;
                                        // MONITORENTER : var8_7
                                        plotImageBounds2 = lparent.getUpdateImageBounds();
                                        if (lraster == null || this.xmemento == null || this.ymemento == null || !xAxis.getMemento().equals(this.xmemento) || !yAxis.getMemento().equals(this.ymemento) || !this.colorBar.getMemento().equals(this.cmemento) || plotImageBounds2.width != this.rasterWidth || plotImageBounds2.height != this.rasterHeight) break block44;
                                        SpectrogramRenderer.logger.fine("same xaxis, yaxis, reusing raster");
                                        ** GOTO lbl126
                                    }
                                    if (plotImageBounds2 == null || plotImageBounds2.width <= 1 || plotImageBounds2.height <= 1) {
                                        SpectrogramRenderer.logger.finest("canvas not useable!!!");
                                        // MONITOREXIT : var8_7
                                        return;
                                    }
                                    if (fds != null) break block37;
                                    SpectrogramRenderer.logger.fine("got null dataset, setting image to null");
                                    this.plotImage = null;
                                    this.plotImageBounds = null;
                                    this.rebinDataSet = null;
                                    this.imageXRange = null;
                                    this.imageYRange = null;
                                    lparent.repaint();
                                    // MONITOREXIT : var8_7
                                    lparent.repaint();
                                    return;
                                }
                                if (fds.length() != 0) break block38;
                                SpectrogramRenderer.logger.fine("got empty dataset, setting image to null");
                                this.plotImage = null;
                                this.plotImageBounds = null;
                                this.rebinDataSet = null;
                                this.imageXRange = null;
                                this.imageYRange = null;
                                lparent.repaint();
                                // MONITOREXIT : var8_7
                                lparent.repaint();
                                return;
                            }
                            if (fds.rank() == 2) {
                                xunits = SemanticOps.getUnits((QDataSet)SemanticOps.xtagsDataSet((QDataSet)fds));
                                yunits = SemanticOps.isJoin((QDataSet)fds) ? SemanticOps.getUnits((QDataSet)SemanticOps.xtagsDataSet((QDataSet)fds.slice(0))) : SemanticOps.getUnits((QDataSet)SemanticOps.ytagsDataSet((QDataSet)fds));
                            } else {
                                xunits = SemanticOps.getUnits((QDataSet)SemanticOps.xtagsDataSet((QDataSet)fds.slice(0)));
                                yunits = SemanticOps.getUnits((QDataSet)SemanticOps.ytagsDataSet((QDataSet)fds.slice(0)));
                            }
                            if (xunits.isConvertableTo(xAxis.getUnits())) break block39;
                            SpectrogramRenderer.logger.fine("dataset units are incompatable with x axis.");
                            this.plotImage = null;
                            this.plotImageBounds = null;
                            // MONITOREXIT : var8_7
                            lparent.repaint();
                            return;
                        }
                        if (yunits.isConvertableTo(yAxis.getUnits())) break block40;
                        SpectrogramRenderer.logger.fine("dataset units are incompatable with y axis.");
                        this.plotImage = null;
                        this.plotImageBounds = null;
                        // MONITOREXIT : var8_7
                        lparent.repaint();
                        return;
                    }
                    if (SemanticOps.isTableDataSet((QDataSet)fds)) break block41;
                    SpectrogramRenderer.logger.fine("dataset is not TableDataSet.");
                    this.plotImage = null;
                    this.plotImageBounds = null;
                    // MONITOREXIT : var8_7
                    lparent.repaint();
                    return;
                }
                if (SemanticOps.getUnits((QDataSet)fds).isConvertableTo(this.colorBar.getUnits())) break block42;
                SpectrogramRenderer.logger.fine("dataset units are incompatable with colorbar.");
                this.plotImage = null;
                this.plotImageBounds = null;
                // MONITOREXIT : var8_7
                lparent.repaint();
                return;
            }
            xRebinDescriptor = new RebinDescriptor(xAxis.invTransform(plotImageBounds2.x), xAxis.invTransform(plotImageBounds2.x + plotImageBounds2.width), plotImageBounds2.width, xAxis.isLog());
            yRebinDescriptor = new RebinDescriptor(yAxis.invTransform(plotImageBounds2.y + plotImageBounds2.height), yAxis.invTransform(plotImageBounds2.y), plotImageBounds2.height, yAxis.isLog());
            this.imageXRange = xAxis.getDatumRange();
            this.imageYRange = yAxis.getDatumRange();
            SpectrogramRenderer.logger.log(Level.FINE, "rebinning to pixel resolution: {0}  {1}", new Object[]{xRebinDescriptor, yRebinDescriptor});
            SpectrogramRenderer.logger.log(Level.FINE, "rebinning to pixel resolution: {0}", plotImageBounds2);
            rebinner = this.rebinnerEnum.getRebinner();
            t0 = System.currentTimeMillis();
            bounds = this.bounds(fds);
            xuc = xunits.getConverter(xRebinDescriptor.getUnits());
            start = xuc.convert(bounds.value(0, 0));
            end = xuc.convert(bounds.value(0, 1));
            if (start > this.imageXRange.max().doubleValue(xRebinDescriptor.getUnits())) {
                this.xrangeWarning = "data starts after range";
            } else if (end < this.imageXRange.min().doubleValue(xRebinDescriptor.getUnits())) {
                this.xrangeWarning = "data ends before range";
            }
            this.rebinDataSet = rebinner.rebin(fds, xRebinDescriptor, yRebinDescriptor);
            this.xmemento = xAxis.getMemento();
            this.ymemento = yAxis.getMemento();
            this.cmemento = this.colorBar.getMemento();
            SpectrogramRenderer.logger.log(Level.FINE, "rebinning to pixel resolution: {0}  {1}", new Object[]{this.xmemento, this.ymemento});
            lraster = SpectrogramRenderer.makePixMap(this.rebinDataSet, lraster);
            try {
                this.validCount = SpectrogramRenderer.transformSimpleTableDataSet(this.rebinDataSet, this.colorBar, yAxis.isFlipped(), lraster);
            }
            catch (InconvertibleUnitsException ex) {
                System.err.println("zunits=" + SemanticOps.getUnits((QDataSet)fds) + "  colorbar=" + this.colorBar.getUnits());
                // MONITOREXIT : var8_7
                lparent.repaint();
                return;
            }
            this.rasterWidth = plotImageBounds2.width;
            this.rasterHeight = plotImageBounds2.height;
            this.raster = lraster;
lbl126:
            // 2 sources

            model = this.colorBar.getIndexColorModel();
            plotImage2 = new BufferedImage(plotImageBounds2.width, plotImageBounds2.height, 13, model);
            r = plotImage2.getRaster();
            if (plotImageBounds2.width == this.rasterWidth && plotImageBounds2.height == this.rasterHeight) {
                try {
                    r.setDataElements(0, 0, this.rasterWidth, this.rasterHeight, lraster);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("avoided raster ArrayIndex... track this down sometime...");
            }
            this.plotImage = plotImage2;
            this.plotImageBounds = plotImageBounds2;
            this.raster = lraster;
            rr = DasDevicePosition.toRectangle(this.parent.getRow(), this.parent.getColumn());
            if (fds != null) {
                bounds = this.bounds(fds);
                xdr = DataSetUtil.asDatumRange((QDataSet)bounds.slice(0), (boolean)true);
                ydr = DataSetUtil.asDatumRange((QDataSet)bounds.slice(1), (boolean)true);
                yy = GraphUtil.transformRange(yAxis, ydr);
                xx = GraphUtil.transformRange(xAxis, xdr);
                this.selectionArea = rr.intersection(new Rectangle((int)xx[0], (int)yy[0], (int)(xx[1] - xx[0]), (int)(yy[1] - yy[0])));
            }
            // MONITOREXIT : var8_7
            return;
        }
        catch (InconvertibleUnitsException ex) {
            SpectrogramRenderer.logger.fine("inconvertible units, setting image to null");
            ex.printStackTrace();
            this.plotImage = null;
            this.plotImageBounds = null;
            this.rebinDataSet = null;
            this.imageXRange = null;
            this.imageYRange = null;
            if (this.getLastException() == null) {
                this.setException((Exception)ex);
            }
            lparent.repaint();
            lparent.repaint();
            return;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return;
        }
        catch (NoDataInIntervalException e) {
            this.lastException = e;
            this.plotImage = null;
            return;
        }
        finally {
            lparent.repaint();
        }
    }

    protected void installRenderer() {
        if (this.parent != null && this.parent.getCanvas() != null && this.colorBar != null) {
            if (this.colorBar.getColumn() == DasColumn.NULL) {
                DasColumn column = this.parent.getColumn();
                this.colorBar.setColumn(new DasColumn(null, column, 1.0, 1.0, 1.0, 2.0, 0, 0));
            }
            this.parent.getCanvas().add(this.colorBar, this.parent.getRow(), this.colorBar.getColumn());
            if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
                DasMouseInputAdapter mouseAdapter = this.parent.mouseAdapter;
                VerticalSpectrogramSlicer vSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
                VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
                vsl.addDataPointSelectionListener(vSlicer);
                mouseAdapter.addMouseModule(vsl);
                HorizontalSpectrogramSlicer hSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
                HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
                hsl.addDataPointSelectionListener(hSlicer);
                mouseAdapter.addMouseModule(hsl);
                VerticalSpectrogramAverager vAverager = VerticalSpectrogramAverager.createAverager(this.parent, this);
                HorizontalDragRangeSelectorMouseModule vrl = new HorizontalDragRangeSelectorMouseModule(this.parent, this, this.parent.getXAxis());
                vrl.addDataRangeSelectionListener(vAverager);
                mouseAdapter.addMouseModule(vrl);
                CrossHairMouseModule ch = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                mouseAdapter.addMouseModule(ch);
            }
        }
    }

    protected void uninstallRenderer() {
        if (this.colorBar != null && this.colorBar.getCanvas() != null) {
            DasCanvas c = this.colorBar.getCanvas();
            boolean othersUse = false;
            for (DasCanvasComponent cc : c.getCanvasComponents()) {
                Renderer[] rr;
                if (!(cc instanceof DasPlot)) continue;
                for (Renderer r1 : rr = ((DasPlot)cc).getRenderers()) {
                    if (!(r1 instanceof SpectrogramRenderer) || r1 == this || ((SpectrogramRenderer)r1).getColorBar() != this.colorBar) continue;
                    othersUse = true;
                }
            }
            if (!othersUse) {
                this.colorBar.getCanvas().remove(this.colorBar);
            }
        }
    }

    public RebinnerEnum getRebinner() {
        return this.rebinnerEnum;
    }

    public void setRebinner(RebinnerEnum rebinnerEnum) {
        RebinnerEnum old = this.rebinnerEnum;
        if (old != rebinnerEnum) {
            this.rebinnerEnum = rebinnerEnum;
            this.raster = null;
            this.plotImage = null;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("rebinner", old, rebinnerEnum);
        }
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    public String getListLabel() {
        return "spectrogram";
    }

    public Icon getListIcon() {
        return this.rebinnerEnum.getListIcon();
    }

    public QDataSet getConsumedDataSet() {
        if (this.sliceRebinnedData) {
            return this.rebinDataSet;
        }
        return this.ds;
    }

    public void setDataSet(QDataSet ds) {
        QDataSet oldDs = this.ds;
        if (this.parent != null && oldDs != ds) {
            this.raster = null;
            this.plotImage = null;
        }
        super.setDataSet(ds);
    }

    public boolean isPrint300dpi() {
        return this.print300dpi;
    }

    public void setPrint300dpi(boolean print300dpi) {
        this.print300dpi = print300dpi;
    }

    public Shape selectionArea() {
        return this.selectionArea;
    }

    public boolean acceptContext(int x, int y) {
        return this.selectionArea != null && this.selectionArea.contains(x, y);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public static class RebinnerEnum
    implements Enumeration {
        DataSetRebinner rebinner;
        String label;
        public static final RebinnerEnum binAverage = new RebinnerEnum(new AverageTableRebinner(), "binAverage");
        public static final RebinnerEnum nearestNeighbor;
        public static final RebinnerEnum binAverageNoInterpolate;
        public static final RebinnerEnum binAverageNoInterpolateNoEnlarge;

        public RebinnerEnum(DataSetRebinner rebinner, String label) {
            this.rebinner = rebinner;
            this.label = label;
        }

        public Icon getListIcon() {
            return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/rebin." + this.label + ".png"));
        }

        public String toString() {
            return this.label;
        }

        DataSetRebinner getRebinner() {
            return this.rebinner;
        }

        static {
            AverageTableRebinner rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            binAverageNoInterpolate = new RebinnerEnum(rebinner, "noInterpolate");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            rebinner.setEnlargePixels(false);
            binAverageNoInterpolateNoEnlarge = new RebinnerEnum(rebinner, "noInterpolateNoEnlarge");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolateType(AverageTableRebinner.Interpolate.NearestNeighbor);
            nearestNeighbor = new RebinnerEnum(rebinner, "nearestNeighbor");
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            SpectrogramRenderer.this.update();
        }
    }
}

