/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.das2.DasException;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.util.DasDie;
import org.das2.util.monitor.ProgressMonitor;

public class StippledTableRenderer
extends Renderer {
    Image plotImage;
    Units zUnits = Units.dimensionless;
    RebinListener rebinListener = new RebinListener();
    int count = 0;
    private boolean sliceRebinnedData = true;

    public StippledTableRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    public StippledTableRenderer(DasPlot parent, DataSetDescriptor dsd) {
        this(dsd);
        this.parent = parent;
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(g2, xAxis, yAxis, this.lastException);
        } else if (this.plotImage != null) {
            Point2D.Float p = new Point2D.Float(xAxis.getColumn().getDMinimum(), yAxis.getRow().getDMinimum());
            int x = (int)(((Point2D)p).getX() + 0.5);
            int y = (int)(((Point2D)p).getY() + 0.5);
            g2.drawImage(this.plotImage, x, y, this.getParent());
        }
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        super.updatePlotImage(xAxis, yAxis, monitor);
        try {
            if (monitor != null) {
                if (monitor.isCancelled()) {
                    return;
                }
                monitor.setTaskSize(-1L);
                monitor.started();
            }
            int w = xAxis.getColumn().getDMaximum() - xAxis.getColumn().getDMinimum();
            int h = yAxis.getRow().getDMaximum() - yAxis.getRow().getDMinimum();
            if (this.getParent() == null || w <= 1 || h <= 1) {
                DasDie.println((String)"canvas not useable!!!");
                return;
            }
            if (this.getDataSet() == null) {
                double[] yTags;
                Units xUnits = this.getParent().getXAxis().getUnits();
                Units yUnits = this.getParent().getYAxis().getUnits();
                double[] xTags = yTags = new double[0];
                double[][] zValues = new double[][]{yTags};
                DefaultTableDataSet rebinData = new DefaultTableDataSet(xTags, xUnits, yTags, yUnits, zValues, this.zUnits, Collections.EMPTY_MAP);
                this.plotImage = null;
                rebinData = null;
                this.getParent().repaint();
                return;
            }
            RebinDescriptor xRebinDescriptor = new RebinDescriptor(xAxis.getDataMinimum(), xAxis.getDataMaximum(), w, xAxis.isLog());
            RebinDescriptor yRebinDescriptor = new RebinDescriptor(yAxis.getDataMinimum(), yAxis.getDataMaximum(), h, yAxis.isLog());
            AverageTableRebinner rebinner = new AverageTableRebinner();
            TableDataSet rebinData = (TableDataSet)rebinner.rebin(this.getDataSet(), xRebinDescriptor, yRebinDescriptor);
            int itable = 0;
            int ny = rebinData.getYLength(itable);
            int nx = rebinData.tableEnd(itable) - rebinData.tableStart(itable);
            BufferedImage image = new BufferedImage(w, h, 6);
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.setColor(Color.BLACK);
            Units zunits = rebinData.getZUnits();
            double maxn = 0.0;
            for (int i = rebinData.tableStart(itable); i < rebinData.tableEnd(itable); ++i) {
                for (int j = 0; j < ny; ++j) {
                    double z = rebinData.getDouble(i, j, this.zUnits);
                    if (zunits.isFill(z)) continue;
                    double n = Math.log10(Math.max(z *= 200.0, 1.0E-6));
                    if (n > maxn) {
                        maxn = n;
                    }
                    if (!(Math.random() < n)) continue;
                    g.fillRect(i, ny - j, 1, 1);
                }
            }
            this.plotImage = image;
        }
        finally {
            if (monitor != null) {
                if (monitor.isCancelled()) {
                    return;
                }
                monitor.finished();
            }
            this.getParent().repaint();
        }
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            StippledTableRenderer.this.update();
        }
    }
}

