/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.DasProperties;
import org.das2.datum.Datum;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.graph.DataRange;

public class TimeRangeLabel
extends DasCanvasComponent {
    private static final DatumFormatter MINUTES;
    private static final DatumFormatter SECONDS;
    private static final DatumFormatter MILLISECONDS;
    private boolean rangeLabel;
    private DataRange dataRange;
    private DatumFormatter df;
    double emOffset = 2.0;
    private boolean startOnly = false;

    public TimeRangeLabel(DataRange dataRange) {
        this.dataRange = dataRange;
        DataRangePropertyChangeListener listener = new DataRangePropertyChangeListener();
        dataRange.addPropertyChangeListener("minimum", listener);
        dataRange.addPropertyChangeListener("maximum", listener);
        this.updateFormatter();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHints(DasProperties.getRenderingHints());
        Datum min = Datum.create((double)this.dataRange.getMinimum(), (Units)this.dataRange.getUnits());
        Datum max = Datum.create((double)this.dataRange.getMaximum(), (Units)this.dataRange.getUnits());
        FontMetrics fm = g.getFontMetrics();
        int y = this.getRow().getDMinimum();
        int x = this.getColumn().getDMinimum();
        g.translate(-this.getX(), -this.getY());
        int yLevel = y - (int)((double)this.getFont().getSize() * this.emOffset + 0.5);
        if (this.rangeLabel) {
            String label = this.dataRange.getDatumRange().toString();
            g.drawString(label, x, yLevel);
            return;
        }
        g.drawString(this.df.format(min), x, yLevel);
        if (!this.startOnly) {
            String label = this.df.format(max);
            g.drawString(label, x += this.getColumn().getWidth() - fm.stringWidth(label), yLevel);
        }
    }

    public void resize() {
        Rectangle bounds = new Rectangle(this.getColumn().getDMinimum() - 30, this.getRow().getDMinimum() - (int)((double)this.getFont().getSize() * (this.emOffset + 1.0) + 0.5), this.getColumn().getWidth() + 60, this.getFont().getSize() * 3);
        this.setBounds(bounds);
    }

    private void updateFormatter() {
        UnitsConverter converter = Units.getConverter((Units)this.dataRange.getUnits(), (Units)Units.t2000);
        double min = converter.convert(this.dataRange.getMinimum());
        double max = converter.convert(this.dataRange.getMinimum());
        min = this.secondsSinceMidnight(min);
        max = this.secondsSinceMidnight(max);
        int minMS = (int)(min * 1000.0);
        int maxMS = (int)(max * 1000.0);
        this.df = minMS % 1000 != 0 || maxMS % 1000 != 0 ? MILLISECONDS : (minMS % 60000 != 0 || maxMS % 60000 != 0 ? SECONDS : MINUTES);
    }

    private double secondsSinceMidnight(double t2000) {
        if (t2000 < 0.0) {
            if ((t2000 %= 86400.0) == 0.0) {
                return 0.0;
            }
            return 86400.0 + t2000;
        }
        return t2000 % 86400.0;
    }

    public PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (propertyName.equals("log")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.firePropertyChange("log", oldValue, newValue);
                } else if (propertyName.equals("minimum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.updateFormatter();
                    TimeRangeLabel.this.firePropertyChange("dataMinimum", oldValue, newValue);
                } else if (propertyName.equals("maximum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.updateFormatter();
                    TimeRangeLabel.this.firePropertyChange("dataMaximum", oldValue, newValue);
                }
                TimeRangeLabel.this.markDirty();
            }
        };
    }

    public boolean isStartOnly() {
        return this.startOnly;
    }

    public void setStartOnly(boolean b) {
        this.startOnly = b;
        if (this.isDisplayable()) {
            this.repaint();
        }
    }

    public void setRangeLabel(boolean b) {
        this.rangeLabel = b;
        this.repaint();
    }

    public boolean isRangeLabel() {
        return this.rangeLabel;
    }

    public double getEmOffset() {
        return this.emOffset;
    }

    public void setEmOffset(double emOffset) {
        this.emOffset = emOffset;
        if (this.getCanvas() != null) {
            this.resize();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame();
        jframe.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        DasCanvas canvas = new DasCanvas(300, 300);
        DasRow row1 = new DasRow(canvas, 0.1, 0.2);
        DasRow row2 = new DasRow(canvas, 0.3, 0.4);
        DasRow row3 = new DasRow(canvas, 0.5, 0.6);
        DasRow row4 = new DasRow(canvas, 0.7, 0.8);
        DasColumn column = new DasColumn(canvas, 0.1, 0.9);
        DataRange dataRange1 = new DataRange(null, TimeUtil.createValid((String)"1998-01-01 12:20"), TimeUtil.createValid((String)"1999-01-01"), false);
        DataRange dataRange2 = new DataRange(null, TimeUtil.createValid((String)"1998-01-02 12:30:02"), TimeUtil.createValid((String)"1999-01-01"), false);
        DataRange dataRange3 = new DataRange(null, TimeUtil.createValid((String)"1998-01-03 12:40:02.244"), TimeUtil.createValid((String)"1999-01-01"), false);
        canvas.add(new TimeRangeLabel(dataRange1), row1, column);
        canvas.add(new TimeRangeLabel(dataRange2), row2, column);
        canvas.add(new TimeRangeLabel(dataRange3), row3, column);
        panel.setLayout(new BorderLayout());
        panel.add((Component)canvas, "Center");
        jframe.setContentPane(panel);
        jframe.pack();
        jframe.setVisible(true);
        canvas.repaint();
    }

    static {
        try {
            MINUTES = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm");
            SECONDS = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm:ss");
            MILLISECONDS = new TimeDatumFormatter("yyyy-MM-dd '('DDD')' HH:mm:ss.SSS");
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    private class DataRangePropertyChangeListener
    implements PropertyChangeListener {
        private DataRangePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TimeRangeLabel.this.repaint();
        }
    }
}

